/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.exceptions;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.exceptions.JDBCDriverException;
import com.sap.db.jdbc.exceptions.SQLDataExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.jdbc.exceptions.SQLFeatureNotSupportedExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLIntegrityConstraintViolationExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLInvalidAuthorizationSpecExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLNonTransientConnectionExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLSyntaxErrorExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLTimeoutExceptionSapDB;
import com.sap.db.jdbc.exceptions.SQLTransactionRollbackExceptionSapDB;
import com.sap.db.util.MessageTranslator;
import java.sql.SQLException;

@ThreadSafe
public class SQLExceptionSapDB
extends SQLException
implements SQLExceptionSapDBInterface {
    public static final int[] NO_UPDATE_COUNTS = new int[0];
    private final int _errorPos;
    private final int[] _updateCounts;
    private final String _prefix;

    public static SQLException newInstance(String messageKey, String ... args) {
        return SQLExceptionSapDB._newInstance(MessageTranslator.translate(messageKey, args), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, RteReturnCode.SQLOK, NO_UPDATE_COUNTS);
    }

    public static SQLException newInstance(Throwable cause, String messageKey, String ... args) {
        return SQLExceptionSapDB._newInstance(cause, MessageTranslator.translate(messageKey, args), MessageTranslator.getSQLState(messageKey), MessageTranslator.getMessageID(messageKey), 0, RteReturnCode.SQLOK, NO_UPDATE_COUNTS);
    }

    public static SQLException newInstance(String messageKey, String sqlState, int vendorCode, int errorPos, RteReturnCode rteReturnCode, int[] updateCounts, String ... args) {
        return SQLExceptionSapDB._newInstance(MessageTranslator.translate(messageKey, args), sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
    }

    public static SQLException newInstance(Throwable cause, String messageKey, String sqlState, int vendorCode, int errorPos, RteReturnCode rteReturnCode, int[] updateCounts, String ... args) {
        return SQLExceptionSapDB._newInstance(cause, MessageTranslator.translate(messageKey, args), sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
    }

    public static SQLException newInstanceWithMessage(Throwable cause, String message, String sqlState, int vendorCode, int errorPos, RteReturnCode rteReturnCode, int[] updateCounts) {
        return SQLExceptionSapDB._newInstance(cause, message, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
    }

    SQLExceptionSapDB(String reason, String sqlState, int vendorCode, int errorPos, int[] updateCounts, String prefix) {
        super(reason, sqlState, vendorCode);
        this._errorPos = errorPos;
        this._updateCounts = updateCounts;
        this._prefix = prefix;
    }

    @Override
    public int getErrorPos() {
        return this._errorPos;
    }

    @Override
    public RteReturnCode getRTEReturnCode() {
        return RteReturnCode.SQLOK;
    }

    @Override
    public int[] getUpdateCountsFromLastPacket() {
        return this._updateCounts == null || this._updateCounts.length == 0 ? this._updateCounts : (int[])this._updateCounts.clone();
    }

    @Override
    public boolean isConnectionReleasing() {
        switch (this.getErrorCode()) {
            case -904: 
            case -813: 
            case -709: 
            case -708: 
            case -75: 
            case -71: 
            case -70: 
            case 700: 
            case 710: 
            case 750: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getMessage() {
        return this._prefix + super.getMessage();
    }

    private static SQLException _newInstance(String reason, String sqlState, int vendorCode, int errorPos, RteReturnCode rteReturnCode, int[] updateCounts) {
        if (sqlState == null || sqlState.length() != 5) {
            return new JDBCDriverException(reason, "HY000", vendorCode, errorPos, updateCounts);
        }
        char state1 = sqlState.charAt(0);
        char state2 = sqlState.charAt(1);
        switch (state1) {
            case '0': {
                if (state2 == '8') {
                    return new SQLNonTransientConnectionExceptionSapDB(reason, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
                }
                if (state2 != 'A') break;
                return new SQLFeatureNotSupportedExceptionSapDB(reason, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
            }
            case '2': {
                if (state2 == '2') {
                    return new SQLDataExceptionSapDB(reason, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
                }
                if (state2 == '3') {
                    return new SQLIntegrityConstraintViolationExceptionSapDB(reason, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
                }
                if (state2 != '8') break;
                return new SQLInvalidAuthorizationSpecExceptionSapDB(reason, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
            }
            case '4': {
                if (state2 == '0') {
                    return new SQLTransactionRollbackExceptionSapDB(reason, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
                }
                if (state2 != '2') break;
                return new SQLSyntaxErrorExceptionSapDB(reason, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
            }
            case 'H': {
                if (state2 != 'Y') break;
                if (sqlState.equals("HY000") && vendorCode == 613) {
                    return new SQLTimeoutExceptionSapDB(reason, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
                }
                return new JDBCDriverException(reason, sqlState, vendorCode, errorPos, updateCounts);
            }
        }
        return new JDBCDriverException(reason, sqlState, vendorCode, errorPos, updateCounts);
    }

    private static SQLException _newInstance(Throwable cause, String errText, String sqlState, int vendorCode, int errorPos, RteReturnCode rteReturnCode, int[] updateCounts) {
        SQLException e = SQLExceptionSapDB._newInstance(errText, sqlState, vendorCode, errorPos, rteReturnCode, updateCounts);
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }
}

