/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractDateTimeConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

@ThreadSafe
class TimeConverter
extends AbstractDateTimeConverter {
    protected TimeConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(4) + 1;
        }
        return 4;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(4) + 2;
        }
        return 5;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof byte[])) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        byte[] value = (byte[])data;
        if (this._isEncrypted) {
            byte[] encrypted = this._getEncryptedBuffer(value);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putBytesAsTime(value);
    }

    @Override
    protected int _getNullInputArgLength() {
        if (this._isEncrypted && !this._isDeterministic) {
            return this._cipher.getEncryptedLength(4) + 2;
        }
        return 1;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putInt(0, new byte[4], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(this._dataType);
    }

    @Override
    public int getPrecision() {
        return 8;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        return this._getValueAsTime(controller, dataPart, null, false);
    }

    @Override
    public Object setObject(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return this.setTime((Time)value, null);
        }
        if (value instanceof Timestamp) {
            return this.setTimestamp((Timestamp)value, null);
        }
        if (value instanceof Date) {
            Date utilDate = (Date)value;
            return this.setTime(new Time(utilDate.getTime()), null);
        }
        if (value instanceof String) {
            return this.setString((String)value);
        }
        return this._defaultSetObject(value);
    }

    @Override
    public java.sql.Date getDate(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Time time = this._getValueAsTime(controller, dataPart, cal, true);
        return time != null ? new java.sql.Date(time.getTime()) : null;
    }

    @Override
    public Time getTime(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        return this._getValueAsTime(controller, dataPart, cal, false);
    }

    public byte[] setTime(Time value, Calendar cal) throws SQLException {
        return value != null ? TimeConverter._convertMillisecondsToTime(value.getTime(), this._getCalendar(cal)) : null;
    }

    @Override
    public Timestamp getTimestamp(SQLParamController controller, HDataPart dataPart, Calendar cal) throws SQLException {
        Time time = this._getValueAsTime(controller, dataPart, cal, true);
        return time != null ? new Timestamp(time.getTime()) : null;
    }

    public byte[] setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        return value != null ? TimeConverter._convertMillisecondsToTime(value.getTime(), this._getCalendar(cal)) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        Time time = this._getValueAsTime(controller, dataPart, null, false);
        return time != null ? String.valueOf(time) : null;
    }

    public byte[] setString(String value) throws SQLException {
        return value != null ? TimeConverter._convertStringToTime(value, this._getCalendar(null)) : null;
    }

    private Time _getValueAsTime(SQLParamController controller, HDataPart dataPart, Calendar cal, boolean setCurrentDate) throws SQLException {
        int offset;
        byte[] buffer;
        byte[] decrypted;
        byte[] byArray = decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        if (dataPart.isNull(this, controller, decrypted)) {
            return null;
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            buffer = decrypted;
            offset = 0;
        } else {
            buffer = dataPart.getRawPacketArray();
            offset = dataPart.getNonNullDataOffset();
        }
        return new Time(TimeConverter._convertTimeToMilliseconds(buffer, offset, this._getCalendar(cal), setCurrentDate));
    }
}

