/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.BasicSession;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.HReplyPacket;

@NotThreadSafe
public class LatencySession
extends BasicSession {
    private final int _latency;

    LatencySession(ConnectionSapDB connection, Address address) throws RTEException {
        super(connection, address);
        this._latency = this._connectionProperties.getIntProperty(ConnectionProperty.LATENCY);
    }

    @Override
    protected HReplyPacket _receivePacket(EngineFeatures engineFeatures) throws RTEException {
        this._createLatency();
        return super._receivePacket(engineFeatures);
    }

    private void _createLatency() {
        try {
            Thread.sleep(this._latency);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

