/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.APIMetrics;
import com.sap.db.jdbc.CleanableSapDB;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.PhantomCleanableSapDB;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionPool;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
class CleanableSapDBImpl {
    CleanableSapDBImpl() {
    }

    static void cleanAll() {
        PhantomCleanableSapDB ref;
        while ((ref = (PhantomCleanableSapDB)CleanableSapDB.REFERENCE_QUEUE.poll()) != null) {
            CleanableSapDBImpl.clean(ref);
        }
    }

    static void clean(PhantomCleanableSapDB ref) {
        try {
            ref.getRunnable().run();
        }
        finally {
            CleanableSapDB.PHANTOM_SET.remove(ref);
            ref.clear();
        }
    }

    static class ResultSetCleaner
    implements Runnable {
        private final Tracer _tracer;
        private final String _className;
        private final int _hashCode;
        private final String _instanceClassName;
        private final String _instanceString;
        private final ConnectionSapDB _connection;
        private final Session _session;
        private final CursorID _cursorID;
        private final ParseInfo _metaDataStatementParseInfo;
        private final AtomicBoolean _isClosed;
        private final AtomicBoolean _isClosedOnServer;
        private final AtomicBoolean _isClosePending;
        private final AtomicReference<PassportListener> _passportListener;

        ResultSetCleaner(ResultSetSapDB resultSet) {
            this._tracer = resultSet._tracer;
            this._className = resultSet.getClass().getName();
            this._hashCode = resultSet.hashCode();
            this._instanceClassName = resultSet.getInstanceClassName();
            this._instanceString = resultSet.getInstanceString();
            this._connection = resultSet.getConnectionSapDB();
            this._session = resultSet._getSession();
            this._cursorID = resultSet._getCursorID();
            this._metaDataStatementParseInfo = resultSet._getMetaDataStatementParseInfo();
            this._isClosed = resultSet._isClosed;
            this._isClosedOnServer = resultSet._isClosedOnServer;
            this._isClosePending = resultSet._isClosePending;
            this._passportListener = this._connection._passportListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @JDBCAPI(packetExchange="true")
        public void run() {
            boolean on = this._tracer.on();
            boolean aon = on ? this._tracer.aon() : false;
            PassportListener pl = this._passportListener.get();
            try {
                if (on) {
                    this._tracer.printCleaning(ResultSetSapDB.getTraceString(this._className, this._hashCode, true, this._isClosed.get(), this._isClosePending.get()));
                }
                try {
                    if (aon || pl != null) {
                        APIMetrics.getInstance().apiStart();
                    }
                    ResultSetSapDB._clean(this._instanceClassName, this._connection, this._session, this._cursorID, this._metaDataStatementParseInfo, this._isClosed, this._isClosedOnServer);
                }
                finally {
                    if (aon || pl != null) {
                        APIMetrics.getInstance().apiFinish(aon, pl);
                    }
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (on) {
                    this._tracer.printCleaned();
                }
            }
        }
    }

    static class PreparedStatementCleaner
    implements Runnable {
        private final Tracer _tracer;
        private final String _className;
        private final int _hashCode;
        private final String _instanceClassName;
        private final String _instanceString;
        private final ConnectionSapDB _connection;
        private final AtomicReference<ParseInfo> _parseInfo;
        private final AtomicBoolean _isPoolable;
        private final AtomicBoolean _isClosed;
        private final AtomicBoolean _isClosePending;
        private final AtomicReference<PassportListener> _passportListener;

        PreparedStatementCleaner(PreparedStatementSapDB statement) {
            this._tracer = statement._tracer;
            this._className = statement.getClass().getName();
            this._hashCode = statement.hashCode();
            this._instanceClassName = statement.getInstanceClassName();
            this._instanceString = statement.getInstanceString();
            this._connection = statement.getConnectionSapDB();
            this._parseInfo = statement._parseInfo;
            this._isPoolable = statement._isPoolable;
            this._isClosed = statement._isClosed;
            this._isClosePending = statement._isClosePending;
            this._passportListener = this._connection._passportListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @JDBCAPI(packetExchange="true")
        public void run() {
            boolean on = this._tracer.on();
            boolean aon = on ? this._tracer.aon() : false;
            PassportListener pl = this._passportListener.get();
            try {
                if (on) {
                    this._tracer.printCleaning(StatementSapDB.getTraceString(this._className, this._hashCode, true, this._isClosed.get(), this._isClosePending.get()));
                }
                try {
                    if (aon || pl != null) {
                        APIMetrics.getInstance().apiStart();
                    }
                    PreparedStatementSapDB._clean(this._instanceClassName, this._connection, this._parseInfo, this._isPoolable, this._isClosed);
                }
                finally {
                    if (aon || pl != null) {
                        APIMetrics.getInstance().apiFinish(aon, pl);
                    }
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (on) {
                    this._tracer.printCleaned();
                }
            }
        }
    }

    static class ConnectionCleaner
    implements Runnable {
        private final Tracer _tracer;
        private final String _className;
        private final int _hashCode;
        private final String _instanceClassName;
        private final String _instanceString;
        private final SessionPool _sessionPool;
        private final AtomicBoolean _isClosed;
        private final AtomicReference<PassportListener> _passportListener;

        ConnectionCleaner(ConnectionSapDB connection) {
            this._tracer = connection._tracer;
            this._className = connection.getClass().getName();
            this._hashCode = connection.hashCode();
            this._instanceClassName = connection.getInstanceClassName();
            this._instanceString = connection.getInstanceString();
            this._sessionPool = connection.getSessionPool();
            this._isClosed = connection._isClosed;
            this._passportListener = connection._passportListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @JDBCAPI(packetExchange="true")
        public void run() {
            boolean on = this._tracer.on();
            boolean aon = on ? this._tracer.aon() : false;
            PassportListener pl = this._passportListener.get();
            try {
                if (on) {
                    Session anchorSession;
                    this._tracer.printCleaning(ConnectionSapDB.getTraceString(this._className, this._hashCode, true, this._isClosed.get(), (anchorSession = this._sessionPool.getAnchorSession()) != null ? anchorSession.getConnectionID() : -1));
                }
                try {
                    if (aon || pl != null) {
                        APIMetrics.getInstance().apiStart();
                    }
                    ConnectionSapDB._clean(this._instanceClassName, this._sessionPool, this._isClosed);
                }
                finally {
                    if (aon || pl != null) {
                        APIMetrics.getInstance().apiFinish(aon, pl);
                    }
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (on) {
                    this._tracer.printCleaned();
                }
            }
        }
    }
}

