/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.InternalCallableStatementSapDB;
import com.sap.db.jdbc.InternalPreparedStatementSapDB;
import com.sap.db.jdbc.InternalResultSetSapDB;
import com.sap.db.jdbc.InternalStatementSapDB;
import com.sap.db.jdbc.ParameterMetaDataSapDB;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.StringUtils;
import com.sap.db.util.VersionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Locale;

@ThreadSafe
abstract class DatabaseMetaDataSapDB
extends WrapperDummy
implements DatabaseMetaData {
    private static final String NUMERIC_FUNCTIONS = "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,EXP,FLOOR,LOG,LOG10,MOD,POWER,ROUND,SIGN,SIN,SQRT,TAN";
    private static final String STRING_FUNCTIONS = "ASCII,CHAR,CONCAT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPLACE,RIGHT,RTRIM,SUBSTRING,UCASE";
    private static final String SYSTEM_FUNCTIONS = "DATABASE,IFNULL,USER";
    private static final String TIME_DATE_FUNCTIONS = "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,SECOND,WEEK,YEAR";
    private static final int MAX_SCHEMA_NAME_LENGTH = 127;
    private static final int MAX_TABLE_NAME_LENGTH = 127;
    private static final int MAX_COLUMN_NAME_LENGTH = 127;
    private static final int MAX_PROCEDURE_NAME_LENGTH = 127;
    protected final Tracer _tracer;
    protected final ConnectionSapDB _connection;
    private final String _dbUrl;
    @GuardedBy(value="this")
    private VersionInfo _dbVersionInfo;
    @GuardedBy(value="this")
    private String _userName;
    @GuardedBy(value="this")
    private String[] _tableTypes;

    protected DatabaseMetaDataSapDB(Tracer tracer, ConnectionSapDB connection) {
        this._tracer = tracer;
        this._connection = connection;
        this._dbUrl = this._connection.getConnectionProperty(ConnectionProperty.DBURL);
        this._getDBInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean allProceduresAreCallable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("allProceduresAreCallable") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "allProceduresAreCallable", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean allTablesAreSelectable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("allTablesAreSelectable") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "allTablesAreSelectable", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getURL() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getURL") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getURL", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._dbUrl;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public String getUserName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getUserName") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getUserName", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._getUserName();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isReadOnly() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("isReadOnly") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isReadOnly", new Object[0]);
            }
            try {
                Session anchor;
                if (aon) {
                    this._connection.apiStart();
                }
                result = (anchor = this._connection.getSessionPool().getAnchorSession()) != null && anchor.isSecondarySite();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean anchor = result;
            return anchor;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean nullsAreSortedHigh() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("nullsAreSortedHigh") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "nullsAreSortedHigh", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean nullsAreSortedLow() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("nullsAreSortedLow") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "nullsAreSortedLow", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean nullsAreSortedAtStart() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("nullsAreSortedAtStart") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "nullsAreSortedAtStart", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean nullsAreSortedAtEnd() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("nullsAreSortedAtEnd") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "nullsAreSortedAtEnd", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getDatabaseProductName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDatabaseProductName") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getDatabaseProductName", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = Driver.getDatabaseName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized String getDatabaseProductVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDatabaseProductVersion") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getDatabaseProductVersion", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._dbVersionInfo.toString();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getDriverName() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDriverName") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getDriverName", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = Driver.getDriverName();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getDriverVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDriverVersion") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getDriverVersion", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = Driver.getVersionInfo().toShortVersionNumberString();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getDriverMajorVersion() {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDriverMajorVersion") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getDriverMajorVersion", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = Driver.getVersionInfo().getMajorVersion();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getDriverMinorVersion() {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDriverMinorVersion") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getDriverMinorVersion", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = Driver.getVersionInfo().getMinorVersion();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean usesLocalFiles() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("usesLocalFiles") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "usesLocalFiles", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean usesLocalFilePerTable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("usesLocalFilePerTable") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "usesLocalFilePerTable", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsMixedCaseIdentifiers") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsMixedCaseIdentifiers", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("storesUpperCaseIdentifiers") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "storesUpperCaseIdentifiers", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("storesLowerCaseIdentifiers") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "storesLowerCaseIdentifiers", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("storesMixedCaseIdentifiers") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "storesMixedCaseIdentifiers", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsMixedCaseQuotedIdentifiers") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsMixedCaseQuotedIdentifiers", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("storesUpperCaseQuotedIdentifiers") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "storesUpperCaseQuotedIdentifiers", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("storesLowerCaseQuotedIdentifiers") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "storesLowerCaseQuotedIdentifiers", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("storesMixedCaseQuotedIdentifiers") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "storesMixedCaseQuotedIdentifiers", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getIdentifierQuoteString() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getIdentifierQuoteString") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getIdentifierQuoteString", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = "\"";
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getSQLKeywords() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getSQLKeywords") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getSQLKeywords", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = "";
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getNumericFunctions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getNumericFunctions") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getNumericFunctions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = NUMERIC_FUNCTIONS;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getStringFunctions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getStringFunctions") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getStringFunctions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = STRING_FUNCTIONS;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getSystemFunctions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getSystemFunctions") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getSystemFunctions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = SYSTEM_FUNCTIONS;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getTimeDateFunctions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getTimeDateFunctions") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getTimeDateFunctions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = TIME_DATE_FUNCTIONS;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getSearchStringEscape() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getSearchStringEscape") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getSearchStringEscape", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = "\\";
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getExtraNameCharacters() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getExtraNameCharacters") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getExtraNameCharacters", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = "";
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsAlterTableWithAddColumn") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsAlterTableWithAddColumn", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsAlterTableWithDropColumn") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsAlterTableWithDropColumn", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsColumnAliasing() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsColumnAliasing") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsColumnAliasing", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean nullPlusNonNullIsNull() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("nullPlusNonNullIsNull") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "nullPlusNonNullIsNull", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsConvert() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsConvert") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsConvert", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsConvert") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsConvert", fromType, toType);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsTableCorrelationNames() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsTableCorrelationNames") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsTableCorrelationNames", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsDifferentTableCorrelationNames") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsDifferentTableCorrelationNames", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsExpressionsInOrderBy") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsExpressionsInOrderBy", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsOrderByUnrelated() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsOrderByUnrelated") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsOrderByUnrelated", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsGroupBy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsGroupBy") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsGroupBy", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsGroupByUnrelated() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsGroupByUnrelated") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsGroupByUnrelated", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsGroupByBeyondSelect") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsGroupByBeyondSelect", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsLikeEscapeClause() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsLikeEscapeClause") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsLikeEscapeClause", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsMultipleResultSets() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsMultipleResultSets") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsMultipleResultSets", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsMultipleTransactions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsMultipleTransactions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsMultipleTransactions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsNonNullableColumns() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsNonNullableColumns") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsNonNullableColumns", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsMinimumSQLGrammar") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsMinimumSQLGrammar", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsCoreSQLGrammar() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsCoreSQLGrammar") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsCoreSQLGrammar", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsExtendedSQLGrammar") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsExtendedSQLGrammar", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsANSI92EntryLevelSQL") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsANSI92EntryLevelSQL", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsANSI92IntermediateSQL") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsANSI92IntermediateSQL", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsANSI92FullSQL() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsANSI92FullSQL") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsANSI92FullSQL", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsIntegrityEnhancementFacility") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsIntegrityEnhancementFacility", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsOuterJoins() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsOuterJoins") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsOuterJoins", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsFullOuterJoins() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsFullOuterJoins") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsFullOuterJoins", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsLimitedOuterJoins() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsLimitedOuterJoins") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsLimitedOuterJoins", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getSchemaTerm() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getSchemaTerm") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getSchemaTerm", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = "SCHEMA";
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getProcedureTerm() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getProcedureTerm") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getProcedureTerm", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = "PROCEDURE";
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getCatalogTerm() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getCatalogTerm") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getCatalogTerm", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = "CATALOG";
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean isCatalogAtStart() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("isCatalogAtStart") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "isCatalogAtStart", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public String getCatalogSeparator() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getCatalogSeparator") : null;
        try {
            String result;
            if (on) {
                this._tracer.printCall(this, "getCatalogSeparator", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = ".";
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInDataManipulation") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInDataManipulation", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInProcedureCalls") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInProcedureCalls", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInTableDefinitions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInTableDefinitions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInIndexDefinitions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInIndexDefinitions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSchemasInPrivilegeDefinitions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSchemasInPrivilegeDefinitions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInDataManipulation") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInDataManipulation", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInProcedureCalls") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInProcedureCalls", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInTableDefinitions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInTableDefinitions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInIndexDefinitions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInIndexDefinitions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsCatalogsInPrivilegeDefinitions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsCatalogsInPrivilegeDefinitions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsPositionedDelete() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsPositionedDelete") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsPositionedDelete", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsPositionedUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsPositionedUpdate") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsPositionedUpdate", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSelectForUpdate() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSelectForUpdate") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSelectForUpdate", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsStoredProcedures() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsStoredProcedures") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsStoredProcedures", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSubqueriesInComparisons") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSubqueriesInComparisons", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSubqueriesInExists() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSubqueriesInExists") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSubqueriesInExists", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSubqueriesInIns() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSubqueriesInIns") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSubqueriesInIns", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSubqueriesInQuantifieds") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSubqueriesInQuantifieds", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsCorrelatedSubqueries") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsCorrelatedSubqueries", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsUnion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsUnion") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsUnion", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsUnionAll() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsUnionAll") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsUnionAll", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsOpenCursorsAcrossCommit") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsOpenCursorsAcrossCommit", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsOpenCursorsAcrossRollback") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsOpenCursorsAcrossRollback", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsOpenStatementsAcrossCommit") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsOpenStatementsAcrossCommit", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsOpenStatementsAcrossRollback") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsOpenStatementsAcrossRollback", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxBinaryLiteralLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxBinaryLiteralLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxBinaryLiteralLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxCharLiteralLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxCharLiteralLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxCharLiteralLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxColumnNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnNameLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxColumnNameLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 127;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxColumnsInGroupBy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInGroupBy") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInGroupBy", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxColumnsInIndex() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInIndex") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInIndex", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxColumnsInOrderBy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInOrderBy") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInOrderBy", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxColumnsInSelect() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInSelect") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInSelect", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxColumnsInTable() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxColumnsInTable") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxColumnsInTable", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxConnections() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxConnections") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxConnections", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxCursorNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxCursorNameLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxCursorNameLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxIndexLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxIndexLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxIndexLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxSchemaNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxSchemaNameLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxSchemaNameLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 127;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxProcedureNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxProcedureNameLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxProcedureNameLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 127;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxCatalogNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxCatalogNameLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxCatalogNameLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxRowSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxRowSize") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxRowSize", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("doesMaxRowSizeIncludeBlobs") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "doesMaxRowSizeIncludeBlobs", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxStatementLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxStatementLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxStatementLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxStatements() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxStatements") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxStatements", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxTableNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxTableNameLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxTableNameLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 127;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxTablesInSelect() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxTablesInSelect") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxTablesInSelect", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMaxUserNameLength() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxUserNameLength") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxUserNameLength", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 127;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getDefaultTransactionIsolation() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDefaultTransactionIsolation") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getDefaultTransactionIsolation", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 2;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsTransactions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsTransactions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsTransactions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        on = this._tracer.on();
        pon = this._tracer.pon();
        aon = on != false ? this._tracer.aon() : false;
        r = pon != false ? this._newTraceRecord("supportsTransactionIsolationLevel") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsTransactionIsolationLevel", new Object[]{level});
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                switch (level) {
                    case 2: 
                    case 4: 
                    case 8: {
                        result = true;
                        ** break;
lbl15:
                        // 1 sources

                        break;
                    }
                    case 0: 
                    case 1: {
                        result = false;
                        ** break;
lbl19:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new SQLException("Unexpected isolation level: " + level);
                    }
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            var7_8 = result;
            return var7_8;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsDataDefinitionAndDataManipulationTransactions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsDataDefinitionAndDataManipulationTransactions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsDataManipulationTransactionsOnly") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsDataManipulationTransactionsOnly", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("dataDefinitionCausesTransactionCommit") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "dataDefinitionCausesTransactionCommit", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._connection.isDDLAutoCommit();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("dataDefinitionIgnoredInTransactions") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "dataDefinitionIgnoredInTransactions", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getProcedures") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getProcedures", catalog, schemaPattern, procedureNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_PROCEDURES");
                ics._setString(1, catalog);
                ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
                ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(procedureNamePattern));
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getProcedureColumns") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getProcedureColumns", catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_PROCEDURE_COLUMNS");
                ics._setString(1, catalog);
                ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
                ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(procedureNamePattern));
                ics._setString(4, DatabaseMetaDataSapDB._replaceForSystemQuery(columnNamePattern));
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public synchronized ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getTables") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getTables", catalog, schemaPattern, tableNamePattern, types);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_TABLES");
                ((PreparedStatementSapDB)ics)._setString(1, catalog);
                ((PreparedStatementSapDB)ics)._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
                ((PreparedStatementSapDB)ics)._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(tableNamePattern));
                int paramCnt = ((ParameterMetaDataSapDB)((PreparedStatementSapDB)ics)._getParameterMetaData())._getParameterCount();
                if (types == null) {
                    int i = 4;
                    if (this._tableTypes == null) {
                        this._initTableTypes();
                    }
                    if (paramCnt >= this._tableTypes.length) {
                        for (int j = 0; j < this._tableTypes.length; ++j) {
                            ((PreparedStatementSapDB)ics)._setString(j + i, this._tableTypes[j]);
                        }
                        i += this._tableTypes.length;
                    } else {
                        ((PreparedStatementSapDB)ics)._setString(4, "VIEW");
                        ((PreparedStatementSapDB)ics)._setString(5, "SYNONYM");
                        ((PreparedStatementSapDB)ics)._setString(6, "TABLE");
                        ((PreparedStatementSapDB)ics)._setString(7, "SYSTEM TABLE");
                        ((PreparedStatementSapDB)ics)._setString(8, "GLOBAL TEMPORARY");
                        ((PreparedStatementSapDB)ics)._setString(9, "SHARED TEMPORARY");
                        i = 10;
                        if (paramCnt >= 11) {
                            ((PreparedStatementSapDB)ics)._setString(10, "USER DEFINED");
                            ((PreparedStatementSapDB)ics)._setString(11, "COLUMN VIEW");
                            i = 12;
                        }
                        if (paramCnt >= 15) {
                            ((PreparedStatementSapDB)ics)._setString(12, "OLAP VIEW");
                            ((PreparedStatementSapDB)ics)._setString(13, "JOIN VIEW");
                            ((PreparedStatementSapDB)ics)._setString(14, "HIERARCHY VIEW");
                            ((PreparedStatementSapDB)ics)._setString(15, "CALC VIEW");
                            i = 16;
                        }
                    }
                    while (i <= paramCnt) {
                        ((PreparedStatementSapDB)ics)._setNull(i, 1111);
                        ++i;
                    }
                } else {
                    for (int i = 0; i < types.length; ++i) {
                        if (types[i] != null) {
                            types[i] = types[i].toUpperCase(Locale.ENGLISH);
                        }
                        ((PreparedStatementSapDB)ics)._setString(i + 4, types[i]);
                    }
                    for (int j = i + 4; j <= paramCnt; ++j) {
                        ((PreparedStatementSapDB)ics)._setNull(j, 1111);
                    }
                }
                result = ((PreparedStatementSapDB)ics)._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getSchemas() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getSchemas") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getSchemas", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_SCHEMAS");
                ics._setString(1, null);
                ics._setString(2, "%");
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getCatalogs() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getCatalogs") : null;
        try {
            ResultSet result;
            Wrapper ips;
            if (on) {
                this._tracer.printCall(this, "getCatalogs", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TABLE_CAT FROM SYS.DUMMY WHERE 1 <> 1");
                result = ips._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ips = result;
            return ips;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getTableTypes() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getTableTypes") : null;
        try {
            ResultSet result;
            if (on) {
                this._tracer.printCall(this, "getTableTypes", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._getTableTypes(false);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ResultSet resultSet = result;
            return resultSet;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getColumns") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_COLUMNS");
                ics._setString(1, catalog);
                ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
                ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(tableNamePattern));
                ics._setString(4, DatabaseMetaDataSapDB._replaceForSystemQuery(columnNamePattern));
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getColumnPrivileges") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getColumnPrivileges", catalog, schema, table, columnNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_COLUMN_PRIVILEGES");
                ics._setString(1, catalog);
                ics._setString(2, schema);
                ics._setString(3, table);
                ics._setString(4, DatabaseMetaDataSapDB._replaceForSystemQuery(columnNamePattern));
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getTablePrivileges") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getTablePrivileges", catalog, schemaPattern, tableNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_TABLE_PRIVILEGES");
                ics._setString(1, catalog);
                ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
                ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(tableNamePattern));
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getBestRowIdentifier") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getBestRowIdentifier", catalog, schema, table, scope, nullable);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_BEST_ROW_IDENTIFIER");
                ics._setString(1, catalog);
                ics._setString(2, schema);
                ics._setString(3, table);
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getVersionColumns") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getVersionColumns", catalog, schema, table);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_VERSION_COLUMNS");
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getPrimaryKeys") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getPrimaryKeys", catalog, schema, table);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_PRIMARY_KEYS");
                ics._setString(1, catalog);
                ics._setString(2, schema);
                ics._setString(3, table);
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getImportedKeys") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getImportedKeys", catalog, schema, table);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_IMPORTED_KEYS_NEW");
                ics._setString(1, catalog);
                ics._setString(2, schema);
                ics._setString(3, table);
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getExportedKeys") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getExportedKeys", catalog, schema, table);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_EXPORTED_KEYS_NEW");
                ics._setString(1, catalog);
                ics._setString(2, schema);
                ics._setString(3, table);
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getCrossReference") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getCrossReference", parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_CROSS_REFERENCE_NEW");
                ics._setString(1, parentCatalog);
                ics._setString(2, parentSchema);
                ics._setString(3, parentTable);
                ics._setString(4, foreignCatalog);
                ics._setString(5, foreignSchema);
                ics._setString(6, foreignTable);
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getTypeInfo() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getTypeInfo") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getTypeInfo", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_TYPE_INFO");
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getIndexInfo") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getIndexInfo", catalog, schema, table, unique, approximate);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_INDEX_INFO");
                ics._setString(1, catalog);
                ics._setString(2, schema);
                ics._setString(3, table);
                ics._setBoolean(4, unique);
                ics._setBoolean(5, approximate);
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsResultSetType(int type) throws SQLException {
        on = this._tracer.on();
        pon = this._tracer.pon();
        aon = on != false ? this._tracer.aon() : false;
        r = pon != false ? this._newTraceRecord("supportsResultSetType") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsResultSetType", new Object[]{type});
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                switch (type) {
                    case 1003: {
                        result = true;
                        ** break;
lbl15:
                        // 1 sources

                        break;
                    }
                    case 1004: 
                    case 1005: {
                        result = false;
                        ** break;
lbl19:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new SQLException("Unexpected result set type: " + type);
                    }
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            var7_8 = result;
            return var7_8;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsResultSetConcurrency") : null;
        try {
            boolean result;
            block20: {
                if (on) {
                    this._tracer.printCall(this, "supportsResultSetConcurrency", type, concurrency);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    if (type == 1003) {
                        switch (concurrency) {
                            case 1007: {
                                result = true;
                                break block20;
                            }
                            case 1008: {
                                result = false;
                                break block20;
                            }
                            default: {
                                throw new SQLException("Unexpected concurrency type: " + concurrency);
                            }
                        }
                    }
                    result = false;
                }
                finally {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("ownUpdatesAreVisible") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "ownUpdatesAreVisible", type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("ownDeletesAreVisible") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "ownDeletesAreVisible", type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("ownInsertsAreVisible") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "ownInsertsAreVisible", type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("othersUpdatesAreVisible") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "othersUpdatesAreVisible", type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("othersDeletesAreVisible") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "othersDeletesAreVisible", type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("othersInsertsAreVisible") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "othersInsertsAreVisible", type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean updatesAreDetected(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("updatesAreDetected") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "updatesAreDetected", type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean deletesAreDetected(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("deletesAreDetected") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "deletesAreDetected", type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean insertsAreDetected(int type) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("insertsAreDetected") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "insertsAreDetected", type);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsBatchUpdates() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsBatchUpdates") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsBatchUpdates", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getUDTs") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getUDTs", catalog, schemaPattern, typeNamePattern, types);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_UDTS");
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public Connection getConnection() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getConnection") : null;
        try {
            ConnectionSapDB result;
            if (on) {
                this._tracer.printCall(this, "getConnection", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._connection;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ConnectionSapDB connectionSapDB = result;
            return connectionSapDB;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsSavepoints() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsSavepoints") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsSavepoints", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._connection.getEngineFeatures().supportSavepointSQL();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsNamedParameters() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsNamedParameters") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsNamedParameters", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsMultipleOpenResults() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsMultipleOpenResults") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsMultipleOpenResults", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsGetGeneratedKeys() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsGetGeneratedKeys") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsGetGeneratedKeys", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getSuperTypes") : null;
        try {
            ResultSet result;
            Wrapper ips;
            if (on) {
                this._tracer.printCall(this, "getSuperTypes", catalog, schemaPattern, typeNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TYPE_CAT, CAST( NULL AS NVARCHAR ) AS TYPE_SCHEM, CAST( NULL AS NVARCHAR ) AS TYPE_NAME, CAST( NULL AS NVARCHAR ) AS SUPERTYPE_CAT, CAST( NULL AS NVARCHAR ) AS SUPERTYPE_SCHEM, CAST( NULL AS NVARCHAR ) AS SUPERTYPE_NAME FROM SYS.DUMMY WHERE 1 <> 1");
                result = ips._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ips = result;
            return ips;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getSuperTables") : null;
        try {
            ResultSet result;
            Wrapper ips;
            if (on) {
                this._tracer.printCall(this, "getSuperTables", catalog, schemaPattern, tableNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TABLE_CAT, CAST( NULL AS NVARCHAR ) AS TABLE_SCHEM, CAST( NULL AS NVARCHAR ) AS TABLE_NAME, CAST( NULL AS NVARCHAR ) AS SUPERTABLE_NAME FROM SYS.DUMMY WHERE 1 <> 1");
                result = ips._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ips = result;
            return ips;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getAttributes") : null;
        try {
            ResultSet result;
            Wrapper ips;
            if (on) {
                this._tracer.printCall(this, "getAttributes", catalog, schemaPattern, typeNamePattern, attributeNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TYPE_CAT, CAST( NULL AS NVARCHAR ) AS TYPE_SCHEM, CAST( NULL AS NVARCHAR ) AS TYPE_NAME, CAST( NULL AS NVARCHAR ) AS ATTR_NAME, CAST( NULL AS INTEGER ) AS DATA_TYPE, CAST( NULL AS NVARCHAR ) AS ATTR_TYPE_NAME, CAST( NULL AS INTEGER ) AS ATTR_SIZE, CAST( NULL AS INTEGER ) AS DECIMAL_DIGITS, CAST( NULL AS INTEGER ) AS NUM_PREC_RADIX, CAST( NULL AS INTEGER ) AS NULLABLE, CAST( NULL AS NVARCHAR ) AS REMARKS, CAST( NULL AS NVARCHAR ) AS ATTR_DEF, CAST( NULL AS INTEGER ) AS SQL_DATA_TYPE, CAST( NULL AS INTEGER ) AS SQL_DATETIME_SUB, CAST( NULL AS INTEGER ) AS CHAR_OCTET_LENGTH, CAST( NULL AS INTEGER ) AS ORDINAL_POSITION, CAST( NULL AS NVARCHAR ) AS IS_NULLABLE, CAST( NULL AS NVARCHAR ) AS SCOPE_CATALOG, CAST( NULL AS NVARCHAR ) AS SCOPE_SCHEMA, CAST( NULL AS NVARCHAR ) AS SCOPE_TABLE, CAST( NULL AS SMALLINT ) AS SOURCE_DATA_TYPE FROM SYS.DUMMY WHERE 1 <> 1");
                result = ips._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ips = result;
            return ips;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        on = this._tracer.on();
        pon = this._tracer.pon();
        aon = on != false ? this._tracer.aon() : false;
        r = pon != false ? this._newTraceRecord("supportsResultSetHoldability") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "supportsResultSetHoldability", new Object[]{holdability});
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                switch (holdability) {
                    case 1: 
                    case 2: {
                        result = true;
                        ** break;
lbl15:
                        // 1 sources

                        break;
                    }
                    case 1000001: 
                    case 1000002: {
                        result = this._connection.getEngineFeatures().holdCursorOverRollbackSupported();
                        ** break;
lbl19:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new SQLException("Unexpected result set holdability: " + holdability);
                    }
                }
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            var7_8 = result;
            return var7_8;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getResultSetHoldability() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getResultSetHoldability") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getResultSetHoldability", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 1;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getDatabaseMajorVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDatabaseMajorVersion") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getDatabaseMajorVersion", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._dbVersionInfo.getMajorVersion();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public synchronized int getDatabaseMinorVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getDatabaseMinorVersion") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getDatabaseMinorVersion", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._dbVersionInfo.getMinorVersion();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getJDBCMajorVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getJDBCMajorVersion") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getJDBCMajorVersion", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = Driver.getJDBCMajorVersion();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getJDBCMinorVersion() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getJDBCMinorVersion") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getJDBCMinorVersion", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = Driver.getJDBCMinorVersion();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getSQLStateType() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getSQLStateType") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getSQLStateType", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 2;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean locatorsUpdateCopy() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("locatorsUpdateCopy") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "locatorsUpdateCopy", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsStatementPooling() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsStatementPooling") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsStatementPooling", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getRowIdLifetime") : null;
        try {
            RowIdLifetime result;
            if (on) {
                this._tracer.printCall(this, "getRowIdLifetime", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = RowIdLifetime.ROWID_UNSUPPORTED;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult((Object)result);
            }
            RowIdLifetime rowIdLifetime = result;
            return rowIdLifetime;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getSchemas") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getSchemas", catalog, schemaPattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_SCHEMAS");
                ics._setString(1, catalog);
                ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsStoredFunctionsUsingCallSyntax") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsStoredFunctionsUsingCallSyntax", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("autoCommitFailureClosesAllResultSets") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "autoCommitFailureClosesAllResultSets", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getClientInfoProperties() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getClientInfoProperties") : null;
        try {
            ResultSet result;
            Wrapper ips;
            if (on) {
                this._tracer.printCall(this, "getClientInfoProperties", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS NAME, CAST( NULL AS INTEGER ) AS MAX_LEN, CAST( NULL AS NVARCHAR ) AS DEFAULT_VALUE, CAST( NULL AS NVARCHAR ) AS DESCRIPTION FROM SYS.DUMMY WHERE 1 <> 1");
                result = ips._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ips = result;
            return ips;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getFunctions") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getFunctions", catalog, schemaPattern, functionNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_FUNCTIONS");
                ics._setString(1, catalog);
                ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
                ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(functionNamePattern));
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getFunctionColumns") : null;
        try {
            ResultSet result;
            Wrapper ics;
            if (on) {
                this._tracer.printCall(this, "getFunctionColumns", catalog, schemaPattern, functionNamePattern, columnNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ics = this._newCallableStatement("JDBC_GET_FUNCTION_COLUMNS");
                ics._setString(1, catalog);
                ics._setString(2, DatabaseMetaDataSapDB._replaceForSystemQuery(schemaPattern));
                ics._setString(3, DatabaseMetaDataSapDB._replaceForSystemQuery(functionNamePattern));
                ics._setString(4, DatabaseMetaDataSapDB._replaceForSystemQuery(columnNamePattern));
                result = ics._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ics = result;
            return ics;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("getPseudoColumns") : null;
        try {
            ResultSet result;
            Wrapper ips;
            if (on) {
                this._tracer.printCall(this, "getPseudoColumns", catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this._connection._assertOpen();
                ips = this._newPreparedStatement("SELECT CAST( NULL AS NVARCHAR ) AS TABLE_CAT, CAST( NULL AS NVARCHAR ) AS TABLE_SCHEM, CAST( NULL AS NVARCHAR ) AS TABLE_NAME, CAST( NULL AS NVARCHAR ) AS COLUMN_NAME, CAST( NULL AS INTEGER ) AS DATA_TYPE, CAST( NULL AS INTEGER ) AS COLUMN_SIZE, CAST( NULL AS INTEGER ) AS DECIMAL_DIGITS, CAST( NULL AS INTEGER ) AS NUM_PREC_RADIX, CAST( NULL AS NVARCHAR ) AS COLUMN_USAGE, CAST( NULL AS NVARCHAR ) AS REMARKS, CAST( NULL AS INTEGER ) AS CHAR_OCTET_LENGTH, CAST( NULL AS NVARCHAR ) AS IS_NULLABLE FROM SYS.DUMMY WHERE 1 <> 1");
                result = ips._executeQuery();
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            ips = result;
            return ips;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("generatedKeyAlwaysReturned") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "generatedKeyAlwaysReturned", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = false;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public long getMaxLogicalLobSize() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("getMaxLogicalLobSize") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "getMaxLogicalLobSize", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = 0;
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean supportsRefCursors() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("supportsRefCursors") : null;
        try {
            boolean result;
            if (on) {
                this._tracer.printCall(this, "supportsRefCursors", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._connection.refCursors();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    protected TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(this._connection, null, null, "DatabaseMetaData", methodName);
    }

    protected void _publish(TraceRecord r) {
        r.update(this._connection);
        TraceRecordPublisher.getInstance().publish(r);
    }

    protected synchronized VersionInfo getVersionInfo() {
        if (this._dbVersionInfo == null) {
            this._getDBInfo();
        }
        return this._dbVersionInfo;
    }

    protected synchronized String _getUserName() {
        if (this._userName == null) {
            this._getDBInfo();
        }
        return this._userName != null ? this._userName : StringUtils.stripUserName(this._connection.getConnectionProperty(ConnectionProperty.USER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _getDBInfo() {
        InternalStatementSapDB is = null;
        ResultSetSapDB irs = null;
        try {
            is = InternalStatementSapDB.newInstance(this._connection, StatementSapDB.StatementFlag.INTERNAL_RESULT_SETS);
            irs = (InternalResultSetSapDB)is._executeQuery("SELECT VERSION, CURRENT_USER FROM SYS.M_DATABASE");
            if (irs != null && irs._next()) {
                this._dbVersionInfo = new VersionInfo(irs._getString(1));
                this._userName = irs._getString(2);
            }
        }
        catch (SQLException e) {
            this._userName = null;
        }
        finally {
            if (this._dbVersionInfo == null) {
                this._dbVersionInfo = new VersionInfo();
            }
            if (irs != null) {
                try {
                    irs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
            if (is != null) {
                try {
                    is._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static String _replaceForSystemQuery(String src) {
        return src == null ? "%" : src;
    }

    private InternalPreparedStatementSapDB _newPreparedStatement(String sql) throws SQLException {
        return InternalPreparedStatementSapDB.newInstance(this._connection, sql, 1003, 1007, 1, StatementSapDB.StatementFlag.META_DATA_STATEMENT);
    }

    private InternalCallableStatementSapDB _newCallableStatement(String sql) throws SQLException {
        return this._newCallableStatement(sql, false);
    }

    private InternalCallableStatementSapDB _newCallableStatement(String sql, boolean createInternalResultSets) throws SQLException {
        return InternalCallableStatementSapDB.newInstance(this._connection, "{CALLQ  " + sql + "}", StatementSapDB.StatementFlag.META_DATA_STATEMENT, createInternalResultSets ? StatementSapDB.StatementFlag.INTERNAL_RESULT_SETS : StatementSapDB.StatementFlag.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initTableTypes() throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        InternalResultSetSapDB irs = null;
        try {
            irs = (InternalResultSetSapDB)this._getTableTypes(true);
            while (irs._next()) {
                types.add(irs._getString(1));
            }
        }
        finally {
            if (irs != null) {
                try {
                    irs._close(true, false);
                }
                catch (SQLException sQLException) {}
            }
        }
        this._tableTypes = types.toArray(new String[0]);
    }

    private ResultSet _getTableTypes(boolean createInternalResultSets) throws SQLException {
        this._connection._assertOpen();
        InternalCallableStatementSapDB ics = this._newCallableStatement("JDBC_GET_TABLE_TYPES", createInternalResultSets);
        return ics._executeQuery();
    }
}

