/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.exceptions;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.trace.Tracer;

@ThreadSafe
public class RTEException
extends Exception {
    private final RteReturnCode _rteReturnCode;
    private final int _detailErrorCode;

    public static RTEException newInstance(Tracer tracer, String message, RteReturnCode rteReturnCode) {
        return RTEException._newInstance(tracer, message, rteReturnCode, rteReturnCode.getCommunicationErrorCode(), null);
    }

    public static RTEException newInstance(Tracer tracer, String message, RteReturnCode rteReturnCode, int detailErrorCode) {
        return RTEException._newInstance(tracer, message, rteReturnCode, detailErrorCode, null);
    }

    public static RTEException newInstance(Tracer tracer, String message, RteReturnCode rteReturnCode, Throwable t) {
        return RTEException._newInstance(tracer, message, rteReturnCode, rteReturnCode.getCommunicationErrorCode(), t);
    }

    public static RTEException newInstance(Tracer tracer, String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable t) {
        return RTEException._newInstance(tracer, message, rteReturnCode, detailErrorCode, t);
    }

    protected RTEException(String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable cause) {
        super(message, cause);
        this._rteReturnCode = rteReturnCode;
        this._detailErrorCode = detailErrorCode;
    }

    public RteReturnCode getRTEReturnCode() {
        return this._rteReturnCode;
    }

    public int getDetailErrorCode() {
        return this._detailErrorCode;
    }

    public boolean isTimeoutError() {
        return false;
    }

    public boolean isDecompressError() {
        return false;
    }

    public boolean isInvalidPacketError() {
        return false;
    }

    protected static RTEException _newInstance(Tracer tracer, String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable t) {
        RTEException e = new RTEException(message, rteReturnCode, detailErrorCode, t);
        e._printCurrentStackTrace(tracer);
        return e;
    }

    protected void _printCurrentStackTrace(Tracer tracer) {
        if (tracer.on()) {
            tracer.printCurrentStackTrace("RTEException: " + (Object)((Object)this._rteReturnCode) + "(" + this._rteReturnCode.getValue() + ") " + this._detailErrorCode + " " + this.getMessage(), this);
        }
    }
}

