/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;

@ThreadSafe
public class APIMetrics {
    public static final ThreadLocal<APIMetrics> API_METRICS = ThreadLocal.withInitial(APIMetrics::new);
    private static final long NANOSECONDS_UNDEFINED = -1L;
    private long _apiStartTime;
    private long _networkTime;

    public static APIMetrics getInstance() {
        return API_METRICS.get();
    }

    private APIMetrics() {
        this._init();
    }

    public long getAPIStartTime() {
        return this._apiStartTime;
    }

    public long getNetworkTime() {
        return this._networkTime;
    }

    public boolean isValid() {
        return this._apiStartTime != -1L;
    }

    public void reset(boolean isShowElapsedTimesEnabled) {
        if (isShowElapsedTimesEnabled) {
            this._apiStartTime = System.nanoTime();
            this._networkTime = 0L;
        } else {
            this._init();
        }
    }

    public void accumulate(long networkTime) {
        this._networkTime += networkTime;
    }

    private void _init() {
        this._apiStartTime = -1L;
        this._networkTime = -1L;
    }
}

