/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.tools;

import com.sandflow.smpte.register.ElementsRegister;
import com.sandflow.smpte.register.GroupsRegister;
import com.sandflow.smpte.register.TypesRegister;
import com.sandflow.smpte.register.exceptions.DuplicateEntryException;
import com.sandflow.smpte.register.exceptions.InvalidEntryException;
import com.sandflow.smpte.regxml.dict.MetaDictionary;
import com.sandflow.smpte.regxml.dict.MetaDictionaryCollection;
import com.sandflow.smpte.regxml.dict.importers.RegisterImporter;
import com.sandflow.smpte.tools.BuildVersionSingleton;
import com.sandflow.util.events.Event;
import com.sandflow.util.events.EventHandler;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XMLRegistersToDict {
    private static final Logger LOG = Logger.getLogger(XMLRegistersToDict.class.getName());
    protected static final String USAGE = "Converts XML Registers to RegXML metadictionary.\n  Usage: XMLRegistersToDict -e elementsregspath\n                            -l labelsregpath\n                            -g groupsregpath\n                            -t typesregpath\n                            outputdir\n         XMLRegistersToDict -?";

    public static void main(String[] args) throws FileNotFoundException, JAXBException, IOException, InvalidEntryException, DuplicateEntryException, Exception {
        if (!(args.length == 9 && !"-?".equals(args[0]) && "-e".equals(args[0]) && "-l".equals(args[2]) && "-g".equals(args[4]) && "-t".equals(args[6]))) {
            System.out.println(USAGE);
            return;
        }
        FileReader fe = new FileReader(args[1]);
        FileReader fg = new FileReader(args[5]);
        FileReader ft = new FileReader(args[7]);
        ElementsRegister ereg = ElementsRegister.fromXML(fe);
        GroupsRegister greg = GroupsRegister.fromXML(fg);
        TypesRegister treg = TypesRegister.fromXML(ft);
        EventHandler evthandler = new EventHandler(){

            @Override
            public boolean handle(Event evt) {
                String msg = String.valueOf(evt.getCode().getClass().getCanonicalName()) + "::" + evt.getCode().toString() + " " + evt.getMessage();
                switch (evt.getSeverity()) {
                    case ERROR: 
                    case FATAL: {
                        LOG.severe(msg);
                        break;
                    }
                    case INFO: {
                        LOG.info(msg);
                        break;
                    }
                    case WARN: {
                        LOG.warning(msg);
                    }
                }
                return true;
            }
        };
        MetaDictionaryCollection mds = RegisterImporter.fromRegister(treg, greg, ereg, evthandler);
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        for (MetaDictionary md : mds.getDictionaries()) {
            String fname = String.valueOf(md.getSchemeURI().getAuthority()) + md.getSchemeURI().getPath();
            File f = new File(args[8], String.valueOf(fname.replaceAll("[^a-zA-Z0-9]", "-")) + ".xml");
            Document doc = md.toXML();
            Date now = new Date();
            doc.insertBefore(doc.createComment("Created: " + now.toString()), doc.getDocumentElement());
            doc.insertBefore(doc.createComment("By: regxmllib build " + BuildVersionSingleton.getBuildVersion()), doc.getDocumentElement());
            doc.insertBefore(doc.createComment("See: https://github.com/sandflow/regxmllib"), doc.getDocumentElement());
            tr.transform(new DOMSource(doc), new StreamResult(f));
        }
    }
}

