/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml.dict.definitions;

import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.regxml.dict.definitions.DefinitionVisitor;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.xml.AUIDAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlAccessorType(value=XmlAccessType.NONE)
public class EnumerationTypeDefinition
extends Definition {
    @XmlJavaTypeAdapter(value=AUIDAdapter.class)
    @XmlElement(name="ElementType")
    private AUID elementType;
    @XmlJavaTypeAdapter(value=EnumerationElementAdapter.class)
    @XmlAnyElement(lax=false)
    private ArrayList<Element> elements;

    public EnumerationTypeDefinition() {
    }

    public EnumerationTypeDefinition(Collection<Element> elements) {
        this.elements = new ArrayList<Element>(elements);
    }

    public AUID getElementType() {
        return this.elementType;
    }

    public void setElementType(AUID elementType) {
        this.elementType = elementType;
    }

    @Override
    public void accept(DefinitionVisitor visitor) throws DefinitionVisitor.VisitorException {
        visitor.visit(this);
    }

    public Collection<Element> getElements() {
        return this.elements;
    }

    @XmlType(name="")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Element {
        @XmlElement(name="Name")
        private String name;
        @XmlElement(name="Value")
        private int value;
        @XmlElement(name="Description")
        private String description;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    private static class EnumerationElementAdapter
    extends XmlAdapter<Object, ArrayList<Element>> {
        private EnumerationElementAdapter() {
        }

        public ArrayList<Element> unmarshal(Object v) throws Exception {
            ArrayList<Element> al = new ArrayList<Element>();
            Node node = ((org.w3c.dom.Element)v).getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    org.w3c.dom.Element elem = (org.w3c.dom.Element)node;
                    if ("Name".equals(elem.getNodeName())) {
                        al.add(new Element());
                        al.get(al.size() - 1).setName(elem.getTextContent());
                    } else if ("Value".equals(elem.getNodeName())) {
                        al.get(al.size() - 1).setValue(Integer.parseInt(elem.getTextContent()));
                    } else if ("Description".equals(elem.getNodeName())) {
                        al.get(al.size() - 1).setDescription(elem.getTextContent());
                    }
                }
                node = node.getNextSibling();
            }
            return al;
        }

        public Object marshal(ArrayList<Element> v) throws Exception {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            org.w3c.dom.Element elem = doc.createElementNS("http://www.smpte-ra.org/schemas/2001-1b/2013/metadict", "Elements");
            for (Element e : v) {
                org.w3c.dom.Element e1 = doc.createElementNS("http://www.smpte-ra.org/schemas/2001-1b/2013/metadict", "Name");
                e1.setTextContent(e.getName());
                elem.appendChild(e1);
                e1 = doc.createElementNS("http://www.smpte-ra.org/schemas/2001-1b/2013/metadict", "Value");
                e1.setTextContent(Integer.toString(e.getValue()));
                elem.appendChild(e1);
                if (e.getDescription() == null) continue;
                e1 = doc.createElementNS("http://www.smpte-ra.org/schemas/2001-1b/2013/metadict", "Description");
                e1.setTextContent(e.getDescription());
                elem.appendChild(e1);
            }
            return elem;
        }
    }
}

