/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml.dict;

import com.sandflow.smpte.regxml.dict.DefinitionResolver;
import com.sandflow.smpte.regxml.dict.definitions.CharacterTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ClassDefinition;
import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.regxml.dict.definitions.EnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.ExtendibleEnumerationTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FixedArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.FloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IndirectTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.IntegerTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.LensSerialFloatTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.OpaqueTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyAliasDefinition;
import com.sandflow.smpte.regxml.dict.definitions.PropertyDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RecordTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.RenameTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.SetTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StreamTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StringTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.StrongReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.VariableArrayTypeDefinition;
import com.sandflow.smpte.regxml.dict.definitions.WeakReferenceTypeDefinition;
import com.sandflow.smpte.regxml.dict.exceptions.DuplicateSymbolException;
import com.sandflow.smpte.regxml.dict.exceptions.IllegalDefinitionException;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.UL;
import com.sandflow.smpte.util.UUID;
import com.sandflow.smpte.util.xml.UUIDAdapter;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@XmlRootElement(name="Extension")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MetaDictionary
implements DefinitionResolver {
    public static final String XML_NS = "http://www.smpte-ra.org/schemas/2001-1b/2013/metadict";
    @XmlJavaTypeAdapter(value=UUIDAdapter.class)
    @XmlElement(name="SchemeID", required=true)
    private UUID schemeID;
    @XmlElement(name="SchemeURI", required=true)
    private URI schemeURI;
    @XmlElement(name="Description")
    private String description;
    private final ArrayList<Definition> definitions = new ArrayList();
    private final HashMap<AUID, Definition> definitionsByAUID = new HashMap();
    private final HashMap<String, Definition> definitionsBySymbol = new HashMap();
    private final HashMap<AUID, Set<AUID>> membersOf = new HashMap();
    private final HashMap<AUID, Set<AUID>> subclassesOf = new HashMap();

    static AUID createNormalizedAUID(AUID auid) {
        if (auid.isUL()) {
            return new AUID(MetaDictionary.createNormalizedUL(auid.asUL()));
        }
        return auid;
    }

    static UL createNormalizedUL(UL ul) {
        byte[] value = (byte[])ul.getValue().clone();
        value[7] = 0;
        if (ul.isGroup()) {
            value[5] = 127;
        }
        return new UL(value);
    }

    static String createQualifiedSymbol(String namespace, String symbol) {
        if (namespace == null || namespace.length() == 0) {
            return symbol;
        }
        return String.valueOf(namespace) + " " + symbol;
    }

    public static MetaDictionary fromXML(Reader reader) throws JAXBException, IOException, IllegalDefinitionException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{MetaDictionary.class});
        Unmarshaller m = ctx.createUnmarshaller();
        MetaDictionary md = (MetaDictionary)m.unmarshal(reader);
        for (Definition def : md.definitions) {
            def.setNamespace(md.getSchemeURI());
            md.indexDefinition(def);
        }
        return md;
    }

    private MetaDictionary() {
    }

    public MetaDictionary(URI schemeURI) {
        this.schemeID = UUID.fromURIName(schemeURI);
        this.schemeURI = schemeURI;
    }

    void indexDefinition(Definition def) throws IllegalDefinitionException {
        Set<AUID> hs;
        AUID parentauid;
        AUID defid = MetaDictionary.createNormalizedAUID(def.getIdentification());
        if (def.getClass() != PropertyAliasDefinition.class) {
            if (this.definitionsByAUID.containsKey(defid)) {
                throw new IllegalDefinitionException("Duplicate AUID: " + def.getIdentification());
            }
            if (this.definitionsBySymbol.containsKey(def.getSymbol())) {
                throw new DuplicateSymbolException("Duplicate Symbol: " + def.getSymbol());
            }
            this.definitionsByAUID.put(defid, def);
            this.definitionsBySymbol.put(def.getSymbol(), def);
        }
        if (def instanceof PropertyDefinition) {
            parentauid = MetaDictionary.createNormalizedAUID(((PropertyDefinition)def).getMemberOf());
            hs = this.membersOf.get(parentauid);
            if (hs == null) {
                hs = new HashSet<AUID>();
                this.membersOf.put(parentauid, hs);
            }
            hs.add(defid);
        }
        if (def instanceof ClassDefinition && ((ClassDefinition)def).getParentClass() != null) {
            parentauid = MetaDictionary.createNormalizedAUID(((ClassDefinition)def).getParentClass());
            hs = this.subclassesOf.get(parentauid);
            if (hs == null) {
                hs = new HashSet<AUID>();
                this.subclassesOf.put(parentauid, hs);
            }
            hs.add(defid);
        }
    }

    public void add(Definition def) throws IllegalDefinitionException {
        if (!def.getNamespace().equals(this.getSchemeURI())) {
            throw new IllegalDefinitionException("Namespace does not match Metadictionary Scheme URI: " + def.getSymbol());
        }
        this.indexDefinition(def);
        this.definitions.add(def);
    }

    public UUID getSchemeID() {
        return this.schemeID;
    }

    public URI getSchemeURI() {
        return this.schemeURI;
    }

    public String getDescription() {
        return this.description;
    }

    @XmlElementWrapper(name="MetaDefinitions")
    @XmlElements(value={@XmlElement(name="ClassDefinition", type=ClassDefinition.class), @XmlElement(name="PropertyDefinition", type=PropertyDefinition.class), @XmlElement(name="PropertyAliasDefinition", type=PropertyAliasDefinition.class), @XmlElement(name="TypeDefinitionCharacter", type=CharacterTypeDefinition.class), @XmlElement(name="TypeDefinitionEnumeration", type=EnumerationTypeDefinition.class), @XmlElement(name="TypeDefinitionExtendibleEnumeration", type=ExtendibleEnumerationTypeDefinition.class), @XmlElement(name="TypeDefinitionFixedArray", type=FixedArrayTypeDefinition.class), @XmlElement(name="TypeDefinitionIndirect", type=IndirectTypeDefinition.class), @XmlElement(name="TypeDefinitionInteger", type=IntegerTypeDefinition.class), @XmlElement(name="TypeDefinitionOpaque", type=OpaqueTypeDefinition.class), @XmlElement(name="TypeDefinitionRecord", type=RecordTypeDefinition.class), @XmlElement(name="TypeDefinitionRename", type=RenameTypeDefinition.class), @XmlElement(name="TypeDefinitionSet", type=SetTypeDefinition.class), @XmlElement(name="TypeDefinitionStream", type=StreamTypeDefinition.class), @XmlElement(name="TypeDefinitionString", type=StringTypeDefinition.class), @XmlElement(name="TypeDefinitionStrongObjectReference", type=StrongReferenceTypeDefinition.class), @XmlElement(name="TypeDefinitionVariableArray", type=VariableArrayTypeDefinition.class), @XmlElement(name="TypeDefinitionWeakObjectReference", type=WeakReferenceTypeDefinition.class), @XmlElement(name="TypeDefinitionFloat", type=FloatTypeDefinition.class), @XmlElement(name="TypeDefinitionLenseSerialFloat", type=LensSerialFloatTypeDefinition.class)})
    public ArrayList<Definition> getDefinitions() {
        return this.definitions;
    }

    @Override
    public Definition getDefinition(AUID id) {
        return this.definitionsByAUID.get(MetaDictionary.createNormalizedAUID(id));
    }

    public Definition getDefinition(String symbol) {
        return this.definitionsBySymbol.get(symbol);
    }

    public Document toXML() {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Marshaller m = JAXBContext.newInstance((Class[])new Class[]{MetaDictionary.class}).createMarshaller();
            m.marshal((Object)this, (Node)doc);
        }
        catch (JAXBException | ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return doc;
    }

    @Override
    public Collection<AUID> getSubclassesOf(ClassDefinition parent) {
        return this.subclassesOf.get(MetaDictionary.createNormalizedAUID(parent.getIdentification()));
    }

    @Override
    public Collection<AUID> getMembersOf(ClassDefinition parent) {
        return this.membersOf.get(MetaDictionary.createNormalizedAUID(parent.getIdentification()));
    }
}

