/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.tools;

import com.sandflow.smpte.register.exceptions.DuplicateEntryException;
import com.sandflow.smpte.register.exceptions.InvalidEntryException;
import com.sandflow.smpte.tools.BuildVersionSingleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GenerateXMLSchemaDocuments {
    protected static final String USAGE = "Generates XML Schema documents for JAXB-annotated classes.\n  Usage: GenerateXMLSchemaDocuments -cp classpath -d outdir\n         GenerateXMLSchemaDocuments -?";

    public static void main(String[] args) throws FileNotFoundException, JAXBException, IOException, InvalidEntryException, DuplicateEntryException, Exception {
        if (args.length != 4 || "-?".equals(args[0])) {
            System.out.println(USAGE);
            return;
        }
        Class<?> c = Class.forName(args[1]);
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{c});
        File baseDir = new File(args[3]);
        final DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        final ArrayList docs = new ArrayList();
        ctx.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                Document doc = docBuilder.newDocument();
                docs.add(doc);
                Date now = new Date();
                doc.appendChild(doc.createComment("Created: " + now.toString()));
                doc.appendChild(doc.createComment("By: regxmllib build " + BuildVersionSingleton.getBuildVersion()));
                doc.appendChild(doc.createComment("See: https://github.com/sandflow/regxmllib"));
                return new DOMResult((Node)doc, suggestedFileName);
            }
        });
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        for (int i = 0; i < docs.size(); ++i) {
            tr.transform(new DOMSource((Node)docs.get(i)), new StreamResult(new File(baseDir, c.getSimpleName() + (i == 0 ? "" : "." + i) + ".xsd")));
        }
    }
}

