/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.tools;

import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.regxml.FragmentBuilder;
import com.sandflow.smpte.regxml.XMLSchemaBuilder;
import com.sandflow.smpte.regxml.dict.MetaDictionary;
import com.sandflow.smpte.regxml.dict.MetaDictionaryCollection;
import com.sandflow.smpte.regxml.dict.exceptions.IllegalDefinitionException;
import com.sandflow.smpte.regxml.dict.exceptions.IllegalDictionaryException;
import com.sandflow.smpte.tools.BuildVersionSingleton;
import com.sandflow.util.events.Event;
import com.sandflow.util.events.EventHandler;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateDictionaryXMLSchema {
    private static final Logger LOG = Logger.getLogger(GenerateDictionaryXMLSchema.class.getName());
    protected static final String USAGE = "Generate XML Schema for RegXML Metadictionaries.\n  Usage:\n     GenerateDictionaryXMLSchema -d regxmldictionary1 regxmldictionary2 regxmldictionary3 ... -o outputdir\n     GenerateDictionaryXMLSchema -?\n";
    private static final String XMLSCHEMA_NS = "http://www.w3.org/2001/XMLSchema";

    public static void main(String[] args) throws IOException, EOFException, KLVException, ParserConfigurationException, JAXBException, FragmentBuilder.RuleException, TransformerException, IllegalDefinitionException, IllegalDictionaryException, Exception {
        if (args.length < 4 || "-?".equals(args[0]) || !"-d".equals(args[0]) || !"-o".equals(args[args.length - 2])) {
            System.out.println(USAGE);
            return;
        }
        MetaDictionaryCollection mds = new MetaDictionaryCollection();
        for (int i = 1; i < args.length - 2; ++i) {
            FileReader fr = new FileReader(args[i]);
            MetaDictionary md = MetaDictionary.fromXML(fr);
            mds.addDictionary(md);
        }
        Document masterxsd = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element masterxsd_root = masterxsd.createElementNS(XMLSCHEMA_NS, "schema");
        masterxsd.appendChild(masterxsd_root);
        InputStream regis = GenerateDictionaryXMLSchema.class.getResourceAsStream("/resources/reg.xsd");
        Files.copy(regis, Paths.get(args[args.length - 1], "reg.xsd"), StandardCopyOption.REPLACE_EXISTING);
        Element masterxsd_import = masterxsd.createElementNS(XMLSCHEMA_NS, "import");
        masterxsd_import.setAttribute("namespace", "http://sandflow.com/ns/SMPTEST2001-1/baseline");
        masterxsd_import.setAttribute("schemaLocation", "reg.xsd");
        masterxsd_root.appendChild(masterxsd_import);
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        XMLSchemaBuilder sb = new XMLSchemaBuilder(mds, new EventHandler(){

            @Override
            public boolean handle(Event evt) {
                String msg = evt.getCode().getClass().getCanonicalName() + "::" + evt.getCode().toString() + " " + evt.getMessage();
                switch (evt.getSeverity()) {
                    case ERROR: 
                    case FATAL: {
                        LOG.severe(msg);
                        break;
                    }
                    case INFO: {
                        LOG.info(msg);
                        break;
                    }
                    case WARN: {
                        LOG.warning(msg);
                    }
                }
                return true;
            }
        });
        for (MetaDictionary md : mds.getDictionaries()) {
            String fname = (md.getSchemeURI().getAuthority() + md.getSchemeURI().getPath()).replaceAll("[^a-zA-Z0-9]", "-") + ".xsd";
            masterxsd_import = masterxsd.createElementNS(XMLSCHEMA_NS, "import");
            masterxsd_import.setAttribute("namespace", md.getSchemeURI().toString());
            masterxsd_import.setAttribute("schemaLocation", fname);
            masterxsd_root.appendChild(masterxsd_import);
            File f = new File(args[args.length - 1], fname);
            Document doc = sb.fromDictionary(md);
            Date now = new Date();
            doc.insertBefore(doc.createComment("Created: " + now.toString()), doc.getDocumentElement());
            doc.insertBefore(doc.createComment("By: regxmllib build " + BuildVersionSingleton.getBuildVersion()), doc.getDocumentElement());
            doc.insertBefore(doc.createComment("See: https://github.com/sandflow/regxmllib"), doc.getDocumentElement());
            tr.transform(new DOMSource(doc), new StreamResult(f));
        }
        File includefile = new File(args[args.length - 1], "include.xsd");
        tr.transform(new DOMSource(masterxsd), new StreamResult(includefile));
    }
}

