/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.regxml.dict.definitions;

import com.sandflow.smpte.regxml.dict.definitions.Definition;
import com.sandflow.smpte.regxml.dict.definitions.DefinitionVisitor;
import com.sandflow.smpte.util.AUID;
import com.sandflow.smpte.util.xml.AUIDAdapter;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlAccessorType(value=XmlAccessType.NONE)
public class RecordTypeDefinition
extends Definition {
    @XmlJavaTypeAdapter(value=RecordMemberAdapter.class)
    @XmlAnyElement(lax=false)
    ArrayList<Member> members = new ArrayList();

    @Override
    public void accept(DefinitionVisitor visitor) throws DefinitionVisitor.VisitorException {
        visitor.visit(this);
    }

    public void addMember(Member record) {
        this.members.add(record);
    }

    public Collection<Member> getMembers() {
        return this.members;
    }

    private static class RecordMemberAdapter
    extends XmlAdapter<Object, ArrayList<Member>> {
        private RecordMemberAdapter() {
        }

        public ArrayList<Member> unmarshal(Object v) throws Exception {
            ArrayList<Member> al = new ArrayList<Member>();
            for (Node node = ((Element)v).getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                Element elem = (Element)node;
                if ("Name".equals(elem.getNodeName())) {
                    al.add(new Member());
                    al.get(al.size() - 1).setName(elem.getTextContent());
                    continue;
                }
                if (!"Type".equals(elem.getNodeName())) continue;
                al.get(al.size() - 1).setType(AUID.fromURN(elem.getTextContent()));
            }
            return al;
        }

        public Object marshal(ArrayList<Member> v) throws Exception {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element elem = doc.createElementNS("http://www.smpte-ra.org/schemas/2001-1b/2013/metadict", "Members");
            for (Member e : v) {
                Element e1 = doc.createElementNS("http://www.smpte-ra.org/schemas/2001-1b/2013/metadict", "Name");
                e1.setTextContent(e.getName());
                elem.appendChild(e1);
                e1 = doc.createElementNS("http://www.smpte-ra.org/schemas/2001-1b/2013/metadict", "Type");
                e1.setTextContent(e.getType().toString());
                elem.appendChild(e1);
            }
            return elem;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class Member {
        @XmlElement(name="Name")
        private String name;
        @XmlJavaTypeAdapter(value=AUIDAdapter.class)
        @XmlElement(name="Type")
        private AUID type;
        @XmlElement(name="Description")
        private String description;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public AUID getType() {
            return this.type;
        }

        public void setType(AUID type) {
            this.type = type;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

