/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.register;

import com.sandflow.smpte.register.QualifiedSymbol;
import com.sandflow.smpte.register.catsup.TypesRegisterModel;
import com.sandflow.smpte.register.exceptions.DuplicateEntryException;
import com.sandflow.smpte.util.UL;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlTransient
public abstract class TypesRegister {
    private final HashMap<QualifiedSymbol, Entry> entriesBySymbol = new HashMap();
    private final HashMap<UL, Entry> entriesByUL = new HashMap();

    public Entry getEntryByUL(UL ul) {
        return this.entriesByUL.get(ul);
    }

    public Entry getEntryBySymbol(QualifiedSymbol qs) {
        return this.entriesBySymbol.get(qs);
    }

    public abstract Collection<? extends Entry> getEntries();

    public void toXML(Writer writer) throws JAXBException, IOException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)this, writer);
        writer.close();
    }

    public static TypesRegister fromXML(Reader reader) throws JAXBException, IOException, DuplicateEntryException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{TypesRegisterModel.class});
        Unmarshaller m = ctx.createUnmarshaller();
        TypesRegister reg = (TypesRegister)m.unmarshal(reader);
        for (Entry entry : reg.getEntries()) {
            QualifiedSymbol sym = new QualifiedSymbol(entry.getSymbol(), entry.getNamespaceName());
            if (reg.getEntryByUL(entry.getUL()) != null) {
                throw new DuplicateEntryException(String.format("UL = %s is already present (symbol = %s).", entry.getUL(), entry.getSymbol()));
            }
            if (reg.entriesBySymbol.get(sym) != null) {
                throw new DuplicateEntryException(String.format("Symbol = %s  is already present (UL = %s).", entry.getSymbol(), entry.getUL()));
            }
            reg.entriesByUL.put(entry.getUL(), entry);
            reg.entriesBySymbol.put(sym, entry);
        }
        return reg;
    }

    public static interface Entry {
        public static final String ARRAY_TYPEKIND = "VariableArray";
        public static final String CHARACTER_TYPEKIND = "Character";
        public static final String ENUMERATION_TYPEKIND = "Enumeration";
        public static final String FIXEDARRAY_TYPEKIND = "FixedArray";
        public static final String FLOAT_TYPEKIND = "Float";
        public static final String INDIRECT_TYPEKIND = "Indirect";
        public static final String INTEGER_TYPEKIND = "Integer";
        public static final String LENSSERIALFLOAT_TYPEKIND = "LensSerialFloat";
        public static final String OPAQUE_TYPEKIND = "Opaque";
        public static final String RECORD_TYPEKIND = "Record";
        public static final String RENAME_TYPEKIND = "Rename";
        public static final String SET_TYPEKIND = "Set";
        public static final String STREAM_TYPEKIND = "Stream";
        public static final String STRING_TYPEKIND = "String";
        public static final String STRONGREF_TYPEKIND = "StrongReference";
        public static final String WEAKREF_TYPEKIND = "WeakReference";

        public String getApplications();

        public UL getBaseType();

        public ContextScope getContextScope();

        public String getDefiningDocument();

        public String getDefinition();

        public Collection<? extends Facet> getFacets();

        public Kind getKind();

        public String getName();

        public URI getNamespaceName();

        public String getNotes();

        public String getSymbol();

        public String getTypeKind();

        public EnumSet<TypeQualifiers> getTypeQualifiers();

        public Long getTypeSize();

        public UL getUL();

        public boolean isDeprecated();

        @XmlType(name="")
        public static enum ContextScope {
            DefinedContext,
            AbstractContext,
            UnknownContext;

        }

        @XmlType(name="")
        public static enum Kind {
            NODE,
            LEAF;

        }

        @XmlType(name="")
        public static enum TypeQualifiers {
            isNumeric,
            isSigned,
            isIdentified,
            isOrdered,
            isCountImplicit,
            isSizeImplicit;

        }

        public static interface Facet {
            public String getApplications();

            public String getDefinition();

            public String getName();

            public String getNotes();

            public String getSymbol();

            public UL getType();

            public UL getUL();

            public String getValue();

            public boolean isDeprecated();
        }
    }
}

