/*
 * Decompiled with CFR 0.152.
 */
package com.sandflow.smpte.mxf;

import com.sandflow.smpte.klv.Triplet;
import com.sandflow.smpte.klv.exceptions.KLVException;
import com.sandflow.smpte.mxf.MXFInputStream;
import com.sandflow.smpte.util.UL;
import java.io.IOException;
import java.util.ArrayList;

public class RandomIndexPack {
    private static final UL KEY = UL.fromURN("urn:smpte:ul:060e2b34.02050101.0d010201.01110100");
    private final ArrayList<PartitionOffset> offsets = new ArrayList();

    public static UL getKey() {
        return KEY;
    }

    public static RandomIndexPack fromTriplet(Triplet triplet) throws KLVException {
        RandomIndexPack pp = new RandomIndexPack();
        if (!KEY.equals(triplet.getKey())) {
            return null;
        }
        if ((triplet.getLength() - 4L) % 12L != 0L) {
            return null;
        }
        long count = (triplet.getLength() - 4L) / 12L;
        try {
            MXFInputStream kis = new MXFInputStream(triplet.getValueAsStream());
            int i = 0;
            while ((long)i < count) {
                long bodySID = kis.readUnsignedInt();
                long offset = kis.readLong();
                PartitionOffset po = new PartitionOffset(bodySID, offset);
                pp.offsets.add(po);
                ++i;
            }
        }
        catch (IOException e) {
            throw new KLVException(e);
        }
        return pp;
    }

    public ArrayList<PartitionOffset> getOffsets() {
        return this.offsets;
    }

    public static class PartitionOffset {
        private final long bodySID;
        private final long offset;

        public PartitionOffset(long bodySID, long offset) {
            this.bodySID = bodySID;
            this.offset = offset;
        }

        public long getBodySID() {
            return this.bodySID;
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

