(function () {
  'use strict';

  var MAX_RETRIES = 1000;
  var MAX_RETRY_DELAY = 1000 * 60 * 3; // max 3 minutes between retries

  window.retryScriptLoad = function retryScriptLoad(failedScript, attempts) {
  attempts = attempts || 0
    var src = failedScript.src;
    failedScript.parentNode && failedScript.parentNode.removeChild(failedScript);

    var script = document.createElement('script');
    script.src = src;
    script.onerror = function () {
      if (attempts > MAX_RETRIES) return;
      // exponential backoff with a cap of MAX_RETRY_DELAY
      var delay = Math.min(Math.pow(2, attempts++) * 1000, MAX_RETRY_DELAY);

      setTimeout(function () {
        window.retryScriptLoad(script, attempts);
      }, delay);
    };
    document.head.appendChild(script);
  };
}());
