/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.com.google.common.io;

import com.salesforce.servicelibs.com.google.common.annotations.Beta;
import com.salesforce.servicelibs.com.google.common.annotations.GwtIncompatible;
import com.salesforce.servicelibs.com.google.common.base.Preconditions;
import com.salesforce.servicelibs.org.checkerframework.checker.nullness.compatqual.NullableDecl;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(@NullableDecl File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

