/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.com.github.mustachejava.resolver;

import com.salesforce.servicelibs.com.github.mustachejava.MustacheException;
import com.salesforce.servicelibs.com.github.mustachejava.MustacheResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class FileSystemResolver
implements MustacheResolver {
    private final File fileRoot;

    public FileSystemResolver() {
        this.fileRoot = null;
    }

    public FileSystemResolver(File fileRoot) {
        if (!fileRoot.exists()) {
            throw new MustacheException(fileRoot + " does not exist");
        }
        if (!fileRoot.isDirectory()) {
            throw new MustacheException(fileRoot + " is not a directory");
        }
        this.fileRoot = fileRoot;
    }

    @Override
    public Reader getReader(String resourceName) {
        File file;
        FileInputStream is = null;
        File file2 = file = this.fileRoot == null ? new File(resourceName) : new File(this.fileRoot, resourceName);
        if (file.exists() && file.isFile()) {
            try {
                File checkRoot = this.fileRoot == null ? new File("").getCanonicalFile() : this.fileRoot.getCanonicalFile();
                File parent = file.getCanonicalFile();
                while ((parent = parent.getParentFile()) != null && !parent.equals(checkRoot)) {
                }
                if (parent == null) {
                    throw new MustacheException("File not under root: " + checkRoot.getAbsolutePath());
                }
                is = new FileInputStream(file);
            }
            catch (IOException e) {
                throw new MustacheException("Found file, could not open: " + file, e);
            }
        }
        if (is != null) {
            return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        return null;
    }
}

