/*
 * Decompiled with CFR 0.152.
 */
package com.s24.search.solr.util.analyzing;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.s24.search.solr.util.analyzing.Position;

public class Token {
    public static final String MULTIWORD_TOKEN = "multiword";
    private final String name;
    private final String type;
    private final Position position;
    private final Integer tokenCount;

    public Token(String name, Position positionInOriginal, Integer tokenCount) {
        this(name, null, positionInOriginal, tokenCount);
    }

    public Token(String name, String type, Position positionInOriginal, Integer tokenCount) {
        Preconditions.checkNotNull((Object)name, (Object)"Pre-condition violated: name must not be null.");
        Preconditions.checkNotNull((Object)positionInOriginal, (Object)"Pre-condition violated: positionInOriginal must not be null.");
        Preconditions.checkNotNull((Object)tokenCount, (Object)"Pre-condition violated: tokenCount must not be null.");
        this.type = type;
        this.position = positionInOriginal;
        this.tokenCount = tokenCount;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Position getPosition() {
        return this.position;
    }

    public Integer getTokenCount() {
        return this.tokenCount;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("token", (Object)this.name).add("position", (Object)this.position).add("tokenCount", (Object)this.tokenCount).add("type", (Object)this.type).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.position, this.tokenCount, this.type});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Token) {
            Token other = (Token)obj;
            return Objects.equal((Object)other.getName(), (Object)this.getName()) && Objects.equal((Object)other.getPosition(), (Object)this.getPosition()) && Objects.equal((Object)other.getType(), (Object)this.getType());
        }
        return false;
    }
}

