/*
 * Decompiled with CFR 0.152.
 */
package com.rustfisher.btscanner;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import android.os.Parcelable;

public final class BtDeviceItem
implements Parcelable,
Comparable {
    private String address;
    private String name;
    private int rssi;
    private BluetoothDevice bluetoothDevice;
    public static final Parcelable.Creator<BtDeviceItem> CREATOR = new Parcelable.Creator<BtDeviceItem>(){

        public BtDeviceItem createFromParcel(Parcel in) {
            return new BtDeviceItem(in);
        }

        public BtDeviceItem[] newArray(int size) {
            return new BtDeviceItem[size];
        }
    };

    public BtDeviceItem(BluetoothDevice device, int rssi) {
        this.address = device.getAddress();
        this.name = device.getName();
        this.rssi = rssi;
        this.bluetoothDevice = device;
    }

    protected BtDeviceItem(Parcel in) {
        this.address = in.readString();
        this.name = in.readString();
        this.rssi = in.readInt();
        this.bluetoothDevice = (BluetoothDevice)in.readParcelable(BluetoothDevice.class.getClassLoader());
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    public BluetoothDevice getBluetoothDevice() {
        return this.bluetoothDevice;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.address);
        dest.writeString(this.name);
        dest.writeInt(this.rssi);
        dest.writeParcelable((Parcelable)this.bluetoothDevice, flags);
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof BtDeviceItem)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BtDeviceItem likeThis = (BtDeviceItem)obj;
        return likeThis.getName().equals(this.getName()) && likeThis.getAddress().equals(this.getAddress());
    }

    public String toString() {
        return this.name + ", " + this.address + " , rssi = " + this.rssi;
    }

    public int compareTo(Object o) {
        BtDeviceItem esObj = (BtDeviceItem)o;
        int rssiEs = esObj.getRssi();
        if (this.rssi > rssiEs) {
            return -1;
        }
        if (this.rssi < rssiEs) {
            return 1;
        }
        return 0;
    }
}

