/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.opml.io.impl;

import com.rometools.opml.feed.opml.Attribute;
import com.rometools.opml.feed.opml.Opml;
import com.rometools.opml.feed.opml.Outline;
import com.rometools.opml.io.impl.OPML10Parser;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.impl.DateParser;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jdom2.Document;
import org.jdom2.Element;

public class OPML20Parser
extends OPML10Parser {
    public OPML20Parser() {
        super("opml_2.0");
    }

    @Override
    public boolean isMyType(Document document) {
        Element e = document.getRootElement();
        return e.getName().equals("opml") && (e.getChild("head") != null && e.getChild("head").getChild("docs") != null || e.getAttributeValue("version") != null && e.getAttributeValue("version").equals("2.0") || e.getChild("head") != null && e.getChild("head").getChild("ownerId") != null);
    }

    @Override
    public WireFeed parse(Document document, boolean validate, Locale locale) throws IllegalArgumentException, FeedException {
        Opml opml = (Opml)super.parse(document, validate, locale);
        Element head = document.getRootElement().getChild("head");
        if (head != null) {
            opml.setOwnerId(head.getChildTextTrim("ownerId"));
            opml.setDocs(head.getChildTextTrim("docs"));
            if (opml.getDocs() == null) {
                opml.setDocs("http://www.opml.org/spec2");
            }
        }
        opml.setFeedType("opml_2.0");
        return opml;
    }

    @Override
    protected Outline parseOutline(Element e, boolean validate, Locale locale) throws FeedException {
        Outline outline = super.parseOutline(e, validate, locale);
        Iterator<Attribute> iterator = outline.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            String name = attribute.getName();
            String value = attribute.getValue();
            if (!Arrays.asList("created", "category").contains(name)) continue;
            if ("created".equals(name)) {
                outline.setCreated(DateParser.parseRFC822((String)value, (Locale)locale));
            } else if ("category".equals(name)) {
                List<String> categories = Arrays.asList(value.split(","));
                outline.setCategories(categories);
            }
            iterator.remove();
        }
        return outline;
    }
}

