/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.mediarss.io;

import com.rometools.modules.georss.GeoRSSModule;
import com.rometools.modules.georss.SimpleParser;
import com.rometools.modules.mediarss.MediaEntryModuleImpl;
import com.rometools.modules.mediarss.MediaModuleImpl;
import com.rometools.modules.mediarss.types.Category;
import com.rometools.modules.mediarss.types.Community;
import com.rometools.modules.mediarss.types.Credit;
import com.rometools.modules.mediarss.types.Embed;
import com.rometools.modules.mediarss.types.Expression;
import com.rometools.modules.mediarss.types.Hash;
import com.rometools.modules.mediarss.types.License;
import com.rometools.modules.mediarss.types.Location;
import com.rometools.modules.mediarss.types.MediaContent;
import com.rometools.modules.mediarss.types.MediaGroup;
import com.rometools.modules.mediarss.types.Metadata;
import com.rometools.modules.mediarss.types.PeerLink;
import com.rometools.modules.mediarss.types.PlayerReference;
import com.rometools.modules.mediarss.types.Price;
import com.rometools.modules.mediarss.types.Rating;
import com.rometools.modules.mediarss.types.Restriction;
import com.rometools.modules.mediarss.types.Scene;
import com.rometools.modules.mediarss.types.StarRating;
import com.rometools.modules.mediarss.types.Statistics;
import com.rometools.modules.mediarss.types.Status;
import com.rometools.modules.mediarss.types.SubTitle;
import com.rometools.modules.mediarss.types.Tag;
import com.rometools.modules.mediarss.types.Text;
import com.rometools.modules.mediarss.types.Thumbnail;
import com.rometools.modules.mediarss.types.Time;
import com.rometools.modules.mediarss.types.UrlReference;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import com.rometools.utils.Doubles;
import com.rometools.utils.Integers;
import com.rometools.utils.Longs;
import com.rometools.utils.Strings;
import com.rometools.utils.URIs;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaModuleParser
implements ModuleParser {
    private static final Logger LOG = LoggerFactory.getLogger(MediaModuleParser.class);
    private static final Namespace NS = Namespace.getNamespace((String)"http://search.yahoo.com/mrss/");
    private static final Pattern FILESIZE_WITH_UNIT_PATTERN = Pattern.compile("([\\d,.]+)([TGMK])?B", 2);

    public String getNamespaceUri() {
        return "http://search.yahoo.com/mrss/";
    }

    public Module parse(Element mmRoot, Locale locale) {
        MediaModuleImpl mod = null;
        mod = mmRoot.getName().equals("channel") || mmRoot.getName().equals("feed") ? new MediaModuleImpl() : new MediaEntryModuleImpl();
        mod.setMetadata(this.parseMetadata(mmRoot, locale));
        mod.setPlayer(this.parsePlayer(mmRoot));
        if (mod instanceof MediaEntryModuleImpl) {
            MediaEntryModuleImpl m = (MediaEntryModuleImpl)mod;
            m.setMediaContents(this.parseContent(mmRoot, locale));
            m.setMediaGroups(this.parseGroup(mmRoot, locale));
        }
        return mod;
    }

    static long parseFileSize(String fileSizeAttrValue) {
        String nonWSFileSize = fileSizeAttrValue.replaceAll("\\s", "");
        if (nonWSFileSize.matches("\\d+")) {
            return Long.valueOf(nonWSFileSize);
        }
        Matcher sizeWithUnitMatcher = FILESIZE_WITH_UNIT_PATTERN.matcher(nonWSFileSize);
        if (sizeWithUnitMatcher.matches()) {
            BigDecimal number = new BigDecimal(sizeWithUnitMatcher.group(1).replace(',', '.'));
            BigDecimal multiplier = BigDecimal.valueOf(1L);
            if (sizeWithUnitMatcher.group(2) != null) {
                char unit = sizeWithUnitMatcher.group(2).toLowerCase().charAt(0);
                if (unit == 'k') {
                    multiplier = BigDecimal.valueOf(1000L);
                } else if (unit == 'm') {
                    multiplier = BigDecimal.valueOf(1000L).pow(2);
                } else if (unit == 'g') {
                    multiplier = BigDecimal.valueOf(1000L).pow(3);
                } else if (unit == 't') {
                    multiplier = BigDecimal.valueOf(1000L).pow(4);
                }
            }
            return number.multiply(multiplier).longValue();
        }
        throw new NumberFormatException("Invalid file size: " + fileSizeAttrValue);
    }

    private MediaContent[] parseContent(Element e, Locale locale) {
        List contents = e.getChildren("content", this.getNS());
        ArrayList<MediaContent> values = new ArrayList<MediaContent>();
        try {
            for (int i = 0; contents != null && i < contents.size(); ++i) {
                Element content = (Element)contents.get(i);
                MediaContent mc = null;
                if (content.getAttributeValue("url") != null) {
                    try {
                        mc = new MediaContent(new UrlReference(URIs.parse((String)content.getAttributeValue("url"))));
                        mc.setPlayer(this.parsePlayer(content));
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                } else {
                    mc = new MediaContent(this.parsePlayer(content));
                }
                if (mc != null) {
                    values.add(mc);
                    try {
                        if (content.getAttributeValue("channels") != null) {
                            mc.setAudioChannels(Integer.valueOf(content.getAttributeValue("channels")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    try {
                        if (content.getAttributeValue("bitrate") != null) {
                            mc.setBitrate(Float.valueOf(content.getAttributeValue("bitrate")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    try {
                        if (content.getAttributeValue("duration") != null) {
                            mc.setDuration(Longs.parseDecimal((String)content.getAttributeValue("duration")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    mc.setMedium(content.getAttributeValue("medium"));
                    String expression = content.getAttributeValue("expression");
                    if (expression != null) {
                        if (expression.equalsIgnoreCase("full")) {
                            mc.setExpression(Expression.FULL);
                        } else if (expression.equalsIgnoreCase("sample")) {
                            mc.setExpression(Expression.SAMPLE);
                        } else if (expression.equalsIgnoreCase("nonstop")) {
                            mc.setExpression(Expression.NONSTOP);
                        }
                    }
                    try {
                        if (content.getAttributeValue("fileSize") != null) {
                            mc.setFileSize(MediaModuleParser.parseFileSize(content.getAttributeValue("fileSize")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    try {
                        if (content.getAttributeValue("framerate") != null) {
                            mc.setFramerate(Float.valueOf(content.getAttributeValue("framerate")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    try {
                        if (content.getAttributeValue("height") != null) {
                            mc.setHeight(Integer.valueOf(content.getAttributeValue("height")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    mc.setLanguage(content.getAttributeValue("lang"));
                    mc.setMetadata(this.parseMetadata(content, locale));
                    try {
                        if (content.getAttributeValue("samplingrate") != null) {
                            mc.setSamplingrate(Float.valueOf(content.getAttributeValue("samplingrate")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    mc.setType(content.getAttributeValue("type"));
                    try {
                        if (content.getAttributeValue("width") != null) {
                            mc.setWidth(Integer.valueOf(content.getAttributeValue("width")));
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Exception parsing content tag.", (Throwable)ex);
                    }
                    if (content.getAttributeValue("isDefault") == null) continue;
                    mc.setDefaultContent(Boolean.valueOf(content.getAttributeValue("isDefault")));
                    continue;
                }
                LOG.warn("Could not find MediaContent.");
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception parsing content tag.", (Throwable)ex);
        }
        return values.toArray(new MediaContent[values.size()]);
    }

    private MediaGroup[] parseGroup(Element e, Locale locale) {
        List groups = e.getChildren("group", this.getNS());
        ArrayList<MediaGroup> values = new ArrayList<MediaGroup>();
        for (int i = 0; groups != null && i < groups.size(); ++i) {
            Element group = (Element)groups.get(i);
            MediaGroup g = new MediaGroup(this.parseContent(group, locale));
            for (int j = 0; j < g.getContents().length; ++j) {
                if (!g.getContents()[j].isDefaultContent()) continue;
                g.setDefaultContentIndex(new Integer(j));
                break;
            }
            g.setMetadata(this.parseMetadata(group, locale));
            values.add(g);
        }
        return values.toArray(new MediaGroup[values.size()]);
    }

    private Metadata parseMetadata(Element e, Locale locale) {
        Metadata md = new Metadata();
        this.parseCategories(e, md);
        this.parseCopyright(e, md);
        this.parseCredits(e, md);
        this.parseDescription(e, md);
        this.parseHash(e, md);
        this.parseKeywords(e, md);
        this.parseRatings(e, md);
        this.parseText(e, md);
        this.parseThumbnail(e, md);
        this.parseTitle(e, md);
        this.parseRestrictions(e, md);
        this.parseAdultMetadata(e, md);
        this.parseBackLinks(e, md);
        this.parseComments(e, md);
        this.parseCommunity(e, md);
        this.parsePrices(e, md);
        this.parseResponses(e, md);
        this.parseStatus(e, md);
        this.parseEmbed(e, md);
        this.parseLicenses(e, md);
        this.parseSubTitles(e, md);
        this.parsePeerLinks(e, md);
        this.parseRights(e, md);
        this.parseLocations(e, md, locale);
        this.parseScenes(e, md);
        return md;
    }

    private void parseScenes(Element e, Metadata md) {
        Element scenesElement = e.getChild("scenes", this.getNS());
        if (scenesElement != null) {
            List sceneElements = scenesElement.getChildren("scene", this.getNS());
            Scene[] scenes = new Scene[sceneElements.size()];
            for (int i = 0; i < sceneElements.size(); ++i) {
                String sceneEndTime;
                scenes[i] = new Scene();
                scenes[i].setTitle(((Element)sceneElements.get(i)).getChildText("sceneTitle", this.getNS()));
                scenes[i].setDescription(((Element)sceneElements.get(i)).getChildText("sceneDescription", this.getNS()));
                String sceneStartTime = ((Element)sceneElements.get(i)).getChildText("sceneStartTime", this.getNS());
                if (sceneStartTime != null) {
                    scenes[i].setStartTime(new Time(sceneStartTime));
                }
                if ((sceneEndTime = ((Element)sceneElements.get(i)).getChildText("sceneEndTime", this.getNS())) == null) continue;
                scenes[i].setEndTime(new Time(sceneEndTime));
            }
            md.setScenes(scenes);
        }
    }

    private void parseLocations(Element e, Metadata md, Locale locale) {
        List locationElements = e.getChildren("location", this.getNS());
        Location[] locations = new Location[locationElements.size()];
        SimpleParser geoRssParser = new SimpleParser();
        for (int i = 0; i < locationElements.size(); ++i) {
            Module geoRssModule;
            locations[i] = new Location();
            locations[i].setDescription(((Element)locationElements.get(i)).getAttributeValue("description"));
            if (((Element)locationElements.get(i)).getAttributeValue("start") != null) {
                locations[i].setStart(new Time(((Element)locationElements.get(i)).getAttributeValue("start")));
            }
            if (((Element)locationElements.get(i)).getAttributeValue("end") != null) {
                locations[i].setEnd(new Time(((Element)locationElements.get(i)).getAttributeValue("end")));
            }
            if ((geoRssModule = geoRssParser.parse((Element)locationElements.get(i), locale)) == null || !(geoRssModule instanceof GeoRSSModule)) continue;
            locations[i].setGeoRss((GeoRSSModule)geoRssModule);
        }
        md.setLocations(locations);
    }

    private void parseRights(Element e, Metadata md) {
        Element rightsElement = e.getChild("rights", this.getNS());
        if (rightsElement != null && rightsElement.getAttributeValue("status") != null) {
            md.setRights(Metadata.RightsStatus.valueOf(rightsElement.getAttributeValue("status")));
        }
    }

    private void parsePeerLinks(Element e, Metadata md) {
        List peerLinkElements = e.getChildren("peerLink", this.getNS());
        PeerLink[] peerLinks = new PeerLink[peerLinkElements.size()];
        for (int i = 0; i < peerLinkElements.size(); ++i) {
            peerLinks[i] = new PeerLink();
            peerLinks[i].setType(((Element)peerLinkElements.get(i)).getAttributeValue("type"));
            if (((Element)peerLinkElements.get(i)).getAttributeValue("href") == null) continue;
            try {
                peerLinks[i].setHref(new URL(((Element)peerLinkElements.get(i)).getAttributeValue("href")));
                continue;
            }
            catch (MalformedURLException ex) {
                LOG.warn("Exception parsing peerLink href attribute.", (Throwable)ex);
            }
        }
        md.setPeerLinks(peerLinks);
    }

    private void parseSubTitles(Element e, Metadata md) {
        List subTitleElements = e.getChildren("subTitle", this.getNS());
        SubTitle[] subtitles = new SubTitle[subTitleElements.size()];
        for (int i = 0; i < subTitleElements.size(); ++i) {
            subtitles[i] = new SubTitle();
            subtitles[i].setType(((Element)subTitleElements.get(i)).getAttributeValue("type"));
            subtitles[i].setLang(((Element)subTitleElements.get(i)).getAttributeValue("lang"));
            if (((Element)subTitleElements.get(i)).getAttributeValue("href") == null) continue;
            try {
                subtitles[i].setHref(new URL(((Element)subTitleElements.get(i)).getAttributeValue("href")));
                continue;
            }
            catch (MalformedURLException ex) {
                LOG.warn("Exception parsing subTitle href attribute.", (Throwable)ex);
            }
        }
        md.setSubTitles(subtitles);
    }

    private void parseLicenses(Element e, Metadata md) {
        List licenseElements = e.getChildren("license", this.getNS());
        License[] licenses = new License[licenseElements.size()];
        for (int i = 0; i < licenseElements.size(); ++i) {
            licenses[i] = new License();
            licenses[i].setType(((Element)licenseElements.get(i)).getAttributeValue("type"));
            licenses[i].setValue(((Element)licenseElements.get(i)).getTextTrim());
            if (((Element)licenseElements.get(i)).getAttributeValue("href") == null) continue;
            try {
                licenses[i].setHref(new URL(((Element)licenseElements.get(i)).getAttributeValue("href")));
                continue;
            }
            catch (MalformedURLException ex) {
                LOG.warn("Exception parsing license href attribute.", (Throwable)ex);
            }
        }
        md.setLicenses(licenses);
    }

    private void parsePrices(Element e, Metadata md) {
        List priceElements = e.getChildren("price", this.getNS());
        Price[] prices = new Price[priceElements.size()];
        for (int i = 0; i < priceElements.size(); ++i) {
            String price;
            Element priceElement = (Element)priceElements.get(i);
            prices[i] = new Price();
            String currency = priceElement.getAttributeValue("currency");
            if (currency != null) {
                try {
                    prices[i].setCurrency(Currency.getInstance(currency));
                }
                catch (IllegalArgumentException ex) {
                    LOG.warn("Invalid currency", (Throwable)ex);
                }
            }
            if ((price = priceElement.getAttributeValue("price")) != null) {
                try {
                    prices[i].setPrice(new BigDecimal(price));
                }
                catch (NumberFormatException ex) {
                    LOG.warn("Invalid price", (Throwable)ex);
                }
            }
            if (priceElement.getAttributeValue("type") != null) {
                prices[i].setType(Price.Type.valueOf(priceElement.getAttributeValue("type").toUpperCase()));
            }
            if (priceElement.getAttributeValue("info") == null) continue;
            try {
                prices[i].setInfo(new URL(priceElement.getAttributeValue("info")));
                continue;
            }
            catch (MalformedURLException ex) {
                LOG.warn("Exception parsing price info attribute.", (Throwable)ex);
            }
        }
        md.setPrices(prices);
    }

    private void parseStatus(Element e, Metadata md) {
        Element statusElement = e.getChild("status", this.getNS());
        if (statusElement != null) {
            Status status = new Status();
            status.setState(Status.State.valueOf(statusElement.getAttributeValue("state")));
            status.setReason(statusElement.getAttributeValue("reason"));
            md.setStatus(status);
        }
    }

    private void parseBackLinks(Element e, Metadata md) {
        Element backLinksElement = e.getChild("backLinks", this.getNS());
        if (backLinksElement != null) {
            List backLinkElements = backLinksElement.getChildren("backLink", this.getNS());
            URL[] backLinks = new URL[backLinkElements.size()];
            for (int i = 0; i < backLinkElements.size(); ++i) {
                try {
                    backLinks[i] = new URL(((Element)backLinkElements.get(i)).getTextTrim());
                    continue;
                }
                catch (MalformedURLException ex) {
                    LOG.warn("Exception parsing backLink tag.", (Throwable)ex);
                }
            }
            md.setBackLinks(backLinks);
        }
    }

    private void parseComments(Element e, Metadata md) {
        Element commentsElement = e.getChild("comments", this.getNS());
        if (commentsElement != null) {
            List commentElements = commentsElement.getChildren("comment", this.getNS());
            String[] comments = new String[commentElements.size()];
            for (int i = 0; i < commentElements.size(); ++i) {
                comments[i] = ((Element)commentElements.get(i)).getTextTrim();
            }
            md.setComments(comments);
        }
    }

    private void parseResponses(Element e, Metadata md) {
        Element responsesElement = e.getChild("responses", this.getNS());
        if (responsesElement != null) {
            List responseElements = responsesElement.getChildren("response", this.getNS());
            String[] responses = new String[responseElements.size()];
            for (int i = 0; i < responseElements.size(); ++i) {
                responses[i] = ((Element)responseElements.get(i)).getTextTrim();
            }
            md.setResponses(responses);
        }
    }

    private void parseCommunity(Element e, Metadata md) {
        Element communityElement = e.getChild("community", this.getNS());
        if (communityElement != null) {
            Element tagsElement;
            Element statisticsElement;
            Community community = new Community();
            Element starRatingElement = communityElement.getChild("starRating", this.getNS());
            if (starRatingElement != null) {
                StarRating starRating = new StarRating();
                starRating.setAverage(Doubles.parse((String)starRatingElement.getAttributeValue("average")));
                starRating.setCount(Integers.parse((String)starRatingElement.getAttributeValue("count")));
                starRating.setMax(Integers.parse((String)starRatingElement.getAttributeValue("max")));
                starRating.setMin(Integers.parse((String)starRatingElement.getAttributeValue("min")));
                community.setStarRating(starRating);
            }
            if ((statisticsElement = communityElement.getChild("statistics", this.getNS())) != null) {
                Statistics statistics = new Statistics();
                statistics.setFavorites(Integers.parse((String)statisticsElement.getAttributeValue("favorites")));
                statistics.setViews(Integers.parse((String)statisticsElement.getAttributeValue("views")));
                community.setStatistics(statistics);
            }
            if ((tagsElement = communityElement.getChild("tags", this.getNS())) != null) {
                String[] tags;
                String tagsText = tagsElement.getTextTrim();
                for (String tagText : tags = tagsText.split("\\s*,\\s*")) {
                    String[] tagParts = tagText.split("\\s*:\\s*");
                    Tag tag = new Tag(tagParts[0]);
                    if (tagParts.length > 1) {
                        tag.setWeight(Integers.parse((String)tagParts[1]));
                    }
                    community.getTags().add(tag);
                }
            }
            md.setCommunity(community);
        }
    }

    private void parseCategories(Element e, Metadata md) {
        List categories = e.getChildren("category", this.getNS());
        ArrayList<Category> values = new ArrayList<Category>();
        for (int i = 0; categories != null && i < categories.size(); ++i) {
            try {
                Element cat = (Element)categories.get(i);
                values.add(new Category(cat.getAttributeValue("scheme"), cat.getAttributeValue("label"), cat.getText()));
                continue;
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing category tag.", (Throwable)ex);
            }
        }
        md.setCategories(values.toArray(new Category[values.size()]));
    }

    private void parseCopyright(Element e, Metadata md) {
        try {
            Element copy = e.getChild("copyright", this.getNS());
            if (copy != null) {
                md.setCopyright(copy.getText());
                if (copy.getAttributeValue("url") != null) {
                    md.setCopyrightUrl(new URI(copy.getAttributeValue("url")));
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception parsing copyright tag.", (Throwable)ex);
        }
    }

    private void parseCredits(Element e, Metadata md) {
        List credits = e.getChildren("credit", this.getNS());
        ArrayList<Credit> values = new ArrayList<Credit>();
        for (int i = 0; credits != null && i < credits.size(); ++i) {
            try {
                Element cred = (Element)credits.get(i);
                values.add(new Credit(cred.getAttributeValue("scheme"), cred.getAttributeValue("role"), cred.getText()));
                md.setCredits(values.toArray(new Credit[values.size()]));
                continue;
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing credit tag.", (Throwable)ex);
            }
        }
    }

    private void parseDescription(Element e, Metadata md) {
        try {
            Element description = e.getChild("description", this.getNS());
            if (description != null) {
                md.setDescription(description.getText());
                md.setDescriptionType(description.getAttributeValue("type"));
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception parsing description tag.", (Throwable)ex);
        }
    }

    private void parseEmbed(Element e, Metadata md) {
        Element embedElement = e.getChild("embed", this.getNS());
        if (embedElement != null) {
            Embed embed = new Embed();
            embed.setWidth(Integers.parse((String)embedElement.getAttributeValue("width")));
            embed.setHeight(Integers.parse((String)embedElement.getAttributeValue("height")));
            if (embedElement.getAttributeValue("url") != null) {
                try {
                    embed.setUrl(new URL(embedElement.getAttributeValue("url")));
                }
                catch (MalformedURLException ex) {
                    LOG.warn("Exception parsing embed tag.", (Throwable)ex);
                }
            }
            List paramElements = embedElement.getChildren("param", this.getNS());
            embed.setParams(new Embed.Param[paramElements.size()]);
            for (int i = 0; i < paramElements.size(); ++i) {
                embed.getParams()[i] = new Embed.Param(((Element)paramElements.get(i)).getAttributeValue("name"), ((Element)paramElements.get(i)).getTextTrim());
            }
            md.setEmbed(embed);
        }
    }

    private void parseHash(Element e, Metadata md) {
        try {
            Element hash = e.getChild("hash", this.getNS());
            if (hash != null) {
                md.setHash(new Hash(hash.getAttributeValue("algo"), hash.getText()));
            }
        }
        catch (Exception ex) {
            LOG.warn("Exception parsing hash tag.", (Throwable)ex);
        }
    }

    private void parseKeywords(Element e, Metadata md) {
        Element keywords = e.getChild("keywords", this.getNS());
        if (keywords != null) {
            StringTokenizer tok = new StringTokenizer(keywords.getText(), ",");
            String[] value = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                value[i] = tok.nextToken().trim();
                ++i;
            }
            md.setKeywords(value);
        }
    }

    private void parseRatings(Element e, Metadata md) {
        ArrayList<Rating> values = new ArrayList<Rating>();
        List ratings = e.getChildren("rating", this.getNS());
        for (Element ratingElement : ratings) {
            try {
                String ratingText = ratingElement.getText();
                String ratingScheme = Strings.trimToNull((String)ratingElement.getAttributeValue("scheme"));
                if (ratingScheme == null) {
                    ratingScheme = "urn:simple";
                }
                Rating rating = new Rating(ratingScheme, ratingText);
                values.add(rating);
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing rating tag.", (Throwable)ex);
            }
        }
        md.setRatings(values.toArray(new Rating[values.size()]));
    }

    private void parseText(Element e, Metadata md) {
        List texts = e.getChildren("text", this.getNS());
        ArrayList<Text> values = new ArrayList<Text>();
        for (int i = 0; texts != null && i < texts.size(); ++i) {
            try {
                Element text = (Element)texts.get(i);
                Time start = null;
                if (text.getAttributeValue("start") != null) {
                    start = new Time(text.getAttributeValue("start"));
                }
                Time end = null;
                if (text.getAttributeValue("end") != null) {
                    end = new Time(text.getAttributeValue("end"));
                }
                values.add(new Text(text.getAttributeValue("type"), text.getTextTrim(), start, end));
                continue;
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing text tag.", (Throwable)ex);
            }
        }
        md.setText(values.toArray(new Text[values.size()]));
    }

    private void parseThumbnail(Element e, Metadata md) {
        ArrayList<Thumbnail> values = new ArrayList<Thumbnail>();
        List thumbnails = e.getChildren("thumbnail", this.getNS());
        for (Element thumb : thumbnails) {
            try {
                String timeAttr = Strings.trimToNull((String)thumb.getAttributeValue("time"));
                Time time = null;
                if (timeAttr != null) {
                    time = new Time(timeAttr);
                }
                String widthAttr = thumb.getAttributeValue("width");
                Integer width = Integers.parse((String)widthAttr);
                String heightAttr = thumb.getAttributeValue("height");
                Integer height = Integers.parse((String)heightAttr);
                String url = thumb.getAttributeValue("url");
                URI uri = new URI(url);
                Thumbnail thumbnail = new Thumbnail(uri, width, height, time);
                values.add(thumbnail);
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing thumbnail tag.", (Throwable)ex);
            }
        }
        md.setThumbnail(values.toArray(new Thumbnail[values.size()]));
    }

    private void parseTitle(Element e, Metadata md) {
        Element title = e.getChild("title", this.getNS());
        if (title != null) {
            md.setTitle(title.getText());
            md.setTitleType(title.getAttributeValue("type"));
        }
    }

    private void parseRestrictions(Element e, Metadata md) {
        List restrictions = e.getChildren("restriction", this.getNS());
        ArrayList<Restriction> values = new ArrayList<Restriction>();
        for (int i = 0; i < restrictions.size(); ++i) {
            Element r = (Element)restrictions.get(i);
            Restriction.Type type = null;
            String restrictionType = r.getAttributeValue("type");
            if (restrictionType != null) {
                if (restrictionType.equalsIgnoreCase(Restriction.Type.URI.toString())) {
                    type = Restriction.Type.URI;
                } else if (restrictionType.equalsIgnoreCase(Restriction.Type.COUNTRY.toString())) {
                    type = Restriction.Type.COUNTRY;
                } else if (restrictionType.equalsIgnoreCase(Restriction.Type.SHARING.toString())) {
                    type = Restriction.Type.SHARING;
                }
            }
            Restriction.Relationship relationship = null;
            if (r.getAttributeValue("relationship").equalsIgnoreCase("allow")) {
                relationship = Restriction.Relationship.ALLOW;
            } else if (r.getAttributeValue("relationship").equalsIgnoreCase("deny")) {
                relationship = Restriction.Relationship.DENY;
            }
            Restriction value = new Restriction(relationship, type, r.getTextTrim());
            values.add(value);
        }
        md.setRestrictions(values.toArray(new Restriction[values.size()]));
    }

    private void parseAdultMetadata(Element e, Metadata md) {
        Element adult = e.getChild("adult", this.getNS());
        if (adult != null && md.getRatings().length == 0) {
            Rating[] r = new Rating[]{adult.getTextTrim().equals("true") ? new Rating("urn:simple", "adult") : new Rating("urn:simple", "nonadult")};
            md.setRatings(r);
        }
    }

    private PlayerReference parsePlayer(Element e) {
        Element player = e.getChild("player", this.getNS());
        PlayerReference p = null;
        if (player != null) {
            try {
                Integer width = null;
                if (player.getAttributeValue("width") != null) {
                    width = Integer.valueOf(player.getAttributeValue("width"));
                }
                Integer height = null;
                if (player.getAttributeValue("height") != null) {
                    height = Integer.valueOf(player.getAttributeValue("height"));
                }
                p = new PlayerReference(new URI(player.getAttributeValue("url")), width, height);
            }
            catch (Exception ex) {
                LOG.warn("Exception parsing player tag.", (Throwable)ex);
            }
        }
        return p;
    }

    public Namespace getNS() {
        return NS;
    }
}

