/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.mediarss.types;

import com.rometools.modules.mediarss.types.Expression;
import com.rometools.modules.mediarss.types.Metadata;
import com.rometools.modules.mediarss.types.PlayerReference;
import com.rometools.modules.mediarss.types.Reference;
import com.rometools.rome.feed.impl.EqualsBean;
import com.rometools.rome.feed.impl.ToStringBean;
import java.io.Serializable;

public class MediaContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Expression expression;
    private Float bitrate = null;
    private Float framerate = null;
    private Float samplingrate = null;
    private Integer audioChannels = null;
    private Integer height = null;
    private Integer width = null;
    private Long duration = null;
    private Long fileSize = null;
    private Metadata metadata;
    private PlayerReference player;
    private Reference reference;
    private String language;
    private String medium;
    private String type = null;
    private boolean defaultContent;

    public MediaContent(Reference reference) {
        if (reference == null) {
            throw new NullPointerException("You must provide either a PlayerReference or URL reference.");
        }
        this.setReference(reference);
    }

    public void setAudioChannels(Integer audioChannels) {
        this.audioChannels = audioChannels;
    }

    public Integer getAudioChannels() {
        return this.audioChannels;
    }

    public void setBitrate(Float bitrate) {
        this.bitrate = bitrate;
    }

    public Float getBitrate() {
        return this.bitrate;
    }

    public void setDefaultContent(boolean defaultContent) {
        this.defaultContent = defaultContent;
    }

    public boolean isDefaultContent() {
        return this.defaultContent;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFramerate(Float framerate) {
        this.framerate = framerate;
    }

    public Float getFramerate() {
        return this.framerate;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setMedium(String newmedium) {
        this.medium = newmedium;
    }

    public String getMedium() {
        return this.medium;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setPlayer(PlayerReference player) {
        this.player = player;
    }

    public PlayerReference getPlayer() {
        return this.player;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
        if (reference instanceof PlayerReference) {
            this.setPlayer((PlayerReference)reference);
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setSamplingrate(Float samplingrate) {
        this.samplingrate = samplingrate;
    }

    public Float getSamplingrate() {
        return this.samplingrate;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Object clone() {
        MediaContent c = new MediaContent(this.getReference());
        c.setAudioChannels(this.getAudioChannels());
        c.setBitrate(this.getBitrate());
        c.setDefaultContent(this.isDefaultContent());
        c.setDuration(this.getDuration());
        c.setExpression(this.getExpression());
        c.setFileSize(this.getFileSize());
        c.setFramerate(this.getFramerate());
        c.setHeight(this.getHeight());
        c.setLanguage(this.getLanguage());
        c.setMetadata(this.getMetadata() == null ? null : (Metadata)this.getMetadata().clone());
        c.setPlayer(this.getPlayer());
        c.setSamplingrate(this.getSamplingrate());
        c.setType(this.getType());
        c.setWidth(this.getWidth());
        return c;
    }

    public boolean equals(Object obj) {
        EqualsBean eBean = new EqualsBean(MediaContent.class, (Object)this);
        return eBean.beanEquals(obj);
    }

    public int hashCode() {
        EqualsBean equals = new EqualsBean(MediaContent.class, (Object)this);
        return equals.beanHashCode();
    }

    public String toString() {
        ToStringBean tsBean = new ToStringBean(MediaContent.class, (Object)this);
        return tsBean.toString();
    }
}

