/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.base.io;

import com.rometools.modules.base.GoogleBase;
import com.rometools.modules.base.GoogleBaseImpl;
import com.rometools.modules.base.types.CurrencyEnumeration;
import com.rometools.modules.base.types.DateTimeRange;
import com.rometools.modules.base.types.FloatUnit;
import com.rometools.modules.base.types.GenderEnumeration;
import com.rometools.modules.base.types.IntUnit;
import com.rometools.modules.base.types.PaymentTypeEnumeration;
import com.rometools.modules.base.types.PriceTypeEnumeration;
import com.rometools.modules.base.types.ShippingType;
import com.rometools.modules.base.types.Size;
import com.rometools.modules.base.types.YearType;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBaseParser
implements ModuleParser {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleBaseParser.class);
    public static final char[] INTEGER_CHARS = "-1234567890".toCharArray();
    public static final char[] FLOAT_CHARS = "-1234567890.".toCharArray();
    public static final SimpleDateFormat SHORT_DT_FMT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat LONG_DT_FMT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    static final Namespace NS = Namespace.getNamespace((String)"http://base.google.com/ns/1.0");
    static final Properties PROPS2TAGS = new Properties();
    static PropertyDescriptor[] pds = null;

    public Module parse(Element element, Locale locale) {
        HashMap<String, PropertyDescriptor> tag2pd = new HashMap<String, PropertyDescriptor>();
        GoogleBaseImpl module = new GoogleBaseImpl();
        try {
            for (PropertyDescriptor pd : pds) {
                String tagName = PROPS2TAGS.getProperty(pd.getName());
                if (tagName == null) {
                    LOG.debug("Property: {} doesn't have a tag mapping.", (Object)pd.getName());
                    continue;
                }
                tag2pd.put(tagName, pd);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception building tag to property mapping. ", e);
        }
        List children = element.getChildren();
        for (Element child : children) {
            PropertyDescriptor pd;
            if (!child.getNamespace().equals((Object)NS) || (pd = (PropertyDescriptor)tag2pd.get(child.getName())) == null) continue;
            try {
                this.handleTag(child, pd, module);
            }
            catch (Exception e) {
                LOG.warn("Unable to handle tag: " + child.getName(), (Throwable)e);
            }
        }
        return module;
    }

    public static String stripNonValidCharacters(char[] validCharacters, String input) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            for (char validCharacter : validCharacters) {
                if (input.charAt(i) != validCharacter) continue;
                newString.append(validCharacter);
            }
        }
        return newString.toString();
    }

    public String getNamespaceUri() {
        return "http://base.google.com/ns/1.0";
    }

    private void handleTag(Element tag, PropertyDescriptor pd, GoogleBase module) throws Exception {
        Object tagValue = null;
        if (pd.getPropertyType() == Integer.class || pd.getPropertyType().getComponentType() == Integer.class) {
            tagValue = new Integer(GoogleBaseParser.stripNonValidCharacters(INTEGER_CHARS, tag.getText()));
        } else if (pd.getPropertyType() == Float.class || pd.getPropertyType().getComponentType() == Float.class) {
            tagValue = new Float(GoogleBaseParser.stripNonValidCharacters(FLOAT_CHARS, tag.getText()));
        } else if (pd.getPropertyType() == String.class || pd.getPropertyType().getComponentType() == String.class) {
            tagValue = tag.getText();
        } else if (pd.getPropertyType() == URL.class || pd.getPropertyType().getComponentType() == URL.class) {
            tagValue = new URL(tag.getText().trim());
        } else if (pd.getPropertyType() == Boolean.class || pd.getPropertyType().getComponentType() == Boolean.class) {
            tagValue = new Boolean(tag.getText().trim());
        } else if (pd.getPropertyType() == Date.class || pd.getPropertyType().getComponentType() == Date.class) {
            String text = tag.getText().trim();
            tagValue = text.length() > 10 ? LONG_DT_FMT.parse(text) : SHORT_DT_FMT.parse(text);
        } else if (pd.getPropertyType() == IntUnit.class || pd.getPropertyType().getComponentType() == IntUnit.class) {
            tagValue = new IntUnit(tag.getText());
        } else if (pd.getPropertyType() == FloatUnit.class || pd.getPropertyType().getComponentType() == FloatUnit.class) {
            tagValue = new FloatUnit(tag.getText());
        } else if (pd.getPropertyType() == DateTimeRange.class || pd.getPropertyType().getComponentType() == DateTimeRange.class) {
            tagValue = new DateTimeRange(LONG_DT_FMT.parse(tag.getChild("start", NS).getText().trim()), LONG_DT_FMT.parse(tag.getChild("end", NS).getText().trim()));
        } else if (pd.getPropertyType() == ShippingType.class || pd.getPropertyType().getComponentType() == ShippingType.class) {
            FloatUnit price = new FloatUnit(tag.getChild("price", NS).getText().trim());
            ShippingType.ServiceEnumeration service = ShippingType.ServiceEnumeration.findByValue(tag.getChild("service", NS).getText().trim());
            if (service == null) {
                service = ShippingType.ServiceEnumeration.STANDARD;
            }
            String country = tag.getChild("country", NS).getText().trim();
            tagValue = new ShippingType(price, service, country);
        } else if (pd.getPropertyType() == PaymentTypeEnumeration.class || pd.getPropertyType().getComponentType() == PaymentTypeEnumeration.class) {
            tagValue = PaymentTypeEnumeration.findByValue(tag.getText().trim());
        } else if (pd.getPropertyType() == PriceTypeEnumeration.class || pd.getPropertyType().getComponentType() == PriceTypeEnumeration.class) {
            tagValue = PriceTypeEnumeration.findByValue(tag.getText().trim());
        } else if (pd.getPropertyType() == CurrencyEnumeration.class || pd.getPropertyType().getComponentType() == CurrencyEnumeration.class) {
            tagValue = CurrencyEnumeration.findByValue(tag.getText().trim());
        } else if (pd.getPropertyType() == GenderEnumeration.class || pd.getPropertyType().getComponentType() == GenderEnumeration.class) {
            tagValue = GenderEnumeration.findByValue(tag.getText().trim());
        } else if (pd.getPropertyType() == YearType.class || pd.getPropertyType().getComponentType() == YearType.class) {
            tagValue = new YearType(tag.getText().trim());
        } else if (pd.getPropertyType() == Size.class || pd.getPropertyType().getComponentType() == Size.class) {
            tagValue = new Size(tag.getText().trim());
        }
        if (!pd.getPropertyType().isArray()) {
            pd.getWriteMethod().invoke((Object)module, tagValue);
        } else {
            int i;
            Object[] current = (Object[])pd.getReadMethod().invoke((Object)module, (Object[])null);
            int newSize = current == null ? 1 : current.length + 1;
            Object setValue = Array.newInstance(pd.getPropertyType().getComponentType(), newSize);
            for (i = 0; current != null && i < current.length; ++i) {
                Array.set(setValue, i, current[i]);
            }
            Array.set(setValue, i, tagValue);
            pd.getWriteMethod().invoke((Object)module, setValue);
        }
    }

    static {
        try {
            pds = Introspector.getBeanInfo(GoogleBaseImpl.class).getPropertyDescriptors();
            PROPS2TAGS.load(GoogleBaseParser.class.getResourceAsStream("/com/rometools/modules/base/io/tags.properties"));
        }
        catch (IOException e) {
            LOG.error("Unable to read properties file for Google Base tags!", (Throwable)e);
        }
        catch (IntrospectionException e) {
            LOG.error("Unable to get property descriptors for GoogleBaseImpl!", (Throwable)e);
        }
    }
}

