/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.itunes;

import com.rometools.modules.itunes.AbstractITunesObject;
import com.rometools.modules.itunes.FeedInformation;
import com.rometools.modules.itunes.types.Category;
import com.rometools.rome.feed.CopyFrom;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedInformationImpl
extends AbstractITunesObject
implements FeedInformation {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FeedInformationImpl.class);
    private String ownerName;
    private String ownerEmailAddress;
    private URL image;
    private List<Category> categories;

    @Override
    public List<Category> getCategories() {
        return this.categories == null ? (this.categories = new ArrayList<Category>()) : this.categories;
    }

    @Override
    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public String getOwnerEmailAddress() {
        return this.ownerEmailAddress;
    }

    @Override
    public void setOwnerEmailAddress(String ownerEmailAddress) {
        this.ownerEmailAddress = ownerEmailAddress;
    }

    @Override
    public URL getImage() {
        return this.image;
    }

    @Override
    public void setImage(URL image) {
        this.image = image;
    }

    public void copyFrom(CopyFrom obj) {
        FeedInformationImpl info = (FeedInformationImpl)obj;
        this.setAuthor(info.getAuthor());
        this.setBlock(info.getBlock());
        this.getCategories().clear();
        if (info.getCategories() != null) {
            this.getCategories().addAll(info.getCategories());
        }
        this.setExplicit(info.getExplicit());
        try {
            if (info.getImage() != null) {
                this.setImage(new URL(info.getImage().toExternalForm()));
            }
        }
        catch (MalformedURLException e) {
            LOG.debug("Error copying URL:" + info.getImage(), (Throwable)e);
        }
        if (info.getKeywords() != null) {
            this.setKeywords((String[])info.getKeywords().clone());
        }
        this.setOwnerEmailAddress(info.getOwnerEmailAddress());
        this.setOwnerName(info.getOwnerName());
        this.setSubtitle(info.getSubtitle());
        this.setSummary(info.getSummary());
    }

    @Override
    public Object clone() {
        FeedInformationImpl info = new FeedInformationImpl();
        info.copyFrom((CopyFrom)this);
        return info;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(" email: ");
        sb.append(this.getOwnerEmailAddress());
        sb.append(" name: ");
        sb.append(this.getOwnerName());
        sb.append(" image: ");
        sb.append(this.getImage());
        sb.append(" categories: ");
        sb.append(this.getCategories());
        sb.append("]");
        sb.append(super.toString());
        return sb.toString();
    }
}

