/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.itunes.io;

import com.rometools.modules.itunes.AbstractITunesObject;
import com.rometools.modules.itunes.EntryInformationImpl;
import com.rometools.modules.itunes.FeedInformationImpl;
import com.rometools.modules.itunes.types.Category;
import com.rometools.modules.itunes.types.Subcategory;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ITunesGenerator
implements ModuleGenerator {
    private static final HashSet<Namespace> NAMESPACES = new HashSet();
    private static final Namespace NAMESPACE = Namespace.getNamespace((String)"itunes", (String)"http://www.itunes.com/dtds/podcast-1.0.dtd");

    public void generate(Module module, Element element) {
        AbstractITunesObject info;
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)root.getParent();
        }
        root.addNamespaceDeclaration(NAMESPACE);
        if (!(module instanceof AbstractITunesObject)) {
            return;
        }
        AbstractITunesObject itunes = (AbstractITunesObject)module;
        if (itunes instanceof FeedInformationImpl) {
            info = (FeedInformationImpl)itunes;
            Element owner = this.generateSimpleElement("owner", "");
            Element email = this.generateSimpleElement("email", ((FeedInformationImpl)info).getOwnerEmailAddress());
            owner.addContent((Content)email);
            Element name = this.generateSimpleElement("name", ((FeedInformationImpl)info).getOwnerName());
            owner.addContent((Content)name);
            element.addContent((Content)owner);
            List<Category> categories = ((FeedInformationImpl)info).getCategories();
            for (Category cat : categories) {
                Element category = this.generateSimpleElement("category", "");
                category.setAttribute("text", cat.getName());
                for (Subcategory subcategory : cat.getSubcategories()) {
                    Element subcat = this.generateSimpleElement("category", "");
                    subcat.setAttribute("text", subcategory.getName());
                    category.addContent((Content)subcat);
                }
                element.addContent((Content)category);
            }
            if (((FeedInformationImpl)info).getType() != null) {
                element.addContent((Content)this.generateSimpleElement("type", ((FeedInformationImpl)info).getType()));
            }
            if (((FeedInformationImpl)info).getComplete()) {
                element.addContent((Content)this.generateSimpleElement("complete", "yes"));
            }
            if (((FeedInformationImpl)info).getNewFeedUrl() != null) {
                element.addContent((Content)this.generateSimpleElement("new-feed-url", ((FeedInformationImpl)info).getNewFeedUrl()));
            }
        } else if (itunes instanceof EntryInformationImpl) {
            info = (EntryInformationImpl)itunes;
            if (((EntryInformationImpl)info).getDuration() != null) {
                element.addContent((Content)this.generateSimpleElement("duration", ((EntryInformationImpl)info).getDuration().toString()));
            }
            if (((EntryInformationImpl)info).getClosedCaptioned()) {
                element.addContent((Content)this.generateSimpleElement("isClosedCaptioned", "yes"));
            }
            if (((EntryInformationImpl)info).getOrder() != null) {
                element.addContent((Content)this.generateSimpleElement("order", ((EntryInformationImpl)info).getOrder().toString()));
            }
            if (((EntryInformationImpl)info).getEpisodeType() != null) {
                element.addContent((Content)this.generateSimpleElement("episodeType", ((EntryInformationImpl)info).getEpisodeType()));
            }
            if (((EntryInformationImpl)info).getSeason() != null && ((EntryInformationImpl)info).getSeason() > 0) {
                element.addContent((Content)this.generateSimpleElement("season", ((EntryInformationImpl)info).getSeason().toString()));
            }
            if (((EntryInformationImpl)info).getEpisode() != null && ((EntryInformationImpl)info).getEpisode() > 0) {
                element.addContent((Content)this.generateSimpleElement("episode", ((EntryInformationImpl)info).getEpisode().toString()));
            }
            if (((EntryInformationImpl)info).getTitle() != null) {
                element.addContent((Content)this.generateSimpleElement("title", ((EntryInformationImpl)info).getTitle()));
            }
        }
        if (itunes.getAuthor() != null) {
            element.addContent((Content)this.generateSimpleElement("author", itunes.getAuthor()));
        }
        if (itunes.getBlock()) {
            element.addContent((Content)this.generateSimpleElement("block", "Yes"));
        }
        if (itunes.getExplicitNullable() != null) {
            if (itunes.getExplicitNullable().booleanValue()) {
                element.addContent((Content)this.generateSimpleElement("explicit", "yes"));
            } else {
                element.addContent((Content)this.generateSimpleElement("explicit", "no"));
            }
        }
        if (itunes.getImage() != null) {
            Element image = this.generateSimpleElement("image", "");
            image.setAttribute("href", itunes.getImageUri().toString());
            element.addContent((Content)image);
        }
        if (itunes.getKeywords() != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < itunes.getKeywords().length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(itunes.getKeywords()[i]);
            }
            element.addContent((Content)this.generateSimpleElement("keywords", sb.toString()));
        }
        if (itunes.getSubtitle() != null) {
            element.addContent((Content)this.generateSimpleElement("subtitle", itunes.getSubtitle()));
        }
        if (itunes.getSummary() != null) {
            element.addContent((Content)this.generateSimpleElement("summary", itunes.getSummary()));
        }
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public String getNamespaceUri() {
        return "http://www.itunes.com/dtds/podcast-1.0.dtd";
    }

    protected Element generateSimpleElement(String name, String value) {
        Element element = new Element(name, NAMESPACE);
        element.addContent(value);
        return element;
    }

    static {
        NAMESPACES.add(NAMESPACE);
    }
}

