/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.psc.io;

import com.rometools.modules.psc.modules.PodloveSimpleChapterModule;
import com.rometools.modules.psc.types.SimpleChapter;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PodloveSimpleChapterGenerator
implements ModuleGenerator {
    private static final Namespace NS = Namespace.getNamespace((String)"psc", (String)"http://podlove.org/simple-chapters");
    private static final Set<Namespace> NAMESPACES;

    public final String getNamespaceUri() {
        return "http://podlove.org/simple-chapters";
    }

    public final Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        if (module instanceof PodloveSimpleChapterModule) {
            PodloveSimpleChapterModule m = (PodloveSimpleChapterModule)module;
            this.generateChapters(m.getChapters(), element);
        }
    }

    private void generateChapters(List<SimpleChapter> chapters, Element parent) {
        Element cs = new Element("chapters", NS);
        cs.setAttribute("version", "1.2");
        for (SimpleChapter c : chapters) {
            cs.addContent((Content)this.generateChapter(c));
        }
        parent.addContent((Content)cs);
    }

    private Element generateChapter(SimpleChapter c) {
        Element e = new Element("chapter", NS);
        this.addNotNullAttribute(e, "start", c.getStart());
        this.addNotNullAttribute(e, "title", c.getTitle());
        this.addNotNullAttribute(e, "href", c.getHref());
        this.addNotNullAttribute(e, "image", c.getImage());
        return e;
    }

    private void addNotNullAttribute(Element target, String name, Object value) {
        if (target == null || value == null) {
            return;
        }
        target.setAttribute(name, value.toString());
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

