/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.tesseract.android;

import android.graphics.Bitmap;
import android.graphics.Rect;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.Pixa;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessPdfRenderer;
import java.io.File;

public class TessBaseAPI {
    private long mNativeData;
    public static final String VAR_CHAR_WHITELIST = "tessedit_char_whitelist";
    public static final String VAR_CHAR_BLACKLIST = "tessedit_char_blacklist";
    public static final String VAR_SAVE_BLOB_CHOICES = "save_blob_choices";
    public static final String VAR_TRUE = "T";
    public static final String VAR_FALSE = "F";
    public static final int OEM_TESSERACT_ONLY = 0;
    @Deprecated
    public static final int OEM_CUBE_ONLY = 1;
    @Deprecated
    public static final int OEM_TESSERACT_CUBE_COMBINED = 2;
    public static final int OEM_DEFAULT = 3;
    private ProgressNotifier progressNotifier;
    private boolean mRecycled;

    public TessBaseAPI() {
        this.nativeConstruct();
        this.mRecycled = false;
    }

    public TessBaseAPI(ProgressNotifier progressNotifier) {
        this.progressNotifier = progressNotifier;
        this.nativeConstruct();
        this.mRecycled = false;
    }

    public boolean init(String datapath, String language) {
        return this.init(datapath, language, 3);
    }

    public boolean init(String datapath, String language, int ocrEngineMode) {
        boolean success;
        File datapathFile;
        if (datapath == null) {
            throw new IllegalArgumentException("Data path must not be null!");
        }
        if (!datapath.endsWith(File.separator)) {
            datapath = datapath + File.separator;
        }
        if (!(datapathFile = new File(datapath)).exists()) {
            throw new IllegalArgumentException("Data path does not exist!");
        }
        File tessdata = new File(datapath + "tessdata");
        if (!tessdata.exists() || !tessdata.isDirectory()) {
            throw new IllegalArgumentException("Data path must contain subfolder tessdata!");
        }
        if (ocrEngineMode != 1) {
            for (String languageCode : language.split("\\+")) {
                File datafile;
                if (languageCode.startsWith("~") || (datafile = new File(tessdata + File.separator + languageCode + ".traineddata")).exists()) continue;
                throw new IllegalArgumentException("Data file not found at " + datafile);
            }
        }
        if (success = this.nativeInitOem(datapath, language, ocrEngineMode)) {
            this.mRecycled = false;
        }
        return success;
    }

    public String getInitLanguagesAsString() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeGetInitLanguagesAsString();
    }

    public void clear() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeClear();
    }

    public void end() {
        if (!this.mRecycled) {
            this.nativeEnd();
            this.mRecycled = true;
        }
    }

    public boolean setVariable(String var, String value) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeSetVariable(var, value);
    }

    public int getPageSegMode() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeGetPageSegMode();
    }

    public void setPageSegMode(int mode) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetPageSegMode(mode);
    }

    public void setDebug(boolean enabled) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetDebug(enabled);
    }

    public void setRectangle(Rect rect) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.setRectangle(rect.left, rect.top, rect.width(), rect.height());
    }

    public void setRectangle(int left, int top, int width, int height) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetRectangle(left, top, width, height);
    }

    public void setImage(File file) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        Pix image = ReadFile.readFile(file);
        if (image == null) {
            throw new RuntimeException("Failed to read image file");
        }
        this.nativeSetImagePix(image.getNativePix());
    }

    public void setImage(Bitmap bmp) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        Pix image = ReadFile.readBitmap(bmp);
        if (image == null) {
            throw new RuntimeException("Failed to read bitmap");
        }
        this.nativeSetImagePix(image.getNativePix());
    }

    public void setImage(Pix image) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetImagePix(image.getNativePix());
    }

    public void setImage(byte[] imagedata, int width, int height, int bpp, int bpl) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetImageBytes(imagedata, width, height, bpp, bpl);
    }

    public String getUTF8Text() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        String text = this.nativeGetUTF8Text();
        return text != null ? text.trim() : null;
    }

    public int meanConfidence() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeMeanConfidence();
    }

    public int[] wordConfidences() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        int[] conf = this.nativeWordConfidences();
        if (conf == null) {
            conf = new int[]{};
        }
        return conf;
    }

    public Pix getThresholdedImage() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pix(this.nativeGetThresholdedImage());
    }

    public Pixa getRegions() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetRegions(), 0, 0);
    }

    public Pixa getTextlines() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetTextlines(), 0, 0);
    }

    public Pixa getStrips() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetStrips(), 0, 0);
    }

    public Pixa getWords() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetWords(), 0, 0);
    }

    public Pixa getConnectedComponents() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return new Pixa(this.nativeGetConnectedComponents(), 0, 0);
    }

    public ResultIterator getResultIterator() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        long nativeResultIterator = this.nativeGetResultIterator();
        if (nativeResultIterator == 0L) {
            return null;
        }
        return new ResultIterator(nativeResultIterator);
    }

    public String getHOCRText(int page) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeGetHOCRText(page);
    }

    public void setInputName(String name) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetInputName(name);
    }

    public void setOutputName(String name) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeSetOutputName(name);
    }

    public void readConfigFile(String filename) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeReadConfigFile(filename);
    }

    @Deprecated
    public void ReadConfigFile(String filename) {
        this.readConfigFile(filename);
    }

    public String getBoxText(int page) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.nativeGetBoxText(page);
    }

    public void stop() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        this.nativeStop();
    }

    protected void onProgressValues(int percent, int left, int right, int top, int bottom, int textLeft, int textRight, int textTop, int textBottom) {
        if (this.progressNotifier != null) {
            Rect wordRect = new Rect(left, textTop - top, right, textTop - bottom);
            Rect textRect = new Rect(textLeft, textBottom, textRight, textTop);
            ProgressValues pv = new ProgressValues(percent, wordRect, textRect);
            this.progressNotifier.onProgressValues(pv);
        }
    }

    public boolean beginDocument(TessPdfRenderer tessPdfRenderer, String title) {
        return this.nativeBeginDocument(tessPdfRenderer.getNativePdfRenderer(), title);
    }

    public boolean beginDocument(TessPdfRenderer tessPdfRenderer) {
        return this.nativeBeginDocument(tessPdfRenderer.getNativePdfRenderer(), "");
    }

    public boolean endDocument(TessPdfRenderer tessPdfRenderer) {
        return this.nativeEndDocument(tessPdfRenderer.getNativePdfRenderer());
    }

    public boolean addPageToDocument(Pix imageToProcess, String imageToWrite, TessPdfRenderer tessPdfRenderer) {
        return this.nativeAddPageToDocument(imageToProcess.getNativePix(), imageToWrite, tessPdfRenderer.getNativePdfRenderer());
    }

    private static native void nativeClassInit();

    private native void nativeConstruct();

    private native void nativeEnd();

    private native boolean nativeInit(String var1, String var2);

    private native boolean nativeInitOem(String var1, String var2, int var3);

    private native String nativeGetInitLanguagesAsString();

    private native void nativeClear();

    private native void nativeSetImageBytes(byte[] var1, int var2, int var3, int var4, int var5);

    private native void nativeSetImagePix(long var1);

    private native void nativeSetRectangle(int var1, int var2, int var3, int var4);

    private native String nativeGetUTF8Text();

    private native int nativeMeanConfidence();

    private native int[] nativeWordConfidences();

    private native boolean nativeSetVariable(String var1, String var2);

    private native void nativeSetDebug(boolean var1);

    private native int nativeGetPageSegMode();

    private native void nativeSetPageSegMode(int var1);

    private native long nativeGetThresholdedImage();

    private native long nativeGetRegions();

    private native long nativeGetTextlines();

    private native long nativeGetStrips();

    private native long nativeGetWords();

    private native long nativeGetConnectedComponents();

    private native long nativeGetResultIterator();

    private native String nativeGetBoxText(int var1);

    private native String nativeGetHOCRText(int var1);

    private native void nativeSetInputName(String var1);

    private native void nativeSetOutputName(String var1);

    private native void nativeReadConfigFile(String var1);

    private native void nativeStop();

    private native boolean nativeBeginDocument(long var1, String var3);

    private native boolean nativeEndDocument(long var1);

    private native boolean nativeAddPageToDocument(long var1, String var3, long var4);

    static {
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
        System.loadLibrary("tess");
        TessBaseAPI.nativeClassInit();
    }

    public class ProgressValues {
        private final int percent;
        private final Rect wordRect;
        private final Rect textRect;

        public ProgressValues(int percent, Rect wordRect, Rect textRect) {
            this.percent = percent;
            this.wordRect = wordRect;
            this.textRect = textRect;
        }

        public int getPercent() {
            return this.percent;
        }

        public Rect getCurrentWordRect() {
            return this.wordRect;
        }

        @Deprecated
        public int getBoundingBoxLeft() {
            return this.wordRect.left;
        }

        @Deprecated
        public int getBoundingBoxRight() {
            return this.wordRect.right;
        }

        @Deprecated
        public int getBoundingBoxTop() {
            return this.textRect.bottom - this.wordRect.top;
        }

        @Deprecated
        public int getBoundingBoxBottom() {
            return this.textRect.bottom - this.wordRect.bottom;
        }

        public Rect getCurrentRect() {
            return this.textRect;
        }
    }

    public static interface ProgressNotifier {
        public void onProgressValues(ProgressValues var1);
    }

    public static final class PageIteratorLevel {
        public static final int RIL_BLOCK = 0;
        public static final int RIL_PARA = 1;
        public static final int RIL_TEXTLINE = 2;
        public static final int RIL_WORD = 3;
        public static final int RIL_SYMBOL = 4;
    }

    public static final class PageSegMode {
        public static final int PSM_OSD_ONLY = 0;
        public static final int PSM_AUTO_OSD = 1;
        public static final int PSM_AUTO_ONLY = 2;
        public static final int PSM_AUTO = 3;
        public static final int PSM_SINGLE_COLUMN = 4;
        public static final int PSM_SINGLE_BLOCK_VERT_TEXT = 5;
        public static final int PSM_SINGLE_BLOCK = 6;
        public static final int PSM_SINGLE_LINE = 7;
        public static final int PSM_SINGLE_WORD = 8;
        public static final int PSM_CIRCLE_WORD = 9;
        public static final int PSM_SINGLE_CHAR = 10;
        public static final int PSM_SPARSE_TEXT = 11;
        public static final int PSM_SPARSE_TEXT_OSD = 12;
        public static final int PSM_COUNT = 13;
    }
}

