/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Bitmap;
import com.googlecode.leptonica.android.Convert;
import com.googlecode.leptonica.android.Pix;
import java.io.File;

public class WriteFile {
    public static byte[] writeBytes8(Pix pixs) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int size = pixs.getWidth() * pixs.getHeight();
        byte[] data = new byte[size];
        if (pixs.getDepth() != 8) {
            Pix pix8 = Convert.convertTo8(pixs);
            WriteFile.writeBytes8(pix8, data);
            pix8.recycle();
        } else {
            WriteFile.writeBytes8(pixs, data);
        }
        return data;
    }

    public static int writeBytes8(Pix pixs, byte[] data) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int size = pixs.getWidth() * pixs.getHeight();
        if (data.length < size) {
            throw new IllegalArgumentException("Data array must be large enough to hold image bytes");
        }
        return WriteFile.nativeWriteBytes8(pixs.getNativePix(), data);
    }

    public static boolean writeImpliedFormat(Pix pixs, File file) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File must be non-null");
        }
        return WriteFile.nativeWriteImpliedFormat(pixs.getNativePix(), file.getAbsolutePath());
    }

    public static Bitmap writeBitmap(Pix pixs) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        int[] dimensions = pixs.getDimensions();
        int width = dimensions[0];
        int height = dimensions[1];
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        if (WriteFile.nativeWriteBitmap(pixs.getNativePix(), bitmap)) {
            return bitmap;
        }
        bitmap.recycle();
        return null;
    }

    private static native int nativeWriteBytes8(long var0, byte[] var2);

    private static native boolean nativeWriteImpliedFormat(long var0, String var2);

    private static native boolean nativeWriteBitmap(long var0, Bitmap var2);

    static {
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
    }
}

