/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class MorphApp {
    public static final int L_TOPHAT_WHITE = 0;
    public static final int L_TOPHAT_BLACK = 1;
    public static final int DEFAULT_WIDTH = 7;
    public static final int DEFAULT_HEIGHT = 7;

    public static Pix pixTophat(Pix pixs, int hsize, int vsize, int type) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (pixs.getDepth() != 8) {
            throw new IllegalArgumentException("Source pix depth must be 8bpp");
        }
        if (hsize < 1 || vsize < 1) {
            throw new IllegalArgumentException("hsize or vsize < 1");
        }
        if (type < 0 || type > 1) {
            throw new IllegalArgumentException("Type must be L_TOPHAT_BLACK or L_TOPHAT_WHITE");
        }
        long nativePix = MorphApp.nativePixTophat(pixs.getNativePix(), hsize, vsize, type);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to perform Tophat on image");
        }
        return new Pix(nativePix);
    }

    public static Pix pixFastTophatBlack(Pix pixs) {
        return MorphApp.pixFastTophat(pixs, 7, 7, 1);
    }

    public static Pix pixFastTophatWhite(Pix pixs) {
        return MorphApp.pixFastTophat(pixs, 7, 7, 0);
    }

    public static Pix pixFastTophat(Pix pixs, int xsize, int ysize, int type) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        if (pixs.getDepth() != 8) {
            throw new IllegalArgumentException("Source pix depth must be 8bpp");
        }
        if (xsize < 1 || ysize < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        if (type < 0 || type > 1) {
            throw new IllegalArgumentException("Type must be L_TOPHAT_BLACK or L_TOPHAT_WHITE");
        }
        long nativePix = MorphApp.nativePixFastTophat(pixs.getNativePix(), xsize, ysize, type);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to perform pixFastTophat on image");
        }
        return new Pix(nativePix);
    }

    private static native long nativePixTophat(long var0, int var2, int var3, int var4);

    private static native long nativePixFastTophat(long var0, int var2, int var3, int var4);

    static {
        System.loadLibrary("pngt");
        System.loadLibrary("lept");
    }
}

