/*
 * Decompiled with CFR 0.152.
 */
package com.revosleap.mpesapush.mpesa;

import android.util.Base64;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/revosleap/mpesapush/mpesa/Utils;", "", "()V", "timestamp", "", "getTimestamp", "()Ljava/lang/String;", "getPassword", "businessShortCode", "passkey", "sanitizePhoneNumber", "phone", "mpesapush_release"})
public final class Utils {
    public static final Utils INSTANCE;

    @NotNull
    public final String getTimestamp() {
        String string = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SimpleDateFormat(\"yyyyMM\u2026Default()).format(Date())");
        return string;
    }

    @NotNull
    public final String sanitizePhoneNumber(@NotNull String phone) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)phone, (String)"phone");
        if (Intrinsics.areEqual((Object)phone, (Object)"")) {
            return "";
        }
        if (phone.length() < 11 & StringsKt.startsWith$default((String)phone, (String)"0", (boolean)false, (int)2, null)) {
            CharSequence charSequence = phone;
            String string2 = "^0";
            string2 = new Regex(string2);
            String string3 = "254";
            return string2.replaceFirst(charSequence, string3);
        }
        if (phone.length() == 13 && StringsKt.startsWith$default((String)phone, (String)"+", (boolean)false, (int)2, null)) {
            CharSequence charSequence = phone;
            String string4 = "^+";
            string4 = new Regex(string4);
            String string5 = "";
            string = string4.replaceFirst(charSequence, string5);
        } else {
            string = phone;
        }
        return string;
    }

    @NotNull
    public final String getPassword(@NotNull String businessShortCode, @NotNull String passkey, @NotNull String timestamp) {
        String str;
        Intrinsics.checkParameterIsNotNull((Object)businessShortCode, (String)"businessShortCode");
        Intrinsics.checkParameterIsNotNull((Object)passkey, (String)"passkey");
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        String string = str = businessShortCode + passkey + timestamp;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = Base64.encodeToString((byte[])byArray, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.encodeToString(st\u2026eArray(), Base64.NO_WRAP)");
        return string3;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

