/*
 * Decompiled with CFR 0.152.
 */
package com.revosleap.mpesapush.mpesa;

import android.util.Log;
import com.revosleap.mpesapush.models.TransactionDetails;
import com.revosleap.mpesapush.mpesa.AccessToken;
import com.revosleap.mpesapush.mpesa.ApiClient;
import com.revosleap.mpesapush.mpesa.STKPush;
import com.revosleap.mpesapush.mpesa.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006JF\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJV\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/revosleap/mpesapush/mpesa/MpesaPay;", "", "()V", "mApiClient", "Lcom/revosleap/mpesapush/mpesa/ApiClient;", "model", "Lcom/revosleap/mpesapush/models/TransactionDetails;", "getAccessToken", "", "transactionDetails", "getAccessToken$mpesapush_release", "performSTKPush", "performSTKPush$mpesapush_release", "sendPush", "phoneNumber", "", "cash", "payBill", "partyB", "accReference", "transDesc", "passKey", "callbackUrl", "partyA", "transactionType", "mpesapush_release"})
public final class MpesaPay {
    private static ApiClient mApiClient;
    private static TransactionDetails model;
    public static final MpesaPay INSTANCE;

    public final void sendPush(@NotNull String phoneNumber, @NotNull String cash, @NotNull String payBill, @NotNull String partyA, @NotNull String partyB, @NotNull String accReference, @NotNull String transDesc, @NotNull String transactionType, @NotNull String passKey, @NotNull String callbackUrl) {
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        Intrinsics.checkParameterIsNotNull((Object)cash, (String)"cash");
        Intrinsics.checkParameterIsNotNull((Object)payBill, (String)"payBill");
        Intrinsics.checkParameterIsNotNull((Object)partyA, (String)"partyA");
        Intrinsics.checkParameterIsNotNull((Object)partyB, (String)"partyB");
        Intrinsics.checkParameterIsNotNull((Object)accReference, (String)"accReference");
        Intrinsics.checkParameterIsNotNull((Object)transDesc, (String)"transDesc");
        Intrinsics.checkParameterIsNotNull((Object)transactionType, (String)"transactionType");
        Intrinsics.checkParameterIsNotNull((Object)passKey, (String)"passKey");
        Intrinsics.checkParameterIsNotNull((Object)callbackUrl, (String)"callbackUrl");
        model.setPhoneNumber(phoneNumber);
        model.setPayBill(payBill);
        model.setPartyB(partyB);
        model.setAccReference(accReference);
        model.setDescription(transDesc);
        model.setType(transactionType);
        model.setCashAmount(cash);
        model.setPartyA(partyA);
        model.setPassKey(passKey);
        model.setCallBackUrl(callbackUrl);
        this.getAccessToken$mpesapush_release(model);
    }

    public final void sendPush(@NotNull TransactionDetails transactionDetails) {
        Intrinsics.checkParameterIsNotNull((Object)transactionDetails, (String)"transactionDetails");
        this.getAccessToken$mpesapush_release(transactionDetails);
    }

    public final void sendPush(@NotNull String phoneNumber, @NotNull String cash, @NotNull String payBill, @NotNull String partyB, @NotNull String accReference, @NotNull String transDesc, @NotNull String passKey, @NotNull String callbackUrl) {
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        Intrinsics.checkParameterIsNotNull((Object)cash, (String)"cash");
        Intrinsics.checkParameterIsNotNull((Object)payBill, (String)"payBill");
        Intrinsics.checkParameterIsNotNull((Object)partyB, (String)"partyB");
        Intrinsics.checkParameterIsNotNull((Object)accReference, (String)"accReference");
        Intrinsics.checkParameterIsNotNull((Object)transDesc, (String)"transDesc");
        Intrinsics.checkParameterIsNotNull((Object)passKey, (String)"passKey");
        Intrinsics.checkParameterIsNotNull((Object)callbackUrl, (String)"callbackUrl");
        this.sendPush(phoneNumber, cash, payBill, partyB, partyB, accReference, transDesc, "CustomerPayBillOnline", passKey, callbackUrl);
    }

    public final void performSTKPush$mpesapush_release(@NotNull TransactionDetails transactionDetails) {
        Intrinsics.checkParameterIsNotNull((Object)transactionDetails, (String)"transactionDetails");
        String timestamp = Utils.INSTANCE.getTimestamp();
        String string = transactionDetails.getPayBill();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = transactionDetails.getPayBill();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        String string3 = transactionDetails.getPassKey();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        String string4 = Utils.INSTANCE.getPassword(string2, string3, timestamp);
        String string5 = transactionDetails.getType();
        if (string5 == null) {
            Intrinsics.throwNpe();
        }
        String string6 = transactionDetails.getCashAmount();
        if (string6 == null) {
            Intrinsics.throwNpe();
        }
        String string7 = transactionDetails.getPhoneNumber();
        if (string7 == null) {
            Intrinsics.throwNpe();
        }
        String string8 = Utils.INSTANCE.sanitizePhoneNumber(string7);
        String string9 = transactionDetails.getPartyB();
        if (string9 == null) {
            Intrinsics.throwNpe();
        }
        String string10 = transactionDetails.getPhoneNumber();
        if (string10 == null) {
            Intrinsics.throwNpe();
        }
        String string11 = Utils.INSTANCE.sanitizePhoneNumber(string10);
        String string12 = transactionDetails.getCallBackUrl();
        if (string12 == null) {
            Intrinsics.throwNpe();
        }
        String string13 = transactionDetails.getAccReference();
        if (string13 == null) {
            Intrinsics.throwNpe();
        }
        String string14 = transactionDetails.getDescription();
        if (string14 == null) {
            Intrinsics.throwNpe();
        }
        STKPush stkPush = new STKPush(string, string4, timestamp, string5, string6, string8, string9, string11, string12, string13, string14);
        mApiClient.setGetAccessToken(false);
        mApiClient.mpesaService().sendPush(stkPush).enqueue((Callback)new Callback<STKPush>(){

            public void onResponse(@NotNull Call<STKPush> call, @NotNull Response<STKPush> response) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                try {
                    if (response.isSuccessful()) {
                        Log.v((String)"Resp", (String)String.valueOf(response.body()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onFailure(@NotNull Call<STKPush> call, @NotNull Throwable t) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            }
        });
    }

    public final void getAccessToken$mpesapush_release(@NotNull TransactionDetails transactionDetails) {
        Intrinsics.checkParameterIsNotNull((Object)transactionDetails, (String)"transactionDetails");
        mApiClient.setGetAccessToken(true);
        mApiClient.mpesaService().accessToken().enqueue((Callback)new Callback<AccessToken>(transactionDetails){
            final /* synthetic */ TransactionDetails $transactionDetails;

            public void onResponse(@NotNull Call<AccessToken> call, @NotNull Response<AccessToken> response) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                if (response.isSuccessful()) {
                    ApiClient apiClient = MpesaPay.access$getMApiClient$p(MpesaPay.INSTANCE);
                    Object object = response.body();
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    apiClient.setAuthToken(((AccessToken)object).getAccessToken());
                    MpesaPay.INSTANCE.performSTKPush$mpesapush_release(this.$transactionDetails);
                    Log.v((String)"Resp", (String)String.valueOf(response.body()));
                } else {
                    Log.v((String)"Resp", (String)String.valueOf(response.body()));
                }
            }

            public void onFailure(@NotNull Call<AccessToken> call, @NotNull Throwable t) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                t.printStackTrace();
            }
            {
                this.$transactionDetails = $captured_local_variable$0;
            }
        });
    }

    private MpesaPay() {
    }

    static {
        MpesaPay mpesaPay;
        INSTANCE = mpesaPay = new MpesaPay();
        mApiClient = new ApiClient();
        model = new TransactionDetails();
    }

    @NotNull
    public static final /* synthetic */ ApiClient access$getMApiClient$p(MpesaPay $this) {
        MpesaPay mpesaPay = $this;
        return mApiClient;
    }

    public static final /* synthetic */ void access$setMApiClient$p(MpesaPay $this, @NotNull ApiClient apiClient) {
        MpesaPay mpesaPay = $this;
        mApiClient = apiClient;
    }
}

