/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val;

import com.reprezen.kaizen.oasparser.val.ValidationResults;
import com.reprezen.kaizen.oasparser.val.VisitedObjectRegistry;

public class ValidationContext
implements AutoCloseable {
    static ThreadLocal<ValidationContext> threadInstance = new ThreadLocal();
    private ValidationResults validationResults;
    private VisitedObjectRegistry visitedObjectRegistry;

    public ValidationContext() {
        ValidationContext context = threadInstance.get();
        if (context != null) {
            throw new IllegalStateException();
        }
        this.validationResults = new ValidationResults();
        this.visitedObjectRegistry = new VisitedObjectRegistry();
        threadInstance.set(this);
    }

    public static ValidationContext open() {
        return new ValidationContext();
    }

    public static ValidationContext get() {
        return threadInstance.get();
    }

    public static ValidationResults getValidationResults() {
        ValidationContext context = ValidationContext.get();
        if (context != null) {
            return context.validationResults;
        }
        throw new IllegalStateException();
    }

    public static boolean visitIfUnvisited(Object o) {
        ValidationContext context = ValidationContext.get();
        if (context != null) {
            return context.visitedObjectRegistry.visitIfUnvisited(o);
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() {
        threadInstance.remove();
        if (threadInstance.get() != null) {
            throw new IllegalStateException();
        }
    }
}

