/*
 * Decompiled with CFR 0.152.
 */
package com.rengwuxian.materialedittext;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.nineoldandroids.animation.ArgbEvaluator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.rengwuxian.materialedittext.Colors;
import com.rengwuxian.materialedittext.Density;
import com.rengwuxian.materialedittext.R;
import com.rengwuxian.materialedittext.validation.METLengthChecker;
import com.rengwuxian.materialedittext.validation.METValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MaterialEditText
extends AppCompatEditText {
    public static final int FLOATING_LABEL_NONE = 0;
    public static final int FLOATING_LABEL_NORMAL = 1;
    public static final int FLOATING_LABEL_HIGHLIGHT = 2;
    private int extraPaddingTop;
    private int extraPaddingBottom;
    private int extraPaddingLeft;
    private int extraPaddingRight;
    private int floatingLabelTextSize;
    private int floatingLabelTextColor;
    private int bottomTextSize;
    private int floatingLabelPadding;
    private int bottomSpacing;
    private boolean floatingLabelEnabled;
    private boolean highlightFloatingLabel;
    private int baseColor;
    private int innerPaddingTop;
    private int innerPaddingBottom;
    private int innerPaddingLeft;
    private int innerPaddingRight;
    private int primaryColor;
    private int errorColor;
    private int minCharacters;
    private int maxCharacters;
    private boolean singleLineEllipsis;
    private boolean floatingLabelAlwaysShown;
    private boolean helperTextAlwaysShown;
    private int bottomEllipsisSize;
    private int minBottomLines;
    private int minBottomTextLines;
    private float currentBottomLines;
    private float bottomLines;
    private String helperText;
    private int helperTextColor = -1;
    private String tempErrorText;
    private float floatingLabelFraction;
    private boolean floatingLabelShown;
    private float focusFraction;
    private Typeface accentTypeface;
    private Typeface typeface;
    private CharSequence floatingLabelText;
    private boolean hideUnderline;
    private int underlineColor;
    private boolean autoValidate;
    private boolean charactersCountValid;
    private boolean floatingLabelAnimating;
    private boolean checkCharactersCountAtBeginning;
    private Bitmap[] iconLeftBitmaps;
    private Bitmap[] iconRightBitmaps;
    private Bitmap[] clearButtonBitmaps;
    private boolean validateOnFocusLost;
    private boolean showClearButton;
    private boolean firstShown;
    private int iconSize;
    private int iconOuterWidth;
    private int iconOuterHeight;
    private int iconPadding;
    private boolean clearButtonTouched;
    private boolean clearButtonClicking;
    private ColorStateList textColorStateList;
    private ColorStateList textColorHintStateList;
    private ArgbEvaluator focusEvaluator = new ArgbEvaluator();
    Paint paint = new Paint(1);
    TextPaint textPaint = new TextPaint(1);
    StaticLayout textLayout;
    ObjectAnimator labelAnimator;
    ObjectAnimator labelFocusAnimator;
    ObjectAnimator bottomLinesAnimator;
    View.OnFocusChangeListener innerFocusChangeListener;
    View.OnFocusChangeListener outerFocusChangeListener;
    private List<METValidator> validators;
    private METLengthChecker lengthChecker;

    public MaterialEditText(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaterialEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialEditText(Context context, AttributeSet attrs, int style) {
        super(context, attrs, style);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        String fontPathForView;
        int defaultPrimaryColor;
        this.iconSize = this.getPixel(32);
        this.iconOuterWidth = this.getPixel(48);
        this.iconOuterHeight = this.getPixel(32);
        this.bottomSpacing = this.getResources().getDimensionPixelSize(R.dimen.inner_components_spacing);
        this.bottomEllipsisSize = this.getResources().getDimensionPixelSize(R.dimen.bottom_ellipsis_height);
        int defaultBaseColor = -16777216;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaterialEditText);
        this.textColorStateList = typedArray.getColorStateList(R.styleable.MaterialEditText_met_textColor);
        this.textColorHintStateList = typedArray.getColorStateList(R.styleable.MaterialEditText_met_textColorHint);
        this.baseColor = typedArray.getColor(R.styleable.MaterialEditText_met_baseColor, defaultBaseColor);
        TypedValue primaryColorTypedValue = new TypedValue();
        try {
            if (Build.VERSION.SDK_INT < 21) {
                throw new RuntimeException("SDK_INT less than LOLLIPOP");
            }
            context.getTheme().resolveAttribute(16843827, primaryColorTypedValue, true);
            defaultPrimaryColor = primaryColorTypedValue.data;
        }
        catch (Exception e) {
            try {
                int colorPrimaryId = this.getResources().getIdentifier("colorPrimary", "attr", this.getContext().getPackageName());
                if (colorPrimaryId == 0) {
                    throw new RuntimeException("colorPrimary not found");
                }
                context.getTheme().resolveAttribute(colorPrimaryId, primaryColorTypedValue, true);
                defaultPrimaryColor = primaryColorTypedValue.data;
            }
            catch (Exception e1) {
                defaultPrimaryColor = this.baseColor;
            }
        }
        this.primaryColor = typedArray.getColor(R.styleable.MaterialEditText_met_primaryColor, defaultPrimaryColor);
        this.setFloatingLabelInternal(typedArray.getInt(R.styleable.MaterialEditText_met_floatingLabel, 0));
        this.errorColor = typedArray.getColor(R.styleable.MaterialEditText_met_errorColor, Color.parseColor((String)"#e7492E"));
        this.minCharacters = typedArray.getInt(R.styleable.MaterialEditText_met_minCharacters, 0);
        this.maxCharacters = typedArray.getInt(R.styleable.MaterialEditText_met_maxCharacters, 0);
        this.singleLineEllipsis = typedArray.getBoolean(R.styleable.MaterialEditText_met_singleLineEllipsis, false);
        this.helperText = typedArray.getString(R.styleable.MaterialEditText_met_helperText);
        this.helperTextColor = typedArray.getColor(R.styleable.MaterialEditText_met_helperTextColor, -1);
        this.minBottomTextLines = typedArray.getInt(R.styleable.MaterialEditText_met_minBottomTextLines, 0);
        String fontPathForAccent = typedArray.getString(R.styleable.MaterialEditText_met_accentTypeface);
        if (fontPathForAccent != null && !this.isInEditMode()) {
            this.accentTypeface = this.getCustomTypeface(fontPathForAccent);
            this.textPaint.setTypeface(this.accentTypeface);
        }
        if ((fontPathForView = typedArray.getString(R.styleable.MaterialEditText_met_typeface)) != null && !this.isInEditMode()) {
            this.typeface = this.getCustomTypeface(fontPathForView);
            this.setTypeface(this.typeface);
        }
        this.floatingLabelText = typedArray.getString(R.styleable.MaterialEditText_met_floatingLabelText);
        if (this.floatingLabelText == null) {
            this.floatingLabelText = this.getHint();
        }
        this.floatingLabelPadding = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_floatingLabelPadding, this.bottomSpacing);
        this.floatingLabelTextSize = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_floatingLabelTextSize, this.getResources().getDimensionPixelSize(R.dimen.floating_label_text_size));
        this.floatingLabelTextColor = typedArray.getColor(R.styleable.MaterialEditText_met_floatingLabelTextColor, -1);
        this.floatingLabelAnimating = typedArray.getBoolean(R.styleable.MaterialEditText_met_floatingLabelAnimating, true);
        this.bottomTextSize = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_bottomTextSize, this.getResources().getDimensionPixelSize(R.dimen.bottom_text_size));
        this.hideUnderline = typedArray.getBoolean(R.styleable.MaterialEditText_met_hideUnderline, false);
        this.underlineColor = typedArray.getColor(R.styleable.MaterialEditText_met_underlineColor, -1);
        this.autoValidate = typedArray.getBoolean(R.styleable.MaterialEditText_met_autoValidate, false);
        this.iconLeftBitmaps = this.generateIconBitmaps(typedArray.getResourceId(R.styleable.MaterialEditText_met_iconLeft, -1));
        this.iconRightBitmaps = this.generateIconBitmaps(typedArray.getResourceId(R.styleable.MaterialEditText_met_iconRight, -1));
        this.showClearButton = typedArray.getBoolean(R.styleable.MaterialEditText_met_clearButton, false);
        this.clearButtonBitmaps = this.generateIconBitmaps(R.drawable.met_ic_clear);
        this.iconPadding = typedArray.getDimensionPixelSize(R.styleable.MaterialEditText_met_iconPadding, this.getPixel(16));
        this.floatingLabelAlwaysShown = typedArray.getBoolean(R.styleable.MaterialEditText_met_floatingLabelAlwaysShown, false);
        this.helperTextAlwaysShown = typedArray.getBoolean(R.styleable.MaterialEditText_met_helperTextAlwaysShown, false);
        this.validateOnFocusLost = typedArray.getBoolean(R.styleable.MaterialEditText_met_validateOnFocusLost, false);
        this.checkCharactersCountAtBeginning = typedArray.getBoolean(R.styleable.MaterialEditText_met_checkCharactersCountAtBeginning, true);
        typedArray.recycle();
        int[] paddings = new int[]{16842965, 16842966, 16842967, 16842968, 16842969};
        TypedArray paddingsTypedArray = context.obtainStyledAttributes(attrs, paddings);
        int padding = paddingsTypedArray.getDimensionPixelSize(0, 0);
        this.innerPaddingLeft = paddingsTypedArray.getDimensionPixelSize(1, padding);
        this.innerPaddingTop = paddingsTypedArray.getDimensionPixelSize(2, padding);
        this.innerPaddingRight = paddingsTypedArray.getDimensionPixelSize(3, padding);
        this.innerPaddingBottom = paddingsTypedArray.getDimensionPixelSize(4, padding);
        paddingsTypedArray.recycle();
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
        } else {
            this.setBackgroundDrawable(null);
        }
        if (this.singleLineEllipsis) {
            TransformationMethod transformationMethod = this.getTransformationMethod();
            this.setSingleLine();
            this.setTransformationMethod(transformationMethod);
        }
        this.initMinBottomLines();
        this.initPadding();
        this.initText();
        this.initFloatingLabel();
        this.initTextWatcher();
        this.checkCharactersCount();
    }

    private void initText() {
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            Editable text = this.getText();
            this.setText(null);
            this.resetHintTextColor();
            this.setText((CharSequence)text);
            this.setSelection(text.length());
            this.floatingLabelFraction = 1.0f;
            this.floatingLabelShown = true;
        } else {
            this.resetHintTextColor();
        }
        this.resetTextColor();
    }

    private void initTextWatcher() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                MaterialEditText.this.checkCharactersCount();
                if (MaterialEditText.this.autoValidate) {
                    MaterialEditText.this.validate();
                } else {
                    MaterialEditText.this.setError(null);
                }
                MaterialEditText.this.postInvalidate();
            }
        });
    }

    private Typeface getCustomTypeface(@NonNull String fontPath) {
        return Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)fontPath);
    }

    public void setIconLeft(int res) {
        this.iconLeftBitmaps = this.generateIconBitmaps(res);
        this.initPadding();
    }

    public void setIconLeft(Drawable drawable2) {
        this.iconLeftBitmaps = this.generateIconBitmaps(drawable2);
        this.initPadding();
    }

    public void setIconLeft(Bitmap bitmap) {
        this.iconLeftBitmaps = this.generateIconBitmaps(bitmap);
        this.initPadding();
    }

    public void setIconRight(int res) {
        this.iconRightBitmaps = this.generateIconBitmaps(res);
        this.initPadding();
    }

    public void setIconRight(Drawable drawable2) {
        this.iconRightBitmaps = this.generateIconBitmaps(drawable2);
        this.initPadding();
    }

    public void setIconRight(Bitmap bitmap) {
        this.iconRightBitmaps = this.generateIconBitmaps(bitmap);
        this.initPadding();
    }

    public boolean isShowClearButton() {
        return this.showClearButton;
    }

    public void setShowClearButton(boolean show) {
        this.showClearButton = show;
        this.correctPaddings();
    }

    private Bitmap[] generateIconBitmaps(int origin) {
        if (origin == -1) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)this.getResources(), (int)origin, (BitmapFactory.Options)options);
        int size = Math.max(options.outWidth, options.outHeight);
        options.inSampleSize = size > this.iconSize ? size / this.iconSize : 1;
        options.inJustDecodeBounds = false;
        return this.generateIconBitmaps(BitmapFactory.decodeResource((Resources)this.getResources(), (int)origin, (BitmapFactory.Options)options));
    }

    private Bitmap[] generateIconBitmaps(Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return this.generateIconBitmaps(Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.iconSize, (int)this.iconSize, (boolean)false));
    }

    private Bitmap[] generateIconBitmaps(Bitmap origin) {
        if (origin == null) {
            return null;
        }
        Bitmap[] iconBitmaps = new Bitmap[4];
        origin = this.scaleIcon(origin);
        iconBitmaps[0] = origin.copy(Bitmap.Config.ARGB_8888, true);
        Canvas canvas = new Canvas(iconBitmaps[0]);
        canvas.drawColor(this.baseColor & 0xFFFFFF | (Colors.isLight(this.baseColor) ? -16777216 : -1979711488), PorterDuff.Mode.SRC_IN);
        iconBitmaps[1] = origin.copy(Bitmap.Config.ARGB_8888, true);
        canvas = new Canvas(iconBitmaps[1]);
        canvas.drawColor(this.primaryColor, PorterDuff.Mode.SRC_IN);
        iconBitmaps[2] = origin.copy(Bitmap.Config.ARGB_8888, true);
        canvas = new Canvas(iconBitmaps[2]);
        canvas.drawColor(this.baseColor & 0xFFFFFF | (Colors.isLight(this.baseColor) ? 0x4C000000 : 0x42000000), PorterDuff.Mode.SRC_IN);
        iconBitmaps[3] = origin.copy(Bitmap.Config.ARGB_8888, true);
        canvas = new Canvas(iconBitmaps[3]);
        canvas.drawColor(this.errorColor, PorterDuff.Mode.SRC_IN);
        return iconBitmaps;
    }

    private Bitmap scaleIcon(Bitmap origin) {
        int height;
        int width = origin.getWidth();
        int size = Math.max(width, height = origin.getHeight());
        if (size == this.iconSize) {
            return origin;
        }
        if (size > this.iconSize) {
            int scaledHeight;
            int scaledWidth;
            if (width > this.iconSize) {
                scaledWidth = this.iconSize;
                scaledHeight = (int)((float)this.iconSize * ((float)height / (float)width));
            } else {
                scaledHeight = this.iconSize;
                scaledWidth = (int)((float)this.iconSize * ((float)width / (float)height));
            }
            return Bitmap.createScaledBitmap((Bitmap)origin, (int)scaledWidth, (int)scaledHeight, (boolean)false);
        }
        return origin;
    }

    public float getFloatingLabelFraction() {
        return this.floatingLabelFraction;
    }

    public void setFloatingLabelFraction(float floatingLabelFraction) {
        this.floatingLabelFraction = floatingLabelFraction;
        this.invalidate();
    }

    public float getFocusFraction() {
        return this.focusFraction;
    }

    public void setFocusFraction(float focusFraction) {
        this.focusFraction = focusFraction;
        this.invalidate();
    }

    public float getCurrentBottomLines() {
        return this.currentBottomLines;
    }

    public void setCurrentBottomLines(float currentBottomLines) {
        this.currentBottomLines = currentBottomLines;
        this.initPadding();
    }

    public boolean isFloatingLabelAlwaysShown() {
        return this.floatingLabelAlwaysShown;
    }

    public void setFloatingLabelAlwaysShown(boolean floatingLabelAlwaysShown) {
        this.floatingLabelAlwaysShown = floatingLabelAlwaysShown;
        this.invalidate();
    }

    public boolean isHelperTextAlwaysShown() {
        return this.helperTextAlwaysShown;
    }

    public void setHelperTextAlwaysShown(boolean helperTextAlwaysShown) {
        this.helperTextAlwaysShown = helperTextAlwaysShown;
        this.invalidate();
    }

    @Nullable
    public Typeface getAccentTypeface() {
        return this.accentTypeface;
    }

    public void setAccentTypeface(Typeface accentTypeface) {
        this.accentTypeface = accentTypeface;
        this.textPaint.setTypeface(accentTypeface);
        this.postInvalidate();
    }

    public boolean isHideUnderline() {
        return this.hideUnderline;
    }

    public void setHideUnderline(boolean hideUnderline) {
        this.hideUnderline = hideUnderline;
        this.initPadding();
        this.postInvalidate();
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public void setUnderlineColor(int color) {
        this.underlineColor = color;
        this.postInvalidate();
    }

    public CharSequence getFloatingLabelText() {
        return this.floatingLabelText;
    }

    public void setFloatingLabelText(@Nullable CharSequence floatingLabelText) {
        this.floatingLabelText = floatingLabelText == null ? this.getHint() : floatingLabelText;
        this.postInvalidate();
    }

    public int getFloatingLabelTextSize() {
        return this.floatingLabelTextSize;
    }

    public void setFloatingLabelTextSize(int size) {
        this.floatingLabelTextSize = size;
        this.initPadding();
    }

    public int getFloatingLabelTextColor() {
        return this.floatingLabelTextColor;
    }

    public void setFloatingLabelTextColor(int color) {
        this.floatingLabelTextColor = color;
        this.postInvalidate();
    }

    public int getBottomTextSize() {
        return this.bottomTextSize;
    }

    public void setBottomTextSize(int size) {
        this.bottomTextSize = size;
        this.initPadding();
    }

    private int getPixel(int dp) {
        return Density.dp2px(this.getContext(), dp);
    }

    private void initPadding() {
        this.extraPaddingTop = this.floatingLabelEnabled ? this.floatingLabelTextSize + this.floatingLabelPadding : this.floatingLabelPadding;
        this.textPaint.setTextSize((float)this.bottomTextSize);
        Paint.FontMetrics textMetrics = this.textPaint.getFontMetrics();
        this.extraPaddingBottom = (int)((textMetrics.descent - textMetrics.ascent) * this.currentBottomLines) + (this.hideUnderline ? this.bottomSpacing : this.bottomSpacing * 2);
        this.extraPaddingLeft = this.iconLeftBitmaps == null ? 0 : this.iconOuterWidth + this.iconPadding;
        this.extraPaddingRight = this.iconRightBitmaps == null ? 0 : this.iconOuterWidth + this.iconPadding;
        this.correctPaddings();
    }

    private void initMinBottomLines() {
        boolean extendBottom;
        boolean bl = extendBottom = this.minCharacters > 0 || this.maxCharacters > 0 || this.singleLineEllipsis || this.tempErrorText != null || this.helperText != null;
        this.minBottomLines = this.minBottomTextLines > 0 ? this.minBottomTextLines : (extendBottom ? 1 : 0);
        this.currentBottomLines = this.minBottomLines;
    }

    @Deprecated
    public final void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
    }

    public void setPaddings(int left, int top, int right, int bottom) {
        this.innerPaddingTop = top;
        this.innerPaddingBottom = bottom;
        this.innerPaddingLeft = left;
        this.innerPaddingRight = right;
        this.correctPaddings();
    }

    private void correctPaddings() {
        int buttonsWidthLeft = 0;
        int buttonsWidthRight = 0;
        int buttonsWidth = this.iconOuterWidth * this.getButtonsCount();
        if (this.isRTL()) {
            buttonsWidthLeft = buttonsWidth;
        } else {
            buttonsWidthRight = buttonsWidth;
        }
        super.setPadding(this.innerPaddingLeft + this.extraPaddingLeft + buttonsWidthLeft, this.innerPaddingTop + this.extraPaddingTop, this.innerPaddingRight + this.extraPaddingRight + buttonsWidthRight, this.innerPaddingBottom + this.extraPaddingBottom);
    }

    private int getButtonsCount() {
        return this.isShowClearButton() ? 1 : 0;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.firstShown) {
            this.firstShown = true;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.adjustBottomLines();
        }
    }

    private boolean adjustBottomLines() {
        int destBottomLines;
        if (this.getWidth() == 0) {
            return false;
        }
        this.textPaint.setTextSize((float)this.bottomTextSize);
        if (this.tempErrorText != null || this.helperText != null) {
            Layout.Alignment alignment = (this.getGravity() & 5) == 5 || this.isRTL() ? Layout.Alignment.ALIGN_OPPOSITE : ((this.getGravity() & 3) == 3 ? Layout.Alignment.ALIGN_NORMAL : Layout.Alignment.ALIGN_CENTER);
            this.textLayout = new StaticLayout((CharSequence)(this.tempErrorText != null ? this.tempErrorText : this.helperText), this.textPaint, this.getWidth() - this.getBottomTextLeftOffset() - this.getBottomTextRightOffset() - this.getPaddingLeft() - this.getPaddingRight(), alignment, 1.0f, 0.0f, true);
            destBottomLines = Math.max(this.textLayout.getLineCount(), this.minBottomTextLines);
        } else {
            destBottomLines = this.minBottomLines;
        }
        if (this.bottomLines != (float)destBottomLines) {
            this.getBottomLinesAnimator(destBottomLines).start();
        }
        this.bottomLines = destBottomLines;
        return true;
    }

    public int getInnerPaddingTop() {
        return this.innerPaddingTop;
    }

    public int getInnerPaddingBottom() {
        return this.innerPaddingBottom;
    }

    public int getInnerPaddingLeft() {
        return this.innerPaddingLeft;
    }

    public int getInnerPaddingRight() {
        return this.innerPaddingRight;
    }

    private void initFloatingLabel() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (MaterialEditText.this.floatingLabelEnabled) {
                    if (s.length() == 0) {
                        if (MaterialEditText.this.floatingLabelShown) {
                            MaterialEditText.this.floatingLabelShown = false;
                            MaterialEditText.this.getLabelAnimator().reverse();
                        }
                    } else if (!MaterialEditText.this.floatingLabelShown) {
                        MaterialEditText.this.floatingLabelShown = true;
                        MaterialEditText.this.getLabelAnimator().start();
                    }
                }
            }
        });
        this.innerFocusChangeListener = new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (MaterialEditText.this.floatingLabelEnabled && MaterialEditText.this.highlightFloatingLabel) {
                    if (hasFocus) {
                        MaterialEditText.this.getLabelFocusAnimator().start();
                    } else {
                        MaterialEditText.this.getLabelFocusAnimator().reverse();
                    }
                }
                if (MaterialEditText.this.validateOnFocusLost && !hasFocus) {
                    MaterialEditText.this.validate();
                }
                if (MaterialEditText.this.outerFocusChangeListener != null) {
                    MaterialEditText.this.outerFocusChangeListener.onFocusChange(v, hasFocus);
                }
            }
        };
        super.setOnFocusChangeListener(this.innerFocusChangeListener);
    }

    public boolean isValidateOnFocusLost() {
        return this.validateOnFocusLost;
    }

    public void setValidateOnFocusLost(boolean validate) {
        this.validateOnFocusLost = validate;
    }

    public void setBaseColor(int color) {
        if (this.baseColor != color) {
            this.baseColor = color;
        }
        this.initText();
        this.postInvalidate();
    }

    public void setPrimaryColor(int color) {
        this.primaryColor = color;
        this.postInvalidate();
    }

    public void setMetTextColor(int color) {
        this.textColorStateList = ColorStateList.valueOf((int)color);
        this.resetTextColor();
    }

    public void setMetTextColor(ColorStateList colors) {
        this.textColorStateList = colors;
        this.resetTextColor();
    }

    private void resetTextColor() {
        if (this.textColorStateList == null) {
            this.textColorStateList = new ColorStateList((int[][])new int[][]{{16842910}, EMPTY_STATE_SET}, new int[]{this.baseColor & 0xFFFFFF | 0xDF000000, this.baseColor & 0xFFFFFF | 0x44000000});
            this.setTextColor(this.textColorStateList);
        } else {
            this.setTextColor(this.textColorStateList);
        }
    }

    public void setMetHintTextColor(int color) {
        this.textColorHintStateList = ColorStateList.valueOf((int)color);
        this.resetHintTextColor();
    }

    public void setMetHintTextColor(ColorStateList colors) {
        this.textColorHintStateList = colors;
        this.resetHintTextColor();
    }

    private void resetHintTextColor() {
        if (this.textColorHintStateList == null) {
            this.setHintTextColor(this.baseColor & 0xFFFFFF | 0x44000000);
        } else {
            this.setHintTextColor(this.textColorHintStateList);
        }
    }

    private void setFloatingLabelInternal(int mode) {
        switch (mode) {
            case 1: {
                this.floatingLabelEnabled = true;
                this.highlightFloatingLabel = false;
                break;
            }
            case 2: {
                this.floatingLabelEnabled = true;
                this.highlightFloatingLabel = true;
                break;
            }
            default: {
                this.floatingLabelEnabled = false;
                this.highlightFloatingLabel = false;
            }
        }
    }

    public void setFloatingLabel(@FloatingLabelType int mode) {
        this.setFloatingLabelInternal(mode);
        this.initPadding();
    }

    public int getFloatingLabelPadding() {
        return this.floatingLabelPadding;
    }

    public void setFloatingLabelPadding(int padding) {
        this.floatingLabelPadding = padding;
        this.postInvalidate();
    }

    public boolean isFloatingLabelAnimating() {
        return this.floatingLabelAnimating;
    }

    public void setFloatingLabelAnimating(boolean animating) {
        this.floatingLabelAnimating = animating;
    }

    public void setSingleLineEllipsis() {
        this.setSingleLineEllipsis(true);
    }

    public void setSingleLineEllipsis(boolean enabled) {
        this.singleLineEllipsis = enabled;
        this.initMinBottomLines();
        this.initPadding();
        this.postInvalidate();
    }

    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    public void setMaxCharacters(int max) {
        this.maxCharacters = max;
        this.initMinBottomLines();
        this.initPadding();
        this.postInvalidate();
    }

    public int getMinCharacters() {
        return this.minCharacters;
    }

    public void setMinCharacters(int min) {
        this.minCharacters = min;
        this.initMinBottomLines();
        this.initPadding();
        this.postInvalidate();
    }

    public int getMinBottomTextLines() {
        return this.minBottomTextLines;
    }

    public void setMinBottomTextLines(int lines) {
        this.minBottomTextLines = lines;
        this.initMinBottomLines();
        this.initPadding();
        this.postInvalidate();
    }

    public boolean isAutoValidate() {
        return this.autoValidate;
    }

    public void setAutoValidate(boolean autoValidate) {
        this.autoValidate = autoValidate;
        if (autoValidate) {
            this.validate();
        }
    }

    public int getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(int color) {
        this.errorColor = color;
        this.postInvalidate();
    }

    public void setHelperText(CharSequence helperText) {
        String string = this.helperText = helperText == null ? null : helperText.toString();
        if (this.adjustBottomLines()) {
            this.postInvalidate();
        }
    }

    public String getHelperText() {
        return this.helperText;
    }

    public int getHelperTextColor() {
        return this.helperTextColor;
    }

    public void setHelperTextColor(int color) {
        this.helperTextColor = color;
        this.postInvalidate();
    }

    public void setError(CharSequence errorText) {
        String string = this.tempErrorText = errorText == null ? null : errorText.toString();
        if (this.adjustBottomLines()) {
            this.postInvalidate();
        }
    }

    public CharSequence getError() {
        return this.tempErrorText;
    }

    private boolean isInternalValid() {
        return this.tempErrorText == null && this.isCharactersCountValid();
    }

    @Deprecated
    public boolean isValid(String regex) {
        if (regex == null) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher((CharSequence)this.getText());
        return matcher.matches();
    }

    @Deprecated
    public boolean validate(String regex, CharSequence errorText) {
        boolean isValid = this.isValid(regex);
        if (!isValid) {
            this.setError(errorText);
        }
        this.postInvalidate();
        return isValid;
    }

    public boolean validateWith(@NonNull METValidator validator) {
        Editable text;
        boolean isValid = validator.isValid((CharSequence)text, (text = this.getText()).length() == 0);
        if (!isValid) {
            this.setError(validator.getErrorMessage());
        }
        this.postInvalidate();
        return isValid;
    }

    public boolean validate() {
        if (this.validators == null || this.validators.isEmpty()) {
            return true;
        }
        Editable text = this.getText();
        boolean isEmpty = text.length() == 0;
        boolean isValid = true;
        for (METValidator validator : this.validators) {
            if (isValid = isValid && validator.isValid((CharSequence)text, isEmpty)) continue;
            this.setError(validator.getErrorMessage());
            break;
        }
        if (isValid) {
            this.setError(null);
        }
        this.postInvalidate();
        return isValid;
    }

    public boolean hasValidators() {
        return this.validators != null && !this.validators.isEmpty();
    }

    public MaterialEditText addValidator(METValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<METValidator>();
        }
        this.validators.add(validator);
        return this;
    }

    public void clearValidators() {
        if (this.validators != null) {
            this.validators.clear();
        }
    }

    @Nullable
    public List<METValidator> getValidators() {
        return this.validators;
    }

    public void setLengthChecker(METLengthChecker lengthChecker) {
        this.lengthChecker = lengthChecker;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener listener) {
        if (this.innerFocusChangeListener == null) {
            super.setOnFocusChangeListener(listener);
        } else {
            this.outerFocusChangeListener = listener;
        }
    }

    private ObjectAnimator getLabelAnimator() {
        if (this.labelAnimator == null) {
            this.labelAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"floatingLabelFraction", (float[])new float[]{0.0f, 1.0f});
        }
        this.labelAnimator.setDuration(this.floatingLabelAnimating ? 300L : 0L);
        return this.labelAnimator;
    }

    private ObjectAnimator getLabelFocusAnimator() {
        if (this.labelFocusAnimator == null) {
            this.labelFocusAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"focusFraction", (float[])new float[]{0.0f, 1.0f});
        }
        return this.labelFocusAnimator;
    }

    private ObjectAnimator getBottomLinesAnimator(float destBottomLines) {
        if (this.bottomLinesAnimator == null) {
            this.bottomLinesAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"currentBottomLines", (float[])new float[]{destBottomLines});
        } else {
            this.bottomLinesAnimator.cancel();
            this.bottomLinesAnimator.setFloatValues(new float[]{destBottomLines});
        }
        return this.bottomLinesAnimator;
    }

    protected void onDraw(@NonNull Canvas canvas) {
        int iconTop;
        Bitmap icon;
        int startX = this.getScrollX() + (this.iconLeftBitmaps == null ? 0 : this.iconOuterWidth + this.iconPadding);
        int endX = this.getScrollX() + (this.iconRightBitmaps == null ? this.getWidth() : this.getWidth() - this.iconOuterWidth - this.iconPadding);
        int lineStartY = this.getScrollY() + this.getHeight() - this.getPaddingBottom();
        this.paint.setAlpha(255);
        if (this.iconLeftBitmaps != null) {
            icon = this.iconLeftBitmaps[!this.isInternalValid() ? 3 : (!this.isEnabled() ? 2 : (this.hasFocus() ? 1 : 0))];
            int iconLeft = startX - this.iconPadding - this.iconOuterWidth + (this.iconOuterWidth - icon.getWidth()) / 2;
            iconTop = lineStartY + this.bottomSpacing - this.iconOuterHeight + (this.iconOuterHeight - icon.getHeight()) / 2;
            canvas.drawBitmap(icon, (float)iconLeft, (float)iconTop, this.paint);
        }
        if (this.iconRightBitmaps != null) {
            icon = this.iconRightBitmaps[!this.isInternalValid() ? 3 : (!this.isEnabled() ? 2 : (this.hasFocus() ? 1 : 0))];
            int iconRight = endX + this.iconPadding + (this.iconOuterWidth - icon.getWidth()) / 2;
            iconTop = lineStartY + this.bottomSpacing - this.iconOuterHeight + (this.iconOuterHeight - icon.getHeight()) / 2;
            canvas.drawBitmap(icon, (float)iconRight, (float)iconTop, this.paint);
        }
        if (this.hasFocus() && this.showClearButton && !TextUtils.isEmpty((CharSequence)this.getText())) {
            this.paint.setAlpha(255);
            int buttonLeft = this.isRTL() ? startX : endX - this.iconOuterWidth;
            Bitmap clearButtonBitmap = this.clearButtonBitmaps[0];
            iconTop = lineStartY + this.bottomSpacing - this.iconOuterHeight + (this.iconOuterHeight - clearButtonBitmap.getHeight()) / 2;
            canvas.drawBitmap(clearButtonBitmap, (float)(buttonLeft += (this.iconOuterWidth - clearButtonBitmap.getWidth()) / 2), (float)iconTop, this.paint);
        }
        if (!this.hideUnderline) {
            lineStartY += this.bottomSpacing;
            if (!this.isInternalValid()) {
                this.paint.setColor(this.errorColor);
                canvas.drawRect((float)startX, (float)lineStartY, (float)endX, (float)(lineStartY + this.getPixel(2)), this.paint);
            } else if (!this.isEnabled()) {
                this.paint.setColor(this.underlineColor != -1 ? this.underlineColor : this.baseColor & 0xFFFFFF | 0x44000000);
                float interval = this.getPixel(1);
                for (float xOffset = 0.0f; xOffset < (float)this.getWidth(); xOffset += interval * 3.0f) {
                    canvas.drawRect((float)startX + xOffset, (float)lineStartY, (float)startX + xOffset + interval, (float)(lineStartY + this.getPixel(1)), this.paint);
                }
            } else if (this.hasFocus()) {
                this.paint.setColor(this.primaryColor);
                canvas.drawRect((float)startX, (float)lineStartY, (float)endX, (float)(lineStartY + this.getPixel(2)), this.paint);
            } else {
                this.paint.setColor(this.underlineColor != -1 ? this.underlineColor : this.baseColor & 0xFFFFFF | 0x1E000000);
                canvas.drawRect((float)startX, (float)lineStartY, (float)endX, (float)(lineStartY + this.getPixel(1)), this.paint);
            }
        }
        this.textPaint.setTextSize((float)this.bottomTextSize);
        Paint.FontMetrics textMetrics = this.textPaint.getFontMetrics();
        float relativeHeight = -textMetrics.ascent - textMetrics.descent;
        float bottomTextPadding = (float)this.bottomTextSize + textMetrics.ascent + textMetrics.descent;
        if (this.hasFocus() && this.hasCharactersCounter() || !this.isCharactersCountValid()) {
            this.textPaint.setColor(this.isCharactersCountValid() ? this.baseColor & 0xFFFFFF | 0x44000000 : this.errorColor);
            String charactersCounterText = this.getCharactersCounterText();
            canvas.drawText(charactersCounterText, this.isRTL() ? (float)startX : (float)endX - this.textPaint.measureText(charactersCounterText), (float)(lineStartY + this.bottomSpacing) + relativeHeight, (Paint)this.textPaint);
        }
        if (this.textLayout != null && (this.tempErrorText != null || (this.helperTextAlwaysShown || this.hasFocus()) && !TextUtils.isEmpty((CharSequence)this.helperText))) {
            this.textPaint.setColor(this.tempErrorText != null ? this.errorColor : (this.helperTextColor != -1 ? this.helperTextColor : this.baseColor & 0xFFFFFF | 0x44000000));
            canvas.save();
            if (this.isRTL()) {
                canvas.translate((float)(endX - this.textLayout.getWidth()), (float)(lineStartY + this.bottomSpacing) - bottomTextPadding);
            } else {
                canvas.translate((float)(startX + this.getBottomTextLeftOffset()), (float)(lineStartY + this.bottomSpacing) - bottomTextPadding);
            }
            this.textLayout.draw(canvas);
            canvas.restore();
        }
        if (this.floatingLabelEnabled && !TextUtils.isEmpty((CharSequence)this.floatingLabelText)) {
            this.textPaint.setTextSize((float)this.floatingLabelTextSize);
            this.textPaint.setColor(((Integer)this.focusEvaluator.evaluate(this.focusFraction, (Object)(this.floatingLabelTextColor != -1 ? this.floatingLabelTextColor : this.baseColor & 0xFFFFFF | 0x44000000), (Object)this.primaryColor)).intValue());
            float floatingLabelWidth = this.textPaint.measureText(this.floatingLabelText.toString());
            int floatingLabelStartX = (this.getGravity() & 5) == 5 || this.isRTL() ? (int)((float)endX - floatingLabelWidth) : ((this.getGravity() & 3) == 3 ? startX : startX + (int)((float)this.getInnerPaddingLeft() + ((float)(this.getWidth() - this.getInnerPaddingLeft() - this.getInnerPaddingRight()) - floatingLabelWidth) / 2.0f));
            int distance = this.floatingLabelPadding;
            int floatingLabelStartY = (int)((float)(this.innerPaddingTop + this.floatingLabelTextSize + this.floatingLabelPadding) - (float)distance * (this.floatingLabelAlwaysShown ? 1.0f : this.floatingLabelFraction) + (float)this.getScrollY());
            int alpha = (int)((this.floatingLabelAlwaysShown ? 1.0f : this.floatingLabelFraction) * 255.0f * (0.74f * this.focusFraction + 0.26f) * (this.floatingLabelTextColor != -1 ? 1.0f : (float)Color.alpha((int)this.floatingLabelTextColor) / 256.0f));
            this.textPaint.setAlpha(alpha);
            canvas.drawText(this.floatingLabelText.toString(), (float)floatingLabelStartX, (float)floatingLabelStartY, (Paint)this.textPaint);
        }
        if (this.hasFocus() && this.singleLineEllipsis && this.getScrollX() != 0) {
            this.paint.setColor(this.isInternalValid() ? this.primaryColor : this.errorColor);
            float startY = lineStartY + this.bottomSpacing;
            int ellipsisStartX = this.isRTL() ? endX : startX;
            int signum = this.isRTL() ? -1 : 1;
            canvas.drawCircle((float)(ellipsisStartX + signum * this.bottomEllipsisSize / 2), startY + (float)(this.bottomEllipsisSize / 2), (float)(this.bottomEllipsisSize / 2), this.paint);
            canvas.drawCircle((float)(ellipsisStartX + signum * this.bottomEllipsisSize * 5 / 2), startY + (float)(this.bottomEllipsisSize / 2), (float)(this.bottomEllipsisSize / 2), this.paint);
            canvas.drawCircle((float)(ellipsisStartX + signum * this.bottomEllipsisSize * 9 / 2), startY + (float)(this.bottomEllipsisSize / 2), (float)(this.bottomEllipsisSize / 2), this.paint);
        }
        super.onDraw(canvas);
    }

    @TargetApi(value=17)
    private boolean isRTL() {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        Configuration config = this.getResources().getConfiguration();
        return config.getLayoutDirection() == 1;
    }

    private int getBottomTextLeftOffset() {
        return this.isRTL() ? this.getCharactersCounterWidth() : this.getBottomEllipsisWidth();
    }

    private int getBottomTextRightOffset() {
        return this.isRTL() ? this.getBottomEllipsisWidth() : this.getCharactersCounterWidth();
    }

    private int getCharactersCounterWidth() {
        return this.hasCharactersCounter() ? (int)this.textPaint.measureText(this.getCharactersCounterText()) : 0;
    }

    private int getBottomEllipsisWidth() {
        return this.singleLineEllipsis ? this.bottomEllipsisSize * 5 + this.getPixel(4) : 0;
    }

    private void checkCharactersCount() {
        if (!this.firstShown && !this.checkCharactersCountAtBeginning || !this.hasCharactersCounter()) {
            this.charactersCountValid = true;
        } else {
            Editable text = this.getText();
            int count = text == null ? 0 : this.checkLength((CharSequence)text);
            this.charactersCountValid = count >= this.minCharacters && (this.maxCharacters <= 0 || count <= this.maxCharacters);
        }
    }

    public boolean isCharactersCountValid() {
        return this.charactersCountValid;
    }

    private boolean hasCharactersCounter() {
        return this.minCharacters > 0 || this.maxCharacters > 0;
    }

    private String getCharactersCounterText() {
        String text = this.minCharacters <= 0 ? (this.isRTL() ? this.maxCharacters + " / " + this.checkLength((CharSequence)this.getText()) : this.checkLength((CharSequence)this.getText()) + " / " + this.maxCharacters) : (this.maxCharacters <= 0 ? (this.isRTL() ? "+" + this.minCharacters + " / " + this.checkLength((CharSequence)this.getText()) : this.checkLength((CharSequence)this.getText()) + " / " + this.minCharacters + "+") : (this.isRTL() ? this.maxCharacters + "-" + this.minCharacters + " / " + this.checkLength((CharSequence)this.getText()) : this.checkLength((CharSequence)this.getText()) + " / " + this.minCharacters + "-" + this.maxCharacters));
        return text;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.singleLineEllipsis && this.getScrollX() > 0 && event.getAction() == 0 && event.getX() < (float)this.getPixel(20) && event.getY() > (float)(this.getHeight() - this.extraPaddingBottom - this.innerPaddingBottom) && event.getY() < (float)(this.getHeight() - this.innerPaddingBottom)) {
            this.setSelection(0);
            return false;
        }
        if (this.hasFocus() && this.showClearButton) {
            switch (event.getAction()) {
                case 0: {
                    if (this.insideClearButton(event)) {
                        this.clearButtonTouched = true;
                        this.clearButtonClicking = true;
                    }
                    return true;
                }
                case 2: {
                    if (this.clearButtonClicking && !this.insideClearButton(event)) {
                        this.clearButtonClicking = false;
                    }
                    if (!this.clearButtonTouched) break;
                    return true;
                }
                case 1: {
                    if (this.clearButtonClicking) {
                        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
                            this.setText(null);
                        }
                        this.clearButtonClicking = false;
                    }
                    if (this.clearButtonTouched) {
                        this.clearButtonTouched = false;
                        return true;
                    }
                    this.clearButtonTouched = false;
                    break;
                }
                case 3: {
                    this.clearButtonTouched = false;
                    this.clearButtonClicking = false;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean insideClearButton(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int startX = this.getScrollX() + (this.iconLeftBitmaps == null ? 0 : this.iconOuterWidth + this.iconPadding);
        int endX = this.getScrollX() + (this.iconRightBitmaps == null ? this.getWidth() : this.getWidth() - this.iconOuterWidth - this.iconPadding);
        int buttonLeft = this.isRTL() ? startX : endX - this.iconOuterWidth;
        int buttonTop = this.getScrollY() + this.getHeight() - this.getPaddingBottom() + this.bottomSpacing - this.iconOuterHeight;
        return x >= (float)buttonLeft && x < (float)(buttonLeft + this.iconOuterWidth) && y >= (float)buttonTop && y < (float)(buttonTop + this.iconOuterHeight);
    }

    private int checkLength(CharSequence text) {
        if (this.lengthChecker == null) {
            return text.length();
        }
        return this.lengthChecker.getLength(text);
    }

    @IntDef(value={0L, 1L, 2L})
    public static @interface FloatingLabelType {
    }
}

