/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RuneDataType;
import java.util.Arrays;
import org.finos.rune.mapper.processor.SerializationPreProcessor;

public class RuneJsonObjectWriter
extends ObjectWriter {
    private final ObjectMapper mapper;
    private final SerializationPreProcessor serializationPreProcessor;

    protected RuneJsonObjectWriter(ObjectMapper mapper, SerializationConfig config, FormatSchema s) {
        super(mapper, config, s);
        this.mapper = mapper;
        this.serializationPreProcessor = new SerializationPreProcessor();
    }

    public RuneJsonObjectWriter(ObjectMapper mapper, SerializationConfig config) {
        super(mapper, config);
        this.mapper = mapper;
        this.serializationPreProcessor = new SerializationPreProcessor();
    }

    protected RuneJsonObjectWriter(ObjectMapper mapper, SerializationConfig config, JavaType rootType, PrettyPrinter pp) {
        super(mapper, config, rootType, pp);
        this.mapper = mapper;
        this.serializationPreProcessor = new SerializationPreProcessor();
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        if (value instanceof RosettaModelObject) {
            RosettaModelObject processed = this.serializationPreProcessor.process((RosettaModelObject)value);
            return super.writeValueAsString(this.createTopLevelHeadersWrapper(processed));
        }
        return super.writeValueAsString(value);
    }

    private Object createTopLevelHeadersWrapper(RosettaModelObject rosettaModelObject) {
        Class runeType = rosettaModelObject.getType();
        return Arrays.stream(runeType.getAnnotations()).filter(allAnnotations -> allAnnotations.annotationType().equals(RuneDataType.class)).findFirst().map(a -> {
            RuneDataType runeDataType = (RuneDataType)a;
            TopLevel topLevel = new TopLevel();
            topLevel.setModel(runeDataType.model());
            topLevel.setType(runeType.getCanonicalName());
            topLevel.setVersion(runeDataType.version());
            topLevel.setRosettaModelObject(rosettaModelObject);
            return topLevel;
        }).orElse(rosettaModelObject);
    }

    private static class TopLevel {
        private String model;
        private String type;
        private String version;
        private RosettaModelObject rosettaModelObject;

        private TopLevel() {
        }

        @JsonGetter(value="@model")
        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        @JsonGetter(value="@type")
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @JsonGetter(value="@version")
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @JsonGetter(value="rosettaModelObject")
        @JsonUnwrapped
        public RosettaModelObject getRosettaModelObject() {
            return this.rosettaModelObject;
        }

        public void setRosettaModelObject(RosettaModelObject rosettaModelObject) {
            this.rosettaModelObject = rosettaModelObject;
        }
    }
}

