/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.volatility.swaps;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eq.shared.DirectionalLegUnderlyerValuation;
import fpml.consolidated.eq.shared.EquityValuation;
import fpml.consolidated.option.shared.FxFeature;
import fpml.consolidated.option.shared.OptionSettlementModel;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.LegIdentifier;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.volatility.swaps.VolatilityAmount;
import fpml.consolidated.volatility.swaps.meta.VolatilityLegMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="VolatilityLeg", builder=VolatilityLegBuilderImpl.class, version="1.2.2")
@RuneDataType(value="VolatilityLeg", model="fpml", builder=VolatilityLegBuilderImpl.class, version="1.2.2")
public interface VolatilityLeg
extends DirectionalLegUnderlyerValuation {
    public static final VolatilityLegMeta metaData = new VolatilityLegMeta();

    public VolatilityAmount getAmount();

    @Override
    public VolatilityLeg build();

    @Override
    public VolatilityLegBuilder toBuilder();

    public static VolatilityLegBuilder builder() {
        return new VolatilityLegBuilderImpl();
    }

    default public RosettaMetaData<? extends VolatilityLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VolatilityLeg> getType() {
        return VolatilityLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.class, this.getOptionSettlementModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.class, this.getFxFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuation"), processor, EquityValuation.class, this.getValuation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, VolatilityAmount.class, this.getAmount(), new AttributeMeta[0]);
    }

    public static class VolatilityLegBuilderImpl
    extends DirectionalLegUnderlyerValuation.DirectionalLegUnderlyerValuationBuilderImpl
    implements VolatilityLegBuilder {
        protected VolatilityAmount.VolatilityAmountBuilder amount;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public VolatilityAmount.VolatilityAmountBuilder getAmount() {
            return this.amount;
        }

        @Override
        public VolatilityAmount.VolatilityAmountBuilder getOrCreateAmount() {
            VolatilityAmount.VolatilityAmountBuilder result = this.amount != null ? this.amount : (this.amount = VolatilityAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public VolatilityLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public VolatilityLegBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public VolatilityLegBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public VolatilityLegBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public VolatilityLegBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public VolatilityLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public VolatilityLegBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public VolatilityLegBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public VolatilityLegBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public VolatilityLegBuilder setOptionSettlementModel(OptionSettlementModel _optionSettlementModel) {
            this.optionSettlementModel = _optionSettlementModel == null ? null : _optionSettlementModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public VolatilityLegBuilder setFxFeature(FxFeature _fxFeature) {
            this.fxFeature = _fxFeature == null ? null : _fxFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuation", isRequired=true)
        @RuneAttribute(value="valuation", isRequired=true)
        public VolatilityLegBuilder setValuation(EquityValuation _valuation) {
            this.valuation = _valuation == null ? null : _valuation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public VolatilityLegBuilder setAmount(VolatilityAmount _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        public VolatilityLeg build() {
            return new VolatilityLegImpl(this);
        }

        @Override
        public VolatilityLegBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilityLegBuilder prune() {
            super.prune();
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getAmount() != null && this.getAmount().hasData();
        }

        @Override
        public VolatilityLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VolatilityLegBuilder o = (VolatilityLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityLeg _that = (VolatilityLeg)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityLegBuilder {amount=" + String.valueOf(this.amount) + "} " + super.toString();
        }
    }

    public static interface VolatilityLegBuilder
    extends VolatilityLeg,
    DirectionalLegUnderlyerValuation.DirectionalLegUnderlyerValuationBuilder {
        public VolatilityAmount.VolatilityAmountBuilder getOrCreateAmount();

        @Override
        public VolatilityAmount.VolatilityAmountBuilder getAmount();

        @Override
        public VolatilityLegBuilder setId(String var1);

        @Override
        public VolatilityLegBuilder addLegIdentifier(LegIdentifier var1);

        @Override
        public VolatilityLegBuilder addLegIdentifier(LegIdentifier var1, int var2);

        @Override
        public VolatilityLegBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public VolatilityLegBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public VolatilityLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public VolatilityLegBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        @Override
        public VolatilityLegBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        @Override
        public VolatilityLegBuilder setUnderlyer(Underlyer var1);

        @Override
        public VolatilityLegBuilder setOptionSettlementModel(OptionSettlementModel var1);

        @Override
        public VolatilityLegBuilder setFxFeature(FxFeature var1);

        @Override
        public VolatilityLegBuilder setValuation(EquityValuation var1);

        public VolatilityLegBuilder setAmount(VolatilityAmount var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.OptionSettlementModelBuilder.class, (RosettaModelObjectBuilder)this.getOptionSettlementModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.FxFeatureBuilder.class, (RosettaModelObjectBuilder)this.getFxFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuation"), processor, EquityValuation.EquityValuationBuilder.class, (RosettaModelObjectBuilder)this.getValuation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, VolatilityAmount.VolatilityAmountBuilder.class, this.getAmount(), new AttributeMeta[0]);
        }

        @Override
        public VolatilityLegBuilder prune();
    }

    public static class VolatilityLegImpl
    extends DirectionalLegUnderlyerValuation.DirectionalLegUnderlyerValuationImpl
    implements VolatilityLeg {
        private final VolatilityAmount amount;

        protected VolatilityLegImpl(VolatilityLegBuilder builder) {
            super(builder);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public VolatilityAmount getAmount() {
            return this.amount;
        }

        @Override
        public VolatilityLeg build() {
            return this;
        }

        @Override
        public VolatilityLegBuilder toBuilder() {
            VolatilityLegBuilder builder = VolatilityLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilityLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityLeg _that = (VolatilityLeg)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityLeg {amount=" + String.valueOf(this.amount) + "} " + super.toString();
        }
    }
}

