/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.valuation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.AnyAssetReference;
import fpml.consolidated.riskdef.Valuation;
import fpml.consolidated.riskdef.ValuationScenarioReference;
import fpml.consolidated.shared.FxRate;
import fpml.consolidated.valuation.Quotation;
import fpml.consolidated.valuation.meta.AssetValuationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetValuation", builder=AssetValuationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AssetValuation", model="fpml", builder=AssetValuationBuilderImpl.class, version="1.2.2")
public interface AssetValuation
extends Valuation {
    public static final AssetValuationMeta metaData = new AssetValuationMeta();

    public List<? extends Quotation> getQuote();

    public List<? extends FxRate> getFxRate();

    @Override
    public AssetValuation build();

    @Override
    public AssetValuationBuilder toBuilder();

    public static AssetValuationBuilder builder() {
        return new AssetValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetValuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetValuation> getType() {
        return AssetValuation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("objectReference"), processor, AnyAssetReference.class, this.getObjectReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.class, this.getValuationScenarioReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("definitionRef"), String.class, (Object)this.getDefinitionRef(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quote"), processor, Quotation.class, this.getQuote(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.class, this.getFxRate(), new AttributeMeta[0]);
    }

    public static class AssetValuationBuilderImpl
    extends Valuation.ValuationBuilderImpl
    implements AssetValuationBuilder {
        protected List<Quotation.QuotationBuilder> quote = new ArrayList<Quotation.QuotationBuilder>();
        protected List<FxRate.FxRateBuilder> fxRate = new ArrayList<FxRate.FxRateBuilder>();

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public List<? extends Quotation.QuotationBuilder> getQuote() {
            return this.quote;
        }

        @Override
        public Quotation.QuotationBuilder getOrCreateQuote(int index) {
            if (this.quote == null) {
                this.quote = new ArrayList<Quotation.QuotationBuilder>();
            }
            return (Quotation.QuotationBuilder)this.getIndex(this.quote, index, () -> {
                Quotation.QuotationBuilder newQuote = Quotation.builder();
                return newQuote;
            });
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public List<? extends FxRate.FxRateBuilder> getFxRate() {
            return this.fxRate;
        }

        @Override
        public FxRate.FxRateBuilder getOrCreateFxRate(int index) {
            if (this.fxRate == null) {
                this.fxRate = new ArrayList<FxRate.FxRateBuilder>();
            }
            return (FxRate.FxRateBuilder)this.getIndex(this.fxRate, index, () -> {
                FxRate.FxRateBuilder newFxRate = FxRate.builder();
                return newFxRate;
            });
        }

        @Override
        @RosettaAttribute(value="objectReference")
        @RuneAttribute(value="objectReference")
        public AssetValuationBuilder setObjectReference(AnyAssetReference _objectReference) {
            this.objectReference = _objectReference == null ? null : _objectReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public AssetValuationBuilder setValuationScenarioReference(ValuationScenarioReference _valuationScenarioReference) {
            this.valuationScenarioReference = _valuationScenarioReference == null ? null : _valuationScenarioReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public AssetValuationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="definitionRef")
        @RuneAttribute(value="definitionRef")
        public AssetValuationBuilder setDefinitionRef(String _definitionRef) {
            this.definitionRef = _definitionRef == null ? null : _definitionRef;
            return this;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public AssetValuationBuilder addQuote(Quotation _quote) {
            if (_quote != null) {
                this.quote.add(_quote.toBuilder());
            }
            return this;
        }

        @Override
        public AssetValuationBuilder addQuote(Quotation _quote, int idx) {
            this.getIndex(this.quote, idx, () -> _quote.toBuilder());
            return this;
        }

        @Override
        public AssetValuationBuilder addQuote(List<? extends Quotation> quotes) {
            if (quotes != null) {
                for (Quotation quotation : quotes) {
                    this.quote.add(quotation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="quote")
        public AssetValuationBuilder setQuote(List<? extends Quotation> quotes) {
            this.quote = quotes == null ? new ArrayList<Quotation.QuotationBuilder>() : (List)quotes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public AssetValuationBuilder addFxRate(FxRate _fxRate) {
            if (_fxRate != null) {
                this.fxRate.add(_fxRate.toBuilder());
            }
            return this;
        }

        @Override
        public AssetValuationBuilder addFxRate(FxRate _fxRate, int idx) {
            this.getIndex(this.fxRate, idx, () -> _fxRate.toBuilder());
            return this;
        }

        @Override
        public AssetValuationBuilder addFxRate(List<? extends FxRate> fxRates) {
            if (fxRates != null) {
                for (FxRate fxRate : fxRates) {
                    this.fxRate.add(fxRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fxRate")
        public AssetValuationBuilder setFxRate(List<? extends FxRate> fxRates) {
            this.fxRate = fxRates == null ? new ArrayList<FxRate.FxRateBuilder>() : (List)fxRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetValuation build() {
            return new AssetValuationImpl(this);
        }

        @Override
        public AssetValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetValuationBuilder prune() {
            super.prune();
            this.quote = this.quote.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.fxRate = this.fxRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getQuote() != null && this.getQuote().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFxRate() != null && this.getFxRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public AssetValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AssetValuationBuilder o = (AssetValuationBuilder)other;
            merger.mergeRosetta(this.getQuote(), o.getQuote(), this::getOrCreateQuote);
            merger.mergeRosetta(this.getFxRate(), o.getFxRate(), this::getOrCreateFxRate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AssetValuation _that = (AssetValuation)this.getType().cast(o);
            if (!ListEquals.listEquals(this.quote, _that.getQuote())) {
                return false;
            }
            return ListEquals.listEquals(this.fxRate, _that.getFxRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AssetValuationBuilder {quote=" + String.valueOf(this.quote) + ", fxRate=" + String.valueOf(this.fxRate) + "} " + super.toString();
        }
    }

    public static interface AssetValuationBuilder
    extends AssetValuation,
    Valuation.ValuationBuilder {
        public Quotation.QuotationBuilder getOrCreateQuote(int var1);

        public List<? extends Quotation.QuotationBuilder> getQuote();

        public FxRate.FxRateBuilder getOrCreateFxRate(int var1);

        public List<? extends FxRate.FxRateBuilder> getFxRate();

        @Override
        public AssetValuationBuilder setObjectReference(AnyAssetReference var1);

        @Override
        public AssetValuationBuilder setValuationScenarioReference(ValuationScenarioReference var1);

        @Override
        public AssetValuationBuilder setId(String var1);

        @Override
        public AssetValuationBuilder setDefinitionRef(String var1);

        public AssetValuationBuilder addQuote(Quotation var1);

        public AssetValuationBuilder addQuote(Quotation var1, int var2);

        public AssetValuationBuilder addQuote(List<? extends Quotation> var1);

        public AssetValuationBuilder setQuote(List<? extends Quotation> var1);

        public AssetValuationBuilder addFxRate(FxRate var1);

        public AssetValuationBuilder addFxRate(FxRate var1, int var2);

        public AssetValuationBuilder addFxRate(List<? extends FxRate> var1);

        public AssetValuationBuilder setFxRate(List<? extends FxRate> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("objectReference"), processor, AnyAssetReference.AnyAssetReferenceBuilder.class, (RosettaModelObjectBuilder)this.getObjectReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.ValuationScenarioReferenceBuilder.class, (RosettaModelObjectBuilder)this.getValuationScenarioReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("definitionRef"), String.class, (Object)this.getDefinitionRef(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quote"), processor, Quotation.QuotationBuilder.class, this.getQuote(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.FxRateBuilder.class, this.getFxRate(), new AttributeMeta[0]);
        }

        @Override
        public AssetValuationBuilder prune();
    }

    public static class AssetValuationImpl
    extends Valuation.ValuationImpl
    implements AssetValuation {
        private final List<? extends Quotation> quote;
        private final List<? extends FxRate> fxRate;

        protected AssetValuationImpl(AssetValuationBuilder builder) {
            super(builder);
            this.quote = Optional.ofNullable(builder.getQuote()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fxRate = Optional.ofNullable(builder.getFxRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public List<? extends Quotation> getQuote() {
            return this.quote;
        }

        @Override
        @RosettaAttribute(value="fxRate")
        @RuneAttribute(value="fxRate")
        public List<? extends FxRate> getFxRate() {
            return this.fxRate;
        }

        @Override
        public AssetValuation build() {
            return this;
        }

        @Override
        public AssetValuationBuilder toBuilder() {
            AssetValuationBuilder builder = AssetValuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetValuationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getQuote()).ifPresent(builder::setQuote);
            Optional.ofNullable(this.getFxRate()).ifPresent(builder::setFxRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AssetValuation _that = (AssetValuation)this.getType().cast(o);
            if (!ListEquals.listEquals(this.quote, _that.getQuote())) {
                return false;
            }
            return ListEquals.listEquals(this.fxRate, _that.getFxRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AssetValuation {quote=" + String.valueOf(this.quote) + ", fxRate=" + String.valueOf(this.fxRate) + "} " + super.toString();
        }
    }
}

