/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.X509DataTypeSequence;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="X509DataTypeSequenceChoice")
@ImplementedBy(value=Default.class)
public interface X509DataTypeSequenceChoice
extends Validator<X509DataTypeSequence> {
    public static final String NAME = "X509DataTypeSequenceChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements X509DataTypeSequenceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, X509DataTypeSequence x509DataTypeSequence) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements X509DataTypeSequenceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, X509DataTypeSequence x509DataTypeSequence) {
            ComparisonResult result = this.executeDataRule(x509DataTypeSequence);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)X509DataTypeSequenceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"X509DataTypeSequence", (RosettaPath)path, (String)X509DataTypeSequenceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)X509DataTypeSequenceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"X509DataTypeSequence", (RosettaPath)path, (String)X509DataTypeSequenceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(X509DataTypeSequence x509DataTypeSequence) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)x509DataTypeSequence), Arrays.asList("x509IssuerSerial", "x509SKI", "x509SubjectName", "x509Certificate", "x509CRL", "anyContents"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

