/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.CalculationParameters;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CalculationParametersChoice")
@ImplementedBy(value=Default.class)
public interface CalculationParametersChoice
extends Validator<CalculationParameters> {
    public static final String NAME = "CalculationParametersChoice";
    public static final String DEFINITION = "optional choice lookback, observationShift , lockout";

    public static class NoOp
    implements CalculationParametersChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CalculationParameters calculationParameters) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CalculationParametersChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CalculationParameters calculationParameters) {
            ComparisonResult result = this.executeDataRule(calculationParameters);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CalculationParametersChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CalculationParameters", (RosettaPath)path, (String)CalculationParametersChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CalculationParametersChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CalculationParameters", (RosettaPath)path, (String)CalculationParametersChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CalculationParameters calculationParameters) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)calculationParameters), Arrays.asList("lookback", "observationShift", "lockout"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

