/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.BusinessUnitReference;
import fpml.consolidated.shared.ContactInformation;
import fpml.consolidated.shared.CountryCode;
import fpml.consolidated.shared.PersonId;
import fpml.consolidated.shared.PersonSequence;
import fpml.consolidated.shared.meta.PersonMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Person", builder=PersonBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Person", model="fpml", builder=PersonBuilderImpl.class, version="1.2.2")
public interface Person
extends RosettaModelObject {
    public static final PersonMeta metaData = new PersonMeta();

    public PersonSequence getPersonSequence();

    public List<? extends PersonId> getPersonId();

    public BusinessUnitReference getBusinessUnitReference();

    public ContactInformation getContactInfo();

    public ZonedDateTime getDateOfBirth();

    public CountryCode getCountry();

    public String getId();

    public Person build();

    public PersonBuilder toBuilder();

    public static PersonBuilder builder() {
        return new PersonBuilderImpl();
    }

    default public RosettaMetaData<? extends Person> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Person> getType() {
        return Person.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("personSequence"), processor, PersonSequence.class, this.getPersonSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("personId"), processor, PersonId.class, this.getPersonId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessUnitReference"), processor, BusinessUnitReference.class, this.getBusinessUnitReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contactInfo"), processor, ContactInformation.class, this.getContactInfo(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dateOfBirth"), ZonedDateTime.class, (Object)this.getDateOfBirth(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("country"), processor, CountryCode.class, this.getCountry(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PersonBuilderImpl
    implements PersonBuilder {
        protected PersonSequence.PersonSequenceBuilder personSequence;
        protected List<PersonId.PersonIdBuilder> personId = new ArrayList<PersonId.PersonIdBuilder>();
        protected BusinessUnitReference.BusinessUnitReferenceBuilder businessUnitReference;
        protected ContactInformation.ContactInformationBuilder contactInfo;
        protected ZonedDateTime dateOfBirth;
        protected CountryCode.CountryCodeBuilder country;
        protected String id;

        @Override
        @RosettaAttribute(value="personSequence")
        @RuneAttribute(value="personSequence")
        public PersonSequence.PersonSequenceBuilder getPersonSequence() {
            return this.personSequence;
        }

        @Override
        public PersonSequence.PersonSequenceBuilder getOrCreatePersonSequence() {
            PersonSequence.PersonSequenceBuilder result = this.personSequence != null ? this.personSequence : (this.personSequence = PersonSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="personId")
        @RuneAttribute(value="personId")
        public List<? extends PersonId.PersonIdBuilder> getPersonId() {
            return this.personId;
        }

        @Override
        public PersonId.PersonIdBuilder getOrCreatePersonId(int index) {
            if (this.personId == null) {
                this.personId = new ArrayList<PersonId.PersonIdBuilder>();
            }
            return (PersonId.PersonIdBuilder)this.getIndex(this.personId, index, () -> {
                PersonId.PersonIdBuilder newPersonId = PersonId.builder();
                return newPersonId;
            });
        }

        @Override
        @RosettaAttribute(value="businessUnitReference")
        @RuneAttribute(value="businessUnitReference")
        public BusinessUnitReference.BusinessUnitReferenceBuilder getBusinessUnitReference() {
            return this.businessUnitReference;
        }

        @Override
        public BusinessUnitReference.BusinessUnitReferenceBuilder getOrCreateBusinessUnitReference() {
            BusinessUnitReference.BusinessUnitReferenceBuilder result = this.businessUnitReference != null ? this.businessUnitReference : (this.businessUnitReference = BusinessUnitReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contactInfo")
        @RuneAttribute(value="contactInfo")
        public ContactInformation.ContactInformationBuilder getContactInfo() {
            return this.contactInfo;
        }

        @Override
        public ContactInformation.ContactInformationBuilder getOrCreateContactInfo() {
            ContactInformation.ContactInformationBuilder result = this.contactInfo != null ? this.contactInfo : (this.contactInfo = ContactInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dateOfBirth")
        @RuneAttribute(value="dateOfBirth")
        public ZonedDateTime getDateOfBirth() {
            return this.dateOfBirth;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public CountryCode.CountryCodeBuilder getCountry() {
            return this.country;
        }

        @Override
        public CountryCode.CountryCodeBuilder getOrCreateCountry() {
            CountryCode.CountryCodeBuilder result = this.country != null ? this.country : (this.country = CountryCode.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="personSequence")
        @RuneAttribute(value="personSequence")
        public PersonBuilder setPersonSequence(PersonSequence _personSequence) {
            this.personSequence = _personSequence == null ? null : _personSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="personId")
        @RuneAttribute(value="personId")
        public PersonBuilder addPersonId(PersonId _personId) {
            if (_personId != null) {
                this.personId.add(_personId.toBuilder());
            }
            return this;
        }

        @Override
        public PersonBuilder addPersonId(PersonId _personId, int idx) {
            this.getIndex(this.personId, idx, () -> _personId.toBuilder());
            return this;
        }

        @Override
        public PersonBuilder addPersonId(List<? extends PersonId> personIds) {
            if (personIds != null) {
                for (PersonId personId : personIds) {
                    this.personId.add(personId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="personId")
        public PersonBuilder setPersonId(List<? extends PersonId> personIds) {
            this.personId = personIds == null ? new ArrayList<PersonId.PersonIdBuilder>() : (List)personIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="businessUnitReference")
        @RuneAttribute(value="businessUnitReference")
        public PersonBuilder setBusinessUnitReference(BusinessUnitReference _businessUnitReference) {
            this.businessUnitReference = _businessUnitReference == null ? null : _businessUnitReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contactInfo")
        @RuneAttribute(value="contactInfo")
        public PersonBuilder setContactInfo(ContactInformation _contactInfo) {
            this.contactInfo = _contactInfo == null ? null : _contactInfo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dateOfBirth")
        @RuneAttribute(value="dateOfBirth")
        public PersonBuilder setDateOfBirth(ZonedDateTime _dateOfBirth) {
            this.dateOfBirth = _dateOfBirth == null ? null : _dateOfBirth;
            return this;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public PersonBuilder setCountry(CountryCode _country) {
            this.country = _country == null ? null : _country.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PersonBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public Person build() {
            return new PersonImpl(this);
        }

        @Override
        public PersonBuilder toBuilder() {
            return this;
        }

        @Override
        public PersonBuilder prune() {
            if (this.personSequence != null && !this.personSequence.prune().hasData()) {
                this.personSequence = null;
            }
            this.personId = this.personId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.businessUnitReference != null && !this.businessUnitReference.prune().hasData()) {
                this.businessUnitReference = null;
            }
            if (this.contactInfo != null && !this.contactInfo.prune().hasData()) {
                this.contactInfo = null;
            }
            if (this.country != null && !this.country.prune().hasData()) {
                this.country = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPersonSequence() != null && this.getPersonSequence().hasData()) {
                return true;
            }
            if (this.getPersonId() != null && this.getPersonId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBusinessUnitReference() != null && this.getBusinessUnitReference().hasData()) {
                return true;
            }
            if (this.getContactInfo() != null && this.getContactInfo().hasData()) {
                return true;
            }
            if (this.getDateOfBirth() != null) {
                return true;
            }
            if (this.getCountry() != null && this.getCountry().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public PersonBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PersonBuilder o = (PersonBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPersonSequence(), (RosettaModelObjectBuilder)o.getPersonSequence(), this::setPersonSequence);
            merger.mergeRosetta(this.getPersonId(), o.getPersonId(), this::getOrCreatePersonId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessUnitReference(), (RosettaModelObjectBuilder)o.getBusinessUnitReference(), this::setBusinessUnitReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContactInfo(), (RosettaModelObjectBuilder)o.getContactInfo(), this::setContactInfo);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCountry(), (RosettaModelObjectBuilder)o.getCountry(), this::setCountry);
            merger.mergeBasic((Object)this.getDateOfBirth(), (Object)o.getDateOfBirth(), this::setDateOfBirth, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Person _that = this.getType().cast(o);
            if (!Objects.equals(this.personSequence, _that.getPersonSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.personId, _that.getPersonId())) {
                return false;
            }
            if (!Objects.equals(this.businessUnitReference, _that.getBusinessUnitReference())) {
                return false;
            }
            if (!Objects.equals(this.contactInfo, _that.getContactInfo())) {
                return false;
            }
            if (!Objects.equals(this.dateOfBirth, _that.getDateOfBirth())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.personSequence != null ? this.personSequence.hashCode() : 0);
            _result = 31 * _result + (this.personId != null ? this.personId.hashCode() : 0);
            _result = 31 * _result + (this.businessUnitReference != null ? this.businessUnitReference.hashCode() : 0);
            _result = 31 * _result + (this.contactInfo != null ? this.contactInfo.hashCode() : 0);
            _result = 31 * _result + (this.dateOfBirth != null ? this.dateOfBirth.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PersonBuilder {personSequence=" + String.valueOf(this.personSequence) + ", personId=" + String.valueOf(this.personId) + ", businessUnitReference=" + String.valueOf(this.businessUnitReference) + ", contactInfo=" + String.valueOf(this.contactInfo) + ", dateOfBirth=" + String.valueOf(this.dateOfBirth) + ", country=" + String.valueOf(this.country) + ", id=" + this.id + "}";
        }
    }

    public static interface PersonBuilder
    extends Person,
    RosettaModelObjectBuilder {
        public PersonSequence.PersonSequenceBuilder getOrCreatePersonSequence();

        @Override
        public PersonSequence.PersonSequenceBuilder getPersonSequence();

        public PersonId.PersonIdBuilder getOrCreatePersonId(int var1);

        public List<? extends PersonId.PersonIdBuilder> getPersonId();

        public BusinessUnitReference.BusinessUnitReferenceBuilder getOrCreateBusinessUnitReference();

        @Override
        public BusinessUnitReference.BusinessUnitReferenceBuilder getBusinessUnitReference();

        public ContactInformation.ContactInformationBuilder getOrCreateContactInfo();

        @Override
        public ContactInformation.ContactInformationBuilder getContactInfo();

        public CountryCode.CountryCodeBuilder getOrCreateCountry();

        @Override
        public CountryCode.CountryCodeBuilder getCountry();

        public PersonBuilder setPersonSequence(PersonSequence var1);

        public PersonBuilder addPersonId(PersonId var1);

        public PersonBuilder addPersonId(PersonId var1, int var2);

        public PersonBuilder addPersonId(List<? extends PersonId> var1);

        public PersonBuilder setPersonId(List<? extends PersonId> var1);

        public PersonBuilder setBusinessUnitReference(BusinessUnitReference var1);

        public PersonBuilder setContactInfo(ContactInformation var1);

        public PersonBuilder setDateOfBirth(ZonedDateTime var1);

        public PersonBuilder setCountry(CountryCode var1);

        public PersonBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("personSequence"), processor, PersonSequence.PersonSequenceBuilder.class, this.getPersonSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("personId"), processor, PersonId.PersonIdBuilder.class, this.getPersonId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessUnitReference"), processor, BusinessUnitReference.BusinessUnitReferenceBuilder.class, this.getBusinessUnitReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contactInfo"), processor, ContactInformation.ContactInformationBuilder.class, this.getContactInfo(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dateOfBirth"), ZonedDateTime.class, (Object)this.getDateOfBirth(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("country"), processor, CountryCode.CountryCodeBuilder.class, this.getCountry(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PersonBuilder prune();
    }

    public static class PersonImpl
    implements Person {
        private final PersonSequence personSequence;
        private final List<? extends PersonId> personId;
        private final BusinessUnitReference businessUnitReference;
        private final ContactInformation contactInfo;
        private final ZonedDateTime dateOfBirth;
        private final CountryCode country;
        private final String id;

        protected PersonImpl(PersonBuilder builder) {
            this.personSequence = Optional.ofNullable(builder.getPersonSequence()).map(f -> f.build()).orElse(null);
            this.personId = Optional.ofNullable(builder.getPersonId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.businessUnitReference = Optional.ofNullable(builder.getBusinessUnitReference()).map(f -> f.build()).orElse(null);
            this.contactInfo = Optional.ofNullable(builder.getContactInfo()).map(f -> f.build()).orElse(null);
            this.dateOfBirth = builder.getDateOfBirth();
            this.country = Optional.ofNullable(builder.getCountry()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="personSequence")
        @RuneAttribute(value="personSequence")
        public PersonSequence getPersonSequence() {
            return this.personSequence;
        }

        @Override
        @RosettaAttribute(value="personId")
        @RuneAttribute(value="personId")
        public List<? extends PersonId> getPersonId() {
            return this.personId;
        }

        @Override
        @RosettaAttribute(value="businessUnitReference")
        @RuneAttribute(value="businessUnitReference")
        public BusinessUnitReference getBusinessUnitReference() {
            return this.businessUnitReference;
        }

        @Override
        @RosettaAttribute(value="contactInfo")
        @RuneAttribute(value="contactInfo")
        public ContactInformation getContactInfo() {
            return this.contactInfo;
        }

        @Override
        @RosettaAttribute(value="dateOfBirth")
        @RuneAttribute(value="dateOfBirth")
        public ZonedDateTime getDateOfBirth() {
            return this.dateOfBirth;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public CountryCode getCountry() {
            return this.country;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public Person build() {
            return this;
        }

        @Override
        public PersonBuilder toBuilder() {
            PersonBuilder builder = Person.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PersonBuilder builder) {
            Optional.ofNullable(this.getPersonSequence()).ifPresent(builder::setPersonSequence);
            Optional.ofNullable(this.getPersonId()).ifPresent(builder::setPersonId);
            Optional.ofNullable(this.getBusinessUnitReference()).ifPresent(builder::setBusinessUnitReference);
            Optional.ofNullable(this.getContactInfo()).ifPresent(builder::setContactInfo);
            Optional.ofNullable(this.getDateOfBirth()).ifPresent(builder::setDateOfBirth);
            Optional.ofNullable(this.getCountry()).ifPresent(builder::setCountry);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Person _that = this.getType().cast(o);
            if (!Objects.equals(this.personSequence, _that.getPersonSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.personId, _that.getPersonId())) {
                return false;
            }
            if (!Objects.equals(this.businessUnitReference, _that.getBusinessUnitReference())) {
                return false;
            }
            if (!Objects.equals(this.contactInfo, _that.getContactInfo())) {
                return false;
            }
            if (!Objects.equals(this.dateOfBirth, _that.getDateOfBirth())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.personSequence != null ? this.personSequence.hashCode() : 0);
            _result = 31 * _result + (this.personId != null ? this.personId.hashCode() : 0);
            _result = 31 * _result + (this.businessUnitReference != null ? this.businessUnitReference.hashCode() : 0);
            _result = 31 * _result + (this.contactInfo != null ? this.contactInfo.hashCode() : 0);
            _result = 31 * _result + (this.dateOfBirth != null ? this.dateOfBirth.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Person {personSequence=" + String.valueOf(this.personSequence) + ", personId=" + String.valueOf(this.personId) + ", businessUnitReference=" + String.valueOf(this.businessUnitReference) + ", contactInfo=" + String.valueOf(this.contactInfo) + ", dateOfBirth=" + String.valueOf(this.dateOfBirth) + ", country=" + String.valueOf(this.country) + ", id=" + this.id + "}";
        }
    }
}

