/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.AdjustableOrAdjustedDate;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.PaymentBase;
import fpml.consolidated.shared.PaymentType;
import fpml.consolidated.shared.PricingStructureReference;
import fpml.consolidated.shared.SettlementInformation;
import fpml.consolidated.shared.meta.PaymentMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Payment", builder=PaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Payment", model="fpml", builder=PaymentBuilderImpl.class, version="1.2.2")
public interface Payment
extends PaymentBase {
    public static final PaymentMeta metaData = new PaymentMeta();

    public PayerReceiverModel getPayerReceiverModel();

    public NonNegativeMoney getPaymentAmount();

    public AdjustableOrAdjustedDate getPaymentDate();

    public PaymentType getPaymentType();

    public SettlementInformation getSettlementInformation();

    public BigDecimal getDiscountFactor();

    public Money getPresentValueAmount();

    public PricingStructureReference getPricingStructureReference();

    public String getHref();

    @Override
    public Payment build();

    @Override
    public PaymentBuilder toBuilder();

    public static PaymentBuilder builder() {
        return new PaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends Payment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Payment> getType() {
        return Payment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrAdjustedDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentType"), processor, PaymentType.class, this.getPaymentType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.class, this.getSettlementInformation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.class, this.getPresentValueAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingStructureReference"), processor, PricingStructureReference.class, this.getPricingStructureReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("href"), String.class, (Object)this.getHref(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PaymentBuilderImpl
    extends PaymentBase.PaymentBaseBuilderImpl
    implements PaymentBuilder {
        protected PayerReceiverModel.PayerReceiverModelBuilder payerReceiverModel;
        protected NonNegativeMoney.NonNegativeMoneyBuilder paymentAmount;
        protected AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder paymentDate;
        protected PaymentType.PaymentTypeBuilder paymentType;
        protected SettlementInformation.SettlementInformationBuilder settlementInformation;
        protected BigDecimal discountFactor;
        protected Money.MoneyBuilder presentValueAmount;
        protected PricingStructureReference.PricingStructureReferenceBuilder pricingStructureReference;
        protected String href;

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel() {
            PayerReceiverModel.PayerReceiverModelBuilder result = this.payerReceiverModel != null ? this.payerReceiverModel : (this.payerReceiverModel = PayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePaymentAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.paymentAmount != null ? this.paymentAmount : (this.paymentAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getOrCreatePaymentDate() {
            AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = AdjustableOrAdjustedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public PaymentType.PaymentTypeBuilder getPaymentType() {
            return this.paymentType;
        }

        @Override
        public PaymentType.PaymentTypeBuilder getOrCreatePaymentType() {
            PaymentType.PaymentTypeBuilder result = this.paymentType != null ? this.paymentType : (this.paymentType = PaymentType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation() {
            SettlementInformation.SettlementInformationBuilder result = this.settlementInformation != null ? this.settlementInformation : (this.settlementInformation = SettlementInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money.MoneyBuilder getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePresentValueAmount() {
            Money.MoneyBuilder result = this.presentValueAmount != null ? this.presentValueAmount : (this.presentValueAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingStructureReference")
        @RuneAttribute(value="pricingStructureReference")
        public PricingStructureReference.PricingStructureReferenceBuilder getPricingStructureReference() {
            return this.pricingStructureReference;
        }

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreatePricingStructureReference() {
            PricingStructureReference.PricingStructureReferenceBuilder result = this.pricingStructureReference != null ? this.pricingStructureReference : (this.pricingStructureReference = PricingStructureReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="href")
        @RuneAttribute(value="href")
        public String getHref() {
            return this.href;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PaymentBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public PaymentBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public PaymentBuilder setPaymentDate(AdjustableOrAdjustedDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public PaymentBuilder setPaymentType(PaymentType _paymentType) {
            this.paymentType = _paymentType == null ? null : _paymentType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public PaymentBuilder setSettlementInformation(SettlementInformation _settlementInformation) {
            this.settlementInformation = _settlementInformation == null ? null : _settlementInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public PaymentBuilder setDiscountFactor(BigDecimal _discountFactor) {
            this.discountFactor = _discountFactor == null ? null : _discountFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public PaymentBuilder setPresentValueAmount(Money _presentValueAmount) {
            this.presentValueAmount = _presentValueAmount == null ? null : _presentValueAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingStructureReference")
        @RuneAttribute(value="pricingStructureReference")
        public PaymentBuilder setPricingStructureReference(PricingStructureReference _pricingStructureReference) {
            this.pricingStructureReference = _pricingStructureReference == null ? null : _pricingStructureReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="href")
        @RuneAttribute(value="href")
        public PaymentBuilder setHref(String _href) {
            this.href = _href == null ? null : _href;
            return this;
        }

        @Override
        public Payment build() {
            return new PaymentImpl(this);
        }

        @Override
        public PaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentBuilder prune() {
            super.prune();
            if (this.payerReceiverModel != null && !this.payerReceiverModel.prune().hasData()) {
                this.payerReceiverModel = null;
            }
            if (this.paymentAmount != null && !this.paymentAmount.prune().hasData()) {
                this.paymentAmount = null;
            }
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            if (this.paymentType != null && !this.paymentType.prune().hasData()) {
                this.paymentType = null;
            }
            if (this.settlementInformation != null && !this.settlementInformation.prune().hasData()) {
                this.settlementInformation = null;
            }
            if (this.presentValueAmount != null && !this.presentValueAmount.prune().hasData()) {
                this.presentValueAmount = null;
            }
            if (this.pricingStructureReference != null && !this.pricingStructureReference.prune().hasData()) {
                this.pricingStructureReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayerReceiverModel() != null && this.getPayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getPaymentAmount() != null && this.getPaymentAmount().hasData()) {
                return true;
            }
            if (this.getPaymentDate() != null && this.getPaymentDate().hasData()) {
                return true;
            }
            if (this.getPaymentType() != null && this.getPaymentType().hasData()) {
                return true;
            }
            if (this.getSettlementInformation() != null && this.getSettlementInformation().hasData()) {
                return true;
            }
            if (this.getDiscountFactor() != null) {
                return true;
            }
            if (this.getPresentValueAmount() != null && this.getPresentValueAmount().hasData()) {
                return true;
            }
            if (this.getPricingStructureReference() != null && this.getPricingStructureReference().hasData()) {
                return true;
            }
            return this.getHref() != null;
        }

        @Override
        public PaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PaymentBuilder o = (PaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiverModel(), (RosettaModelObjectBuilder)o.getPayerReceiverModel(), this::setPayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentAmount(), (RosettaModelObjectBuilder)o.getPaymentAmount(), this::setPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentType(), (RosettaModelObjectBuilder)o.getPaymentType(), this::setPaymentType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementInformation(), (RosettaModelObjectBuilder)o.getSettlementInformation(), this::setSettlementInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPresentValueAmount(), (RosettaModelObjectBuilder)o.getPresentValueAmount(), this::setPresentValueAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingStructureReference(), (RosettaModelObjectBuilder)o.getPricingStructureReference(), this::setPricingStructureReference);
            merger.mergeBasic((Object)this.getDiscountFactor(), (Object)o.getDiscountFactor(), this::setDiscountFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getHref(), (Object)o.getHref(), this::setHref, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Payment _that = (Payment)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentType, _that.getPaymentType())) {
                return false;
            }
            if (!Objects.equals(this.settlementInformation, _that.getSettlementInformation())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.presentValueAmount, _that.getPresentValueAmount())) {
                return false;
            }
            if (!Objects.equals(this.pricingStructureReference, _that.getPricingStructureReference())) {
                return false;
            }
            return Objects.equals(this.href, _that.getHref());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentType != null ? this.paymentType.hashCode() : 0);
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructureReference != null ? this.pricingStructureReference.hashCode() : 0);
            _result = 31 * _result + (this.href != null ? this.href.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PaymentBuilder {payerReceiverModel=" + String.valueOf(this.payerReceiverModel) + ", paymentAmount=" + String.valueOf(this.paymentAmount) + ", paymentDate=" + String.valueOf(this.paymentDate) + ", paymentType=" + String.valueOf(this.paymentType) + ", settlementInformation=" + String.valueOf(this.settlementInformation) + ", discountFactor=" + String.valueOf(this.discountFactor) + ", presentValueAmount=" + String.valueOf(this.presentValueAmount) + ", pricingStructureReference=" + String.valueOf(this.pricingStructureReference) + ", href=" + this.href + "} " + super.toString();
        }
    }

    public static interface PaymentBuilder
    extends Payment,
    PaymentBase.PaymentBaseBuilder {
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel();

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePaymentAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getPaymentAmount();

        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getOrCreatePaymentDate();

        @Override
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getPaymentDate();

        public PaymentType.PaymentTypeBuilder getOrCreatePaymentType();

        @Override
        public PaymentType.PaymentTypeBuilder getPaymentType();

        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation();

        @Override
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation();

        public Money.MoneyBuilder getOrCreatePresentValueAmount();

        @Override
        public Money.MoneyBuilder getPresentValueAmount();

        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreatePricingStructureReference();

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getPricingStructureReference();

        @Override
        public PaymentBuilder setId(String var1);

        public PaymentBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public PaymentBuilder setPaymentAmount(NonNegativeMoney var1);

        public PaymentBuilder setPaymentDate(AdjustableOrAdjustedDate var1);

        public PaymentBuilder setPaymentType(PaymentType var1);

        public PaymentBuilder setSettlementInformation(SettlementInformation var1);

        public PaymentBuilder setDiscountFactor(BigDecimal var1);

        public PaymentBuilder setPresentValueAmount(Money var1);

        public PaymentBuilder setPricingStructureReference(PricingStructureReference var1);

        public PaymentBuilder setHref(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentType"), processor, PaymentType.PaymentTypeBuilder.class, this.getPaymentType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.SettlementInformationBuilder.class, this.getSettlementInformation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.MoneyBuilder.class, this.getPresentValueAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingStructureReference"), processor, PricingStructureReference.PricingStructureReferenceBuilder.class, this.getPricingStructureReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("href"), String.class, (Object)this.getHref(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public PaymentBuilder prune();
    }

    public static class PaymentImpl
    extends PaymentBase.PaymentBaseImpl
    implements Payment {
        private final PayerReceiverModel payerReceiverModel;
        private final NonNegativeMoney paymentAmount;
        private final AdjustableOrAdjustedDate paymentDate;
        private final PaymentType paymentType;
        private final SettlementInformation settlementInformation;
        private final BigDecimal discountFactor;
        private final Money presentValueAmount;
        private final PricingStructureReference pricingStructureReference;
        private final String href;

        protected PaymentImpl(PaymentBuilder builder) {
            super(builder);
            this.payerReceiverModel = Optional.ofNullable(builder.getPayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.paymentAmount = Optional.ofNullable(builder.getPaymentAmount()).map(f -> f.build()).orElse(null);
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
            this.paymentType = Optional.ofNullable(builder.getPaymentType()).map(f -> f.build()).orElse(null);
            this.settlementInformation = Optional.ofNullable(builder.getSettlementInformation()).map(f -> f.build()).orElse(null);
            this.discountFactor = builder.getDiscountFactor();
            this.presentValueAmount = Optional.ofNullable(builder.getPresentValueAmount()).map(f -> f.build()).orElse(null);
            this.pricingStructureReference = Optional.ofNullable(builder.getPricingStructureReference()).map(f -> f.build()).orElse(null);
            this.href = builder.getHref();
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public NonNegativeMoney getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableOrAdjustedDate getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public PaymentType getPaymentType() {
            return this.paymentType;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        @RosettaAttribute(value="discountFactor")
        @RuneAttribute(value="discountFactor")
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        @RosettaAttribute(value="presentValueAmount")
        @RuneAttribute(value="presentValueAmount")
        public Money getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        @RosettaAttribute(value="pricingStructureReference")
        @RuneAttribute(value="pricingStructureReference")
        public PricingStructureReference getPricingStructureReference() {
            return this.pricingStructureReference;
        }

        @Override
        @RosettaAttribute(value="href")
        @RuneAttribute(value="href")
        public String getHref() {
            return this.href;
        }

        @Override
        public Payment build() {
            return this;
        }

        @Override
        public PaymentBuilder toBuilder() {
            PaymentBuilder builder = Payment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayerReceiverModel()).ifPresent(builder::setPayerReceiverModel);
            Optional.ofNullable(this.getPaymentAmount()).ifPresent(builder::setPaymentAmount);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getPaymentType()).ifPresent(builder::setPaymentType);
            Optional.ofNullable(this.getSettlementInformation()).ifPresent(builder::setSettlementInformation);
            Optional.ofNullable(this.getDiscountFactor()).ifPresent(builder::setDiscountFactor);
            Optional.ofNullable(this.getPresentValueAmount()).ifPresent(builder::setPresentValueAmount);
            Optional.ofNullable(this.getPricingStructureReference()).ifPresent(builder::setPricingStructureReference);
            Optional.ofNullable(this.getHref()).ifPresent(builder::setHref);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Payment _that = (Payment)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentType, _that.getPaymentType())) {
                return false;
            }
            if (!Objects.equals(this.settlementInformation, _that.getSettlementInformation())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.presentValueAmount, _that.getPresentValueAmount())) {
                return false;
            }
            if (!Objects.equals(this.pricingStructureReference, _that.getPricingStructureReference())) {
                return false;
            }
            return Objects.equals(this.href, _that.getHref());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentType != null ? this.paymentType.hashCode() : 0);
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructureReference != null ? this.pricingStructureReference.hashCode() : 0);
            _result = 31 * _result + (this.href != null ? this.href.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Payment {payerReceiverModel=" + String.valueOf(this.payerReceiverModel) + ", paymentAmount=" + String.valueOf(this.paymentAmount) + ", paymentDate=" + String.valueOf(this.paymentDate) + ", paymentType=" + String.valueOf(this.paymentType) + ", settlementInformation=" + String.valueOf(this.settlementInformation) + ", discountFactor=" + String.valueOf(this.discountFactor) + ", presentValueAmount=" + String.valueOf(this.presentValueAmount) + ", pricingStructureReference=" + String.valueOf(this.pricingStructureReference) + ", href=" + this.href + "} " + super.toString();
        }
    }
}

