/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.ReferenceBank;
import fpml.consolidated.shared.meta.CashSettlementReferenceBanksMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CashSettlementReferenceBanks", builder=CashSettlementReferenceBanksBuilderImpl.class, version="1.2.2")
@RuneDataType(value="CashSettlementReferenceBanks", model="fpml", builder=CashSettlementReferenceBanksBuilderImpl.class, version="1.2.2")
public interface CashSettlementReferenceBanks
extends RosettaModelObject {
    public static final CashSettlementReferenceBanksMeta metaData = new CashSettlementReferenceBanksMeta();

    public List<? extends ReferenceBank> getReferenceBank();

    public String getId();

    public CashSettlementReferenceBanks build();

    public CashSettlementReferenceBanksBuilder toBuilder();

    public static CashSettlementReferenceBanksBuilder builder() {
        return new CashSettlementReferenceBanksBuilderImpl();
    }

    default public RosettaMetaData<? extends CashSettlementReferenceBanks> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CashSettlementReferenceBanks> getType() {
        return CashSettlementReferenceBanks.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("referenceBank"), processor, ReferenceBank.class, this.getReferenceBank(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CashSettlementReferenceBanksBuilderImpl
    implements CashSettlementReferenceBanksBuilder {
        protected List<ReferenceBank.ReferenceBankBuilder> referenceBank = new ArrayList<ReferenceBank.ReferenceBankBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="referenceBank")
        @RuneAttribute(value="referenceBank")
        public List<? extends ReferenceBank.ReferenceBankBuilder> getReferenceBank() {
            return this.referenceBank;
        }

        @Override
        public ReferenceBank.ReferenceBankBuilder getOrCreateReferenceBank(int index) {
            if (this.referenceBank == null) {
                this.referenceBank = new ArrayList<ReferenceBank.ReferenceBankBuilder>();
            }
            return (ReferenceBank.ReferenceBankBuilder)this.getIndex(this.referenceBank, index, () -> {
                ReferenceBank.ReferenceBankBuilder newReferenceBank = ReferenceBank.builder();
                return newReferenceBank;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="referenceBank")
        @RuneAttribute(value="referenceBank")
        public CashSettlementReferenceBanksBuilder addReferenceBank(ReferenceBank _referenceBank) {
            if (_referenceBank != null) {
                this.referenceBank.add(_referenceBank.toBuilder());
            }
            return this;
        }

        @Override
        public CashSettlementReferenceBanksBuilder addReferenceBank(ReferenceBank _referenceBank, int idx) {
            this.getIndex(this.referenceBank, idx, () -> _referenceBank.toBuilder());
            return this;
        }

        @Override
        public CashSettlementReferenceBanksBuilder addReferenceBank(List<? extends ReferenceBank> referenceBanks) {
            if (referenceBanks != null) {
                for (ReferenceBank referenceBank : referenceBanks) {
                    this.referenceBank.add(referenceBank.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="referenceBank")
        public CashSettlementReferenceBanksBuilder setReferenceBank(List<? extends ReferenceBank> referenceBanks) {
            this.referenceBank = referenceBanks == null ? new ArrayList<ReferenceBank.ReferenceBankBuilder>() : (List)referenceBanks.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CashSettlementReferenceBanksBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public CashSettlementReferenceBanks build() {
            return new CashSettlementReferenceBanksImpl(this);
        }

        @Override
        public CashSettlementReferenceBanksBuilder toBuilder() {
            return this;
        }

        @Override
        public CashSettlementReferenceBanksBuilder prune() {
            this.referenceBank = this.referenceBank.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getReferenceBank() != null && this.getReferenceBank().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public CashSettlementReferenceBanksBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashSettlementReferenceBanksBuilder o = (CashSettlementReferenceBanksBuilder)other;
            merger.mergeRosetta(this.getReferenceBank(), o.getReferenceBank(), this::getOrCreateReferenceBank);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashSettlementReferenceBanks _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.referenceBank, _that.getReferenceBank())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.referenceBank != null ? this.referenceBank.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashSettlementReferenceBanksBuilder {referenceBank=" + String.valueOf(this.referenceBank) + ", id=" + this.id + "}";
        }
    }

    public static interface CashSettlementReferenceBanksBuilder
    extends CashSettlementReferenceBanks,
    RosettaModelObjectBuilder {
        public ReferenceBank.ReferenceBankBuilder getOrCreateReferenceBank(int var1);

        public List<? extends ReferenceBank.ReferenceBankBuilder> getReferenceBank();

        public CashSettlementReferenceBanksBuilder addReferenceBank(ReferenceBank var1);

        public CashSettlementReferenceBanksBuilder addReferenceBank(ReferenceBank var1, int var2);

        public CashSettlementReferenceBanksBuilder addReferenceBank(List<? extends ReferenceBank> var1);

        public CashSettlementReferenceBanksBuilder setReferenceBank(List<? extends ReferenceBank> var1);

        public CashSettlementReferenceBanksBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("referenceBank"), processor, ReferenceBank.ReferenceBankBuilder.class, this.getReferenceBank(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CashSettlementReferenceBanksBuilder prune();
    }

    public static class CashSettlementReferenceBanksImpl
    implements CashSettlementReferenceBanks {
        private final List<? extends ReferenceBank> referenceBank;
        private final String id;

        protected CashSettlementReferenceBanksImpl(CashSettlementReferenceBanksBuilder builder) {
            this.referenceBank = Optional.ofNullable(builder.getReferenceBank()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="referenceBank")
        @RuneAttribute(value="referenceBank")
        public List<? extends ReferenceBank> getReferenceBank() {
            return this.referenceBank;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public CashSettlementReferenceBanks build() {
            return this;
        }

        @Override
        public CashSettlementReferenceBanksBuilder toBuilder() {
            CashSettlementReferenceBanksBuilder builder = CashSettlementReferenceBanks.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashSettlementReferenceBanksBuilder builder) {
            Optional.ofNullable(this.getReferenceBank()).ifPresent(builder::setReferenceBank);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashSettlementReferenceBanks _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.referenceBank, _that.getReferenceBank())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.referenceBank != null ? this.referenceBank.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashSettlementReferenceBanks {referenceBank=" + String.valueOf(this.referenceBank) + ", id=" + this.id + "}";
        }
    }
}

