/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.riskdef;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.QuotationCharacteristics;
import fpml.consolidated.riskdef.DerivativeCalculationProcedure;
import fpml.consolidated.riskdef.PricingInputType;
import fpml.consolidated.riskdef.SensitivityDefinition;
import fpml.consolidated.riskdef.ValuationScenarioReference;
import fpml.consolidated.riskdef.meta.SensitivitySetDefinitionMeta;
import fpml.consolidated.shared.PricingStructureReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SensitivitySetDefinition", builder=SensitivitySetDefinitionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="SensitivitySetDefinition", model="fpml", builder=SensitivitySetDefinitionBuilderImpl.class, version="1.2.2")
public interface SensitivitySetDefinition
extends RosettaModelObject {
    public static final SensitivitySetDefinitionMeta metaData = new SensitivitySetDefinitionMeta();

    public String getName();

    public QuotationCharacteristics getSensitivityCharacteristics();

    public ValuationScenarioReference getValuationScenarioReference();

    public PricingInputType getPricingInputType();

    public PricingStructureReference getPricingInputReference();

    public BigDecimal getScale();

    public List<? extends SensitivityDefinition> getSensitivityDefinition();

    public DerivativeCalculationProcedure getCalculationProcedure();

    public String getId();

    public SensitivitySetDefinition build();

    public SensitivitySetDefinitionBuilder toBuilder();

    public static SensitivitySetDefinitionBuilder builder() {
        return new SensitivitySetDefinitionBuilderImpl();
    }

    default public RosettaMetaData<? extends SensitivitySetDefinition> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SensitivitySetDefinition> getType() {
        return SensitivitySetDefinition.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sensitivityCharacteristics"), processor, QuotationCharacteristics.class, this.getSensitivityCharacteristics(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.class, this.getValuationScenarioReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingInputType"), processor, PricingInputType.class, this.getPricingInputType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingInputReference"), processor, PricingStructureReference.class, this.getPricingInputReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("scale"), BigDecimal.class, (Object)this.getScale(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sensitivityDefinition"), processor, SensitivityDefinition.class, this.getSensitivityDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationProcedure"), processor, DerivativeCalculationProcedure.class, this.getCalculationProcedure(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SensitivitySetDefinitionBuilderImpl
    implements SensitivitySetDefinitionBuilder {
        protected String name;
        protected QuotationCharacteristics.QuotationCharacteristicsBuilder sensitivityCharacteristics;
        protected ValuationScenarioReference.ValuationScenarioReferenceBuilder valuationScenarioReference;
        protected PricingInputType.PricingInputTypeBuilder pricingInputType;
        protected PricingStructureReference.PricingStructureReferenceBuilder pricingInputReference;
        protected BigDecimal scale;
        protected List<SensitivityDefinition.SensitivityDefinitionBuilder> sensitivityDefinition = new ArrayList<SensitivityDefinition.SensitivityDefinitionBuilder>();
        protected DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder calculationProcedure;
        protected String id;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="sensitivityCharacteristics")
        @RuneAttribute(value="sensitivityCharacteristics")
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getSensitivityCharacteristics() {
            return this.sensitivityCharacteristics;
        }

        @Override
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getOrCreateSensitivityCharacteristics() {
            QuotationCharacteristics.QuotationCharacteristicsBuilder result = this.sensitivityCharacteristics != null ? this.sensitivityCharacteristics : (this.sensitivityCharacteristics = QuotationCharacteristics.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public ValuationScenarioReference.ValuationScenarioReferenceBuilder getValuationScenarioReference() {
            return this.valuationScenarioReference;
        }

        @Override
        public ValuationScenarioReference.ValuationScenarioReferenceBuilder getOrCreateValuationScenarioReference() {
            ValuationScenarioReference.ValuationScenarioReferenceBuilder result = this.valuationScenarioReference != null ? this.valuationScenarioReference : (this.valuationScenarioReference = ValuationScenarioReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingInputType")
        @RuneAttribute(value="pricingInputType")
        public PricingInputType.PricingInputTypeBuilder getPricingInputType() {
            return this.pricingInputType;
        }

        @Override
        public PricingInputType.PricingInputTypeBuilder getOrCreatePricingInputType() {
            PricingInputType.PricingInputTypeBuilder result = this.pricingInputType != null ? this.pricingInputType : (this.pricingInputType = PricingInputType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingInputReference")
        @RuneAttribute(value="pricingInputReference")
        public PricingStructureReference.PricingStructureReferenceBuilder getPricingInputReference() {
            return this.pricingInputReference;
        }

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreatePricingInputReference() {
            PricingStructureReference.PricingStructureReferenceBuilder result = this.pricingInputReference != null ? this.pricingInputReference : (this.pricingInputReference = PricingStructureReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="scale")
        @RuneAttribute(value="scale")
        public BigDecimal getScale() {
            return this.scale;
        }

        @Override
        @RosettaAttribute(value="sensitivityDefinition")
        @RuneAttribute(value="sensitivityDefinition")
        public List<? extends SensitivityDefinition.SensitivityDefinitionBuilder> getSensitivityDefinition() {
            return this.sensitivityDefinition;
        }

        @Override
        public SensitivityDefinition.SensitivityDefinitionBuilder getOrCreateSensitivityDefinition(int index) {
            if (this.sensitivityDefinition == null) {
                this.sensitivityDefinition = new ArrayList<SensitivityDefinition.SensitivityDefinitionBuilder>();
            }
            return (SensitivityDefinition.SensitivityDefinitionBuilder)this.getIndex(this.sensitivityDefinition, index, () -> {
                SensitivityDefinition.SensitivityDefinitionBuilder newSensitivityDefinition = SensitivityDefinition.builder();
                return newSensitivityDefinition;
            });
        }

        @Override
        @RosettaAttribute(value="calculationProcedure")
        @RuneAttribute(value="calculationProcedure")
        public DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder getCalculationProcedure() {
            return this.calculationProcedure;
        }

        @Override
        public DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder getOrCreateCalculationProcedure() {
            DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder result = this.calculationProcedure != null ? this.calculationProcedure : (this.calculationProcedure = DerivativeCalculationProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public SensitivitySetDefinitionBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="sensitivityCharacteristics")
        @RuneAttribute(value="sensitivityCharacteristics")
        public SensitivitySetDefinitionBuilder setSensitivityCharacteristics(QuotationCharacteristics _sensitivityCharacteristics) {
            this.sensitivityCharacteristics = _sensitivityCharacteristics == null ? null : _sensitivityCharacteristics.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public SensitivitySetDefinitionBuilder setValuationScenarioReference(ValuationScenarioReference _valuationScenarioReference) {
            this.valuationScenarioReference = _valuationScenarioReference == null ? null : _valuationScenarioReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingInputType")
        @RuneAttribute(value="pricingInputType")
        public SensitivitySetDefinitionBuilder setPricingInputType(PricingInputType _pricingInputType) {
            this.pricingInputType = _pricingInputType == null ? null : _pricingInputType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingInputReference")
        @RuneAttribute(value="pricingInputReference")
        public SensitivitySetDefinitionBuilder setPricingInputReference(PricingStructureReference _pricingInputReference) {
            this.pricingInputReference = _pricingInputReference == null ? null : _pricingInputReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="scale")
        @RuneAttribute(value="scale")
        public SensitivitySetDefinitionBuilder setScale(BigDecimal _scale) {
            this.scale = _scale == null ? null : _scale;
            return this;
        }

        @Override
        @RosettaAttribute(value="sensitivityDefinition")
        @RuneAttribute(value="sensitivityDefinition")
        public SensitivitySetDefinitionBuilder addSensitivityDefinition(SensitivityDefinition _sensitivityDefinition) {
            if (_sensitivityDefinition != null) {
                this.sensitivityDefinition.add(_sensitivityDefinition.toBuilder());
            }
            return this;
        }

        @Override
        public SensitivitySetDefinitionBuilder addSensitivityDefinition(SensitivityDefinition _sensitivityDefinition, int idx) {
            this.getIndex(this.sensitivityDefinition, idx, () -> _sensitivityDefinition.toBuilder());
            return this;
        }

        @Override
        public SensitivitySetDefinitionBuilder addSensitivityDefinition(List<? extends SensitivityDefinition> sensitivityDefinitions) {
            if (sensitivityDefinitions != null) {
                for (SensitivityDefinition sensitivityDefinition : sensitivityDefinitions) {
                    this.sensitivityDefinition.add(sensitivityDefinition.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="sensitivityDefinition")
        public SensitivitySetDefinitionBuilder setSensitivityDefinition(List<? extends SensitivityDefinition> sensitivityDefinitions) {
            this.sensitivityDefinition = sensitivityDefinitions == null ? new ArrayList<SensitivityDefinition.SensitivityDefinitionBuilder>() : (List)sensitivityDefinitions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationProcedure")
        @RuneAttribute(value="calculationProcedure")
        public SensitivitySetDefinitionBuilder setCalculationProcedure(DerivativeCalculationProcedure _calculationProcedure) {
            this.calculationProcedure = _calculationProcedure == null ? null : _calculationProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SensitivitySetDefinitionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public SensitivitySetDefinition build() {
            return new SensitivitySetDefinitionImpl(this);
        }

        @Override
        public SensitivitySetDefinitionBuilder toBuilder() {
            return this;
        }

        @Override
        public SensitivitySetDefinitionBuilder prune() {
            if (this.sensitivityCharacteristics != null && !this.sensitivityCharacteristics.prune().hasData()) {
                this.sensitivityCharacteristics = null;
            }
            if (this.valuationScenarioReference != null && !this.valuationScenarioReference.prune().hasData()) {
                this.valuationScenarioReference = null;
            }
            if (this.pricingInputType != null && !this.pricingInputType.prune().hasData()) {
                this.pricingInputType = null;
            }
            if (this.pricingInputReference != null && !this.pricingInputReference.prune().hasData()) {
                this.pricingInputReference = null;
            }
            this.sensitivityDefinition = this.sensitivityDefinition.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.calculationProcedure != null && !this.calculationProcedure.prune().hasData()) {
                this.calculationProcedure = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getSensitivityCharacteristics() != null && this.getSensitivityCharacteristics().hasData()) {
                return true;
            }
            if (this.getValuationScenarioReference() != null && this.getValuationScenarioReference().hasData()) {
                return true;
            }
            if (this.getPricingInputType() != null && this.getPricingInputType().hasData()) {
                return true;
            }
            if (this.getPricingInputReference() != null && this.getPricingInputReference().hasData()) {
                return true;
            }
            if (this.getScale() != null) {
                return true;
            }
            if (this.getSensitivityDefinition() != null && this.getSensitivityDefinition().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCalculationProcedure() != null && this.getCalculationProcedure().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public SensitivitySetDefinitionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SensitivitySetDefinitionBuilder o = (SensitivitySetDefinitionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSensitivityCharacteristics(), (RosettaModelObjectBuilder)o.getSensitivityCharacteristics(), this::setSensitivityCharacteristics);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationScenarioReference(), (RosettaModelObjectBuilder)o.getValuationScenarioReference(), this::setValuationScenarioReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingInputType(), (RosettaModelObjectBuilder)o.getPricingInputType(), this::setPricingInputType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingInputReference(), (RosettaModelObjectBuilder)o.getPricingInputReference(), this::setPricingInputReference);
            merger.mergeRosetta(this.getSensitivityDefinition(), o.getSensitivityDefinition(), this::getOrCreateSensitivityDefinition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationProcedure(), (RosettaModelObjectBuilder)o.getCalculationProcedure(), this::setCalculationProcedure);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getScale(), (Object)o.getScale(), this::setScale, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SensitivitySetDefinition _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.sensitivityCharacteristics, _that.getSensitivityCharacteristics())) {
                return false;
            }
            if (!Objects.equals(this.valuationScenarioReference, _that.getValuationScenarioReference())) {
                return false;
            }
            if (!Objects.equals(this.pricingInputType, _that.getPricingInputType())) {
                return false;
            }
            if (!Objects.equals(this.pricingInputReference, _that.getPricingInputReference())) {
                return false;
            }
            if (!Objects.equals(this.scale, _that.getScale())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sensitivityDefinition, _that.getSensitivityDefinition())) {
                return false;
            }
            if (!Objects.equals(this.calculationProcedure, _that.getCalculationProcedure())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.sensitivityCharacteristics != null ? this.sensitivityCharacteristics.hashCode() : 0);
            _result = 31 * _result + (this.valuationScenarioReference != null ? this.valuationScenarioReference.hashCode() : 0);
            _result = 31 * _result + (this.pricingInputType != null ? this.pricingInputType.hashCode() : 0);
            _result = 31 * _result + (this.pricingInputReference != null ? this.pricingInputReference.hashCode() : 0);
            _result = 31 * _result + (this.scale != null ? this.scale.hashCode() : 0);
            _result = 31 * _result + (this.sensitivityDefinition != null ? this.sensitivityDefinition.hashCode() : 0);
            _result = 31 * _result + (this.calculationProcedure != null ? this.calculationProcedure.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SensitivitySetDefinitionBuilder {name=" + this.name + ", sensitivityCharacteristics=" + String.valueOf(this.sensitivityCharacteristics) + ", valuationScenarioReference=" + String.valueOf(this.valuationScenarioReference) + ", pricingInputType=" + String.valueOf(this.pricingInputType) + ", pricingInputReference=" + String.valueOf(this.pricingInputReference) + ", scale=" + String.valueOf(this.scale) + ", sensitivityDefinition=" + String.valueOf(this.sensitivityDefinition) + ", calculationProcedure=" + String.valueOf(this.calculationProcedure) + ", id=" + this.id + "}";
        }
    }

    public static interface SensitivitySetDefinitionBuilder
    extends SensitivitySetDefinition,
    RosettaModelObjectBuilder {
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getOrCreateSensitivityCharacteristics();

        @Override
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getSensitivityCharacteristics();

        public ValuationScenarioReference.ValuationScenarioReferenceBuilder getOrCreateValuationScenarioReference();

        @Override
        public ValuationScenarioReference.ValuationScenarioReferenceBuilder getValuationScenarioReference();

        public PricingInputType.PricingInputTypeBuilder getOrCreatePricingInputType();

        @Override
        public PricingInputType.PricingInputTypeBuilder getPricingInputType();

        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreatePricingInputReference();

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getPricingInputReference();

        public SensitivityDefinition.SensitivityDefinitionBuilder getOrCreateSensitivityDefinition(int var1);

        public List<? extends SensitivityDefinition.SensitivityDefinitionBuilder> getSensitivityDefinition();

        public DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder getOrCreateCalculationProcedure();

        @Override
        public DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder getCalculationProcedure();

        public SensitivitySetDefinitionBuilder setName(String var1);

        public SensitivitySetDefinitionBuilder setSensitivityCharacteristics(QuotationCharacteristics var1);

        public SensitivitySetDefinitionBuilder setValuationScenarioReference(ValuationScenarioReference var1);

        public SensitivitySetDefinitionBuilder setPricingInputType(PricingInputType var1);

        public SensitivitySetDefinitionBuilder setPricingInputReference(PricingStructureReference var1);

        public SensitivitySetDefinitionBuilder setScale(BigDecimal var1);

        public SensitivitySetDefinitionBuilder addSensitivityDefinition(SensitivityDefinition var1);

        public SensitivitySetDefinitionBuilder addSensitivityDefinition(SensitivityDefinition var1, int var2);

        public SensitivitySetDefinitionBuilder addSensitivityDefinition(List<? extends SensitivityDefinition> var1);

        public SensitivitySetDefinitionBuilder setSensitivityDefinition(List<? extends SensitivityDefinition> var1);

        public SensitivitySetDefinitionBuilder setCalculationProcedure(DerivativeCalculationProcedure var1);

        public SensitivitySetDefinitionBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sensitivityCharacteristics"), processor, QuotationCharacteristics.QuotationCharacteristicsBuilder.class, this.getSensitivityCharacteristics(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationScenarioReference"), processor, ValuationScenarioReference.ValuationScenarioReferenceBuilder.class, this.getValuationScenarioReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingInputType"), processor, PricingInputType.PricingInputTypeBuilder.class, this.getPricingInputType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingInputReference"), processor, PricingStructureReference.PricingStructureReferenceBuilder.class, this.getPricingInputReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("scale"), BigDecimal.class, (Object)this.getScale(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sensitivityDefinition"), processor, SensitivityDefinition.SensitivityDefinitionBuilder.class, this.getSensitivityDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationProcedure"), processor, DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder.class, this.getCalculationProcedure(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SensitivitySetDefinitionBuilder prune();
    }

    public static class SensitivitySetDefinitionImpl
    implements SensitivitySetDefinition {
        private final String name;
        private final QuotationCharacteristics sensitivityCharacteristics;
        private final ValuationScenarioReference valuationScenarioReference;
        private final PricingInputType pricingInputType;
        private final PricingStructureReference pricingInputReference;
        private final BigDecimal scale;
        private final List<? extends SensitivityDefinition> sensitivityDefinition;
        private final DerivativeCalculationProcedure calculationProcedure;
        private final String id;

        protected SensitivitySetDefinitionImpl(SensitivitySetDefinitionBuilder builder) {
            this.name = builder.getName();
            this.sensitivityCharacteristics = Optional.ofNullable(builder.getSensitivityCharacteristics()).map(f -> f.build()).orElse(null);
            this.valuationScenarioReference = Optional.ofNullable(builder.getValuationScenarioReference()).map(f -> f.build()).orElse(null);
            this.pricingInputType = Optional.ofNullable(builder.getPricingInputType()).map(f -> f.build()).orElse(null);
            this.pricingInputReference = Optional.ofNullable(builder.getPricingInputReference()).map(f -> f.build()).orElse(null);
            this.scale = builder.getScale();
            this.sensitivityDefinition = Optional.ofNullable(builder.getSensitivityDefinition()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.calculationProcedure = Optional.ofNullable(builder.getCalculationProcedure()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="sensitivityCharacteristics")
        @RuneAttribute(value="sensitivityCharacteristics")
        public QuotationCharacteristics getSensitivityCharacteristics() {
            return this.sensitivityCharacteristics;
        }

        @Override
        @RosettaAttribute(value="valuationScenarioReference")
        @RuneAttribute(value="valuationScenarioReference")
        public ValuationScenarioReference getValuationScenarioReference() {
            return this.valuationScenarioReference;
        }

        @Override
        @RosettaAttribute(value="pricingInputType")
        @RuneAttribute(value="pricingInputType")
        public PricingInputType getPricingInputType() {
            return this.pricingInputType;
        }

        @Override
        @RosettaAttribute(value="pricingInputReference")
        @RuneAttribute(value="pricingInputReference")
        public PricingStructureReference getPricingInputReference() {
            return this.pricingInputReference;
        }

        @Override
        @RosettaAttribute(value="scale")
        @RuneAttribute(value="scale")
        public BigDecimal getScale() {
            return this.scale;
        }

        @Override
        @RosettaAttribute(value="sensitivityDefinition")
        @RuneAttribute(value="sensitivityDefinition")
        public List<? extends SensitivityDefinition> getSensitivityDefinition() {
            return this.sensitivityDefinition;
        }

        @Override
        @RosettaAttribute(value="calculationProcedure")
        @RuneAttribute(value="calculationProcedure")
        public DerivativeCalculationProcedure getCalculationProcedure() {
            return this.calculationProcedure;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public SensitivitySetDefinition build() {
            return this;
        }

        @Override
        public SensitivitySetDefinitionBuilder toBuilder() {
            SensitivitySetDefinitionBuilder builder = SensitivitySetDefinition.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SensitivitySetDefinitionBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getSensitivityCharacteristics()).ifPresent(builder::setSensitivityCharacteristics);
            Optional.ofNullable(this.getValuationScenarioReference()).ifPresent(builder::setValuationScenarioReference);
            Optional.ofNullable(this.getPricingInputType()).ifPresent(builder::setPricingInputType);
            Optional.ofNullable(this.getPricingInputReference()).ifPresent(builder::setPricingInputReference);
            Optional.ofNullable(this.getScale()).ifPresent(builder::setScale);
            Optional.ofNullable(this.getSensitivityDefinition()).ifPresent(builder::setSensitivityDefinition);
            Optional.ofNullable(this.getCalculationProcedure()).ifPresent(builder::setCalculationProcedure);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SensitivitySetDefinition _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.sensitivityCharacteristics, _that.getSensitivityCharacteristics())) {
                return false;
            }
            if (!Objects.equals(this.valuationScenarioReference, _that.getValuationScenarioReference())) {
                return false;
            }
            if (!Objects.equals(this.pricingInputType, _that.getPricingInputType())) {
                return false;
            }
            if (!Objects.equals(this.pricingInputReference, _that.getPricingInputReference())) {
                return false;
            }
            if (!Objects.equals(this.scale, _that.getScale())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sensitivityDefinition, _that.getSensitivityDefinition())) {
                return false;
            }
            if (!Objects.equals(this.calculationProcedure, _that.getCalculationProcedure())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.sensitivityCharacteristics != null ? this.sensitivityCharacteristics.hashCode() : 0);
            _result = 31 * _result + (this.valuationScenarioReference != null ? this.valuationScenarioReference.hashCode() : 0);
            _result = 31 * _result + (this.pricingInputType != null ? this.pricingInputType.hashCode() : 0);
            _result = 31 * _result + (this.pricingInputReference != null ? this.pricingInputReference.hashCode() : 0);
            _result = 31 * _result + (this.scale != null ? this.scale.hashCode() : 0);
            _result = 31 * _result + (this.sensitivityDefinition != null ? this.sensitivityDefinition.hashCode() : 0);
            _result = 31 * _result + (this.calculationProcedure != null ? this.calculationProcedure.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SensitivitySetDefinition {name=" + this.name + ", sensitivityCharacteristics=" + String.valueOf(this.sensitivityCharacteristics) + ", valuationScenarioReference=" + String.valueOf(this.valuationScenarioReference) + ", pricingInputType=" + String.valueOf(this.pricingInputType) + ", pricingInputReference=" + String.valueOf(this.pricingInputReference) + ", scale=" + String.valueOf(this.scale) + ", sensitivityDefinition=" + String.valueOf(this.sensitivityDefinition) + ", calculationProcedure=" + String.valueOf(this.calculationProcedure) + ", id=" + this.id + "}";
        }
    }
}

