/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.riskdef;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.AssetReference;
import fpml.consolidated.riskdef.AssetOrTermPointOrPricingStructureReference;
import fpml.consolidated.riskdef.DerivativeCalculationProcedure;
import fpml.consolidated.riskdef.TermPointReference;
import fpml.consolidated.riskdef.ValuationReference;
import fpml.consolidated.riskdef.meta.PricingParameterDerivativeMeta;
import fpml.consolidated.shared.PricingStructureReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PricingParameterDerivative", builder=PricingParameterDerivativeBuilderImpl.class, version="1.2.2")
@RuneDataType(value="PricingParameterDerivative", model="fpml", builder=PricingParameterDerivativeBuilderImpl.class, version="1.2.2")
public interface PricingParameterDerivative
extends RosettaModelObject {
    public static final PricingParameterDerivativeMeta metaData = new PricingParameterDerivativeMeta();

    public String getDescription();

    public AssetOrTermPointOrPricingStructureReference getParameterReference();

    public AssetReference getAssetReference();

    public TermPointReference getTermPointReference();

    public PricingStructureReference getPricingStructureReference();

    public List<? extends ValuationReference> getInputDateReference();

    public DerivativeCalculationProcedure getCalculationProcedure();

    public String getId();

    public PricingParameterDerivative build();

    public PricingParameterDerivativeBuilder toBuilder();

    public static PricingParameterDerivativeBuilder builder() {
        return new PricingParameterDerivativeBuilderImpl();
    }

    default public RosettaMetaData<? extends PricingParameterDerivative> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PricingParameterDerivative> getType() {
        return PricingParameterDerivative.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("parameterReference"), processor, AssetOrTermPointOrPricingStructureReference.class, this.getParameterReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetReference"), processor, AssetReference.class, this.getAssetReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("termPointReference"), processor, TermPointReference.class, this.getTermPointReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricingStructureReference"), processor, PricingStructureReference.class, this.getPricingStructureReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("inputDateReference"), processor, ValuationReference.class, this.getInputDateReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationProcedure"), processor, DerivativeCalculationProcedure.class, this.getCalculationProcedure(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PricingParameterDerivativeBuilderImpl
    implements PricingParameterDerivativeBuilder {
        protected String description;
        protected AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder parameterReference;
        protected AssetReference.AssetReferenceBuilder assetReference;
        protected TermPointReference.TermPointReferenceBuilder termPointReference;
        protected PricingStructureReference.PricingStructureReferenceBuilder pricingStructureReference;
        protected List<ValuationReference.ValuationReferenceBuilder> inputDateReference = new ArrayList<ValuationReference.ValuationReferenceBuilder>();
        protected DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder calculationProcedure;
        protected String id;

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="parameterReference")
        @RuneAttribute(value="parameterReference")
        public AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder getParameterReference() {
            return this.parameterReference;
        }

        @Override
        public AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder getOrCreateParameterReference() {
            AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder result = this.parameterReference != null ? this.parameterReference : (this.parameterReference = AssetOrTermPointOrPricingStructureReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetReference")
        @RuneAttribute(value="assetReference")
        public AssetReference.AssetReferenceBuilder getAssetReference() {
            return this.assetReference;
        }

        @Override
        public AssetReference.AssetReferenceBuilder getOrCreateAssetReference() {
            AssetReference.AssetReferenceBuilder result = this.assetReference != null ? this.assetReference : (this.assetReference = AssetReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="termPointReference")
        @RuneAttribute(value="termPointReference")
        public TermPointReference.TermPointReferenceBuilder getTermPointReference() {
            return this.termPointReference;
        }

        @Override
        public TermPointReference.TermPointReferenceBuilder getOrCreateTermPointReference() {
            TermPointReference.TermPointReferenceBuilder result = this.termPointReference != null ? this.termPointReference : (this.termPointReference = TermPointReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="pricingStructureReference")
        @RuneAttribute(value="pricingStructureReference")
        public PricingStructureReference.PricingStructureReferenceBuilder getPricingStructureReference() {
            return this.pricingStructureReference;
        }

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreatePricingStructureReference() {
            PricingStructureReference.PricingStructureReferenceBuilder result = this.pricingStructureReference != null ? this.pricingStructureReference : (this.pricingStructureReference = PricingStructureReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="inputDateReference")
        @RuneAttribute(value="inputDateReference")
        public List<? extends ValuationReference.ValuationReferenceBuilder> getInputDateReference() {
            return this.inputDateReference;
        }

        @Override
        public ValuationReference.ValuationReferenceBuilder getOrCreateInputDateReference(int index) {
            if (this.inputDateReference == null) {
                this.inputDateReference = new ArrayList<ValuationReference.ValuationReferenceBuilder>();
            }
            return (ValuationReference.ValuationReferenceBuilder)this.getIndex(this.inputDateReference, index, () -> {
                ValuationReference.ValuationReferenceBuilder newInputDateReference = ValuationReference.builder();
                return newInputDateReference;
            });
        }

        @Override
        @RosettaAttribute(value="calculationProcedure")
        @RuneAttribute(value="calculationProcedure")
        public DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder getCalculationProcedure() {
            return this.calculationProcedure;
        }

        @Override
        public DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder getOrCreateCalculationProcedure() {
            DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder result = this.calculationProcedure != null ? this.calculationProcedure : (this.calculationProcedure = DerivativeCalculationProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public PricingParameterDerivativeBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="parameterReference")
        @RuneAttribute(value="parameterReference")
        public PricingParameterDerivativeBuilder setParameterReference(AssetOrTermPointOrPricingStructureReference _parameterReference) {
            this.parameterReference = _parameterReference == null ? null : _parameterReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetReference")
        @RuneAttribute(value="assetReference")
        public PricingParameterDerivativeBuilder setAssetReference(AssetReference _assetReference) {
            this.assetReference = _assetReference == null ? null : _assetReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="termPointReference")
        @RuneAttribute(value="termPointReference")
        public PricingParameterDerivativeBuilder setTermPointReference(TermPointReference _termPointReference) {
            this.termPointReference = _termPointReference == null ? null : _termPointReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="pricingStructureReference")
        @RuneAttribute(value="pricingStructureReference")
        public PricingParameterDerivativeBuilder setPricingStructureReference(PricingStructureReference _pricingStructureReference) {
            this.pricingStructureReference = _pricingStructureReference == null ? null : _pricingStructureReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="inputDateReference")
        @RuneAttribute(value="inputDateReference")
        public PricingParameterDerivativeBuilder addInputDateReference(ValuationReference _inputDateReference) {
            if (_inputDateReference != null) {
                this.inputDateReference.add(_inputDateReference.toBuilder());
            }
            return this;
        }

        @Override
        public PricingParameterDerivativeBuilder addInputDateReference(ValuationReference _inputDateReference, int idx) {
            this.getIndex(this.inputDateReference, idx, () -> _inputDateReference.toBuilder());
            return this;
        }

        @Override
        public PricingParameterDerivativeBuilder addInputDateReference(List<? extends ValuationReference> inputDateReferences) {
            if (inputDateReferences != null) {
                for (ValuationReference valuationReference : inputDateReferences) {
                    this.inputDateReference.add(valuationReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="inputDateReference")
        public PricingParameterDerivativeBuilder setInputDateReference(List<? extends ValuationReference> inputDateReferences) {
            this.inputDateReference = inputDateReferences == null ? new ArrayList<ValuationReference.ValuationReferenceBuilder>() : (List)inputDateReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationProcedure")
        @RuneAttribute(value="calculationProcedure")
        public PricingParameterDerivativeBuilder setCalculationProcedure(DerivativeCalculationProcedure _calculationProcedure) {
            this.calculationProcedure = _calculationProcedure == null ? null : _calculationProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PricingParameterDerivativeBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public PricingParameterDerivative build() {
            return new PricingParameterDerivativeImpl(this);
        }

        @Override
        public PricingParameterDerivativeBuilder toBuilder() {
            return this;
        }

        @Override
        public PricingParameterDerivativeBuilder prune() {
            if (this.parameterReference != null && !this.parameterReference.prune().hasData()) {
                this.parameterReference = null;
            }
            if (this.assetReference != null && !this.assetReference.prune().hasData()) {
                this.assetReference = null;
            }
            if (this.termPointReference != null && !this.termPointReference.prune().hasData()) {
                this.termPointReference = null;
            }
            if (this.pricingStructureReference != null && !this.pricingStructureReference.prune().hasData()) {
                this.pricingStructureReference = null;
            }
            this.inputDateReference = this.inputDateReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.calculationProcedure != null && !this.calculationProcedure.prune().hasData()) {
                this.calculationProcedure = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDescription() != null) {
                return true;
            }
            if (this.getParameterReference() != null && this.getParameterReference().hasData()) {
                return true;
            }
            if (this.getAssetReference() != null && this.getAssetReference().hasData()) {
                return true;
            }
            if (this.getTermPointReference() != null && this.getTermPointReference().hasData()) {
                return true;
            }
            if (this.getPricingStructureReference() != null && this.getPricingStructureReference().hasData()) {
                return true;
            }
            if (this.getInputDateReference() != null && this.getInputDateReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCalculationProcedure() != null && this.getCalculationProcedure().hasData()) {
                return true;
            }
            return this.getId() != null;
        }

        public PricingParameterDerivativeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PricingParameterDerivativeBuilder o = (PricingParameterDerivativeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getParameterReference(), (RosettaModelObjectBuilder)o.getParameterReference(), this::setParameterReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAssetReference(), (RosettaModelObjectBuilder)o.getAssetReference(), this::setAssetReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTermPointReference(), (RosettaModelObjectBuilder)o.getTermPointReference(), this::setTermPointReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricingStructureReference(), (RosettaModelObjectBuilder)o.getPricingStructureReference(), this::setPricingStructureReference);
            merger.mergeRosetta(this.getInputDateReference(), o.getInputDateReference(), this::getOrCreateInputDateReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationProcedure(), (RosettaModelObjectBuilder)o.getCalculationProcedure(), this::setCalculationProcedure);
            merger.mergeBasic((Object)this.getDescription(), (Object)o.getDescription(), this::setDescription, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PricingParameterDerivative _that = this.getType().cast(o);
            if (!Objects.equals(this.description, _that.getDescription())) {
                return false;
            }
            if (!Objects.equals(this.parameterReference, _that.getParameterReference())) {
                return false;
            }
            if (!Objects.equals(this.assetReference, _that.getAssetReference())) {
                return false;
            }
            if (!Objects.equals(this.termPointReference, _that.getTermPointReference())) {
                return false;
            }
            if (!Objects.equals(this.pricingStructureReference, _that.getPricingStructureReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.inputDateReference, _that.getInputDateReference())) {
                return false;
            }
            if (!Objects.equals(this.calculationProcedure, _that.getCalculationProcedure())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            _result = 31 * _result + (this.parameterReference != null ? this.parameterReference.hashCode() : 0);
            _result = 31 * _result + (this.assetReference != null ? this.assetReference.hashCode() : 0);
            _result = 31 * _result + (this.termPointReference != null ? this.termPointReference.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructureReference != null ? this.pricingStructureReference.hashCode() : 0);
            _result = 31 * _result + (this.inputDateReference != null ? this.inputDateReference.hashCode() : 0);
            _result = 31 * _result + (this.calculationProcedure != null ? this.calculationProcedure.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PricingParameterDerivativeBuilder {description=" + this.description + ", parameterReference=" + String.valueOf(this.parameterReference) + ", assetReference=" + String.valueOf(this.assetReference) + ", termPointReference=" + String.valueOf(this.termPointReference) + ", pricingStructureReference=" + String.valueOf(this.pricingStructureReference) + ", inputDateReference=" + String.valueOf(this.inputDateReference) + ", calculationProcedure=" + String.valueOf(this.calculationProcedure) + ", id=" + this.id + "}";
        }
    }

    public static interface PricingParameterDerivativeBuilder
    extends PricingParameterDerivative,
    RosettaModelObjectBuilder {
        public AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder getOrCreateParameterReference();

        @Override
        public AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder getParameterReference();

        public AssetReference.AssetReferenceBuilder getOrCreateAssetReference();

        @Override
        public AssetReference.AssetReferenceBuilder getAssetReference();

        public TermPointReference.TermPointReferenceBuilder getOrCreateTermPointReference();

        @Override
        public TermPointReference.TermPointReferenceBuilder getTermPointReference();

        public PricingStructureReference.PricingStructureReferenceBuilder getOrCreatePricingStructureReference();

        @Override
        public PricingStructureReference.PricingStructureReferenceBuilder getPricingStructureReference();

        public ValuationReference.ValuationReferenceBuilder getOrCreateInputDateReference(int var1);

        public List<? extends ValuationReference.ValuationReferenceBuilder> getInputDateReference();

        public DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder getOrCreateCalculationProcedure();

        @Override
        public DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder getCalculationProcedure();

        public PricingParameterDerivativeBuilder setDescription(String var1);

        public PricingParameterDerivativeBuilder setParameterReference(AssetOrTermPointOrPricingStructureReference var1);

        public PricingParameterDerivativeBuilder setAssetReference(AssetReference var1);

        public PricingParameterDerivativeBuilder setTermPointReference(TermPointReference var1);

        public PricingParameterDerivativeBuilder setPricingStructureReference(PricingStructureReference var1);

        public PricingParameterDerivativeBuilder addInputDateReference(ValuationReference var1);

        public PricingParameterDerivativeBuilder addInputDateReference(ValuationReference var1, int var2);

        public PricingParameterDerivativeBuilder addInputDateReference(List<? extends ValuationReference> var1);

        public PricingParameterDerivativeBuilder setInputDateReference(List<? extends ValuationReference> var1);

        public PricingParameterDerivativeBuilder setCalculationProcedure(DerivativeCalculationProcedure var1);

        public PricingParameterDerivativeBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("parameterReference"), processor, AssetOrTermPointOrPricingStructureReference.AssetOrTermPointOrPricingStructureReferenceBuilder.class, this.getParameterReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetReference"), processor, AssetReference.AssetReferenceBuilder.class, this.getAssetReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("termPointReference"), processor, TermPointReference.TermPointReferenceBuilder.class, this.getTermPointReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricingStructureReference"), processor, PricingStructureReference.PricingStructureReferenceBuilder.class, this.getPricingStructureReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("inputDateReference"), processor, ValuationReference.ValuationReferenceBuilder.class, this.getInputDateReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationProcedure"), processor, DerivativeCalculationProcedure.DerivativeCalculationProcedureBuilder.class, this.getCalculationProcedure(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PricingParameterDerivativeBuilder prune();
    }

    public static class PricingParameterDerivativeImpl
    implements PricingParameterDerivative {
        private final String description;
        private final AssetOrTermPointOrPricingStructureReference parameterReference;
        private final AssetReference assetReference;
        private final TermPointReference termPointReference;
        private final PricingStructureReference pricingStructureReference;
        private final List<? extends ValuationReference> inputDateReference;
        private final DerivativeCalculationProcedure calculationProcedure;
        private final String id;

        protected PricingParameterDerivativeImpl(PricingParameterDerivativeBuilder builder) {
            this.description = builder.getDescription();
            this.parameterReference = Optional.ofNullable(builder.getParameterReference()).map(f -> f.build()).orElse(null);
            this.assetReference = Optional.ofNullable(builder.getAssetReference()).map(f -> f.build()).orElse(null);
            this.termPointReference = Optional.ofNullable(builder.getTermPointReference()).map(f -> f.build()).orElse(null);
            this.pricingStructureReference = Optional.ofNullable(builder.getPricingStructureReference()).map(f -> f.build()).orElse(null);
            this.inputDateReference = Optional.ofNullable(builder.getInputDateReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.calculationProcedure = Optional.ofNullable(builder.getCalculationProcedure()).map(f -> f.build()).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public String getDescription() {
            return this.description;
        }

        @Override
        @RosettaAttribute(value="parameterReference")
        @RuneAttribute(value="parameterReference")
        public AssetOrTermPointOrPricingStructureReference getParameterReference() {
            return this.parameterReference;
        }

        @Override
        @RosettaAttribute(value="assetReference")
        @RuneAttribute(value="assetReference")
        public AssetReference getAssetReference() {
            return this.assetReference;
        }

        @Override
        @RosettaAttribute(value="termPointReference")
        @RuneAttribute(value="termPointReference")
        public TermPointReference getTermPointReference() {
            return this.termPointReference;
        }

        @Override
        @RosettaAttribute(value="pricingStructureReference")
        @RuneAttribute(value="pricingStructureReference")
        public PricingStructureReference getPricingStructureReference() {
            return this.pricingStructureReference;
        }

        @Override
        @RosettaAttribute(value="inputDateReference")
        @RuneAttribute(value="inputDateReference")
        public List<? extends ValuationReference> getInputDateReference() {
            return this.inputDateReference;
        }

        @Override
        @RosettaAttribute(value="calculationProcedure")
        @RuneAttribute(value="calculationProcedure")
        public DerivativeCalculationProcedure getCalculationProcedure() {
            return this.calculationProcedure;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public PricingParameterDerivative build() {
            return this;
        }

        @Override
        public PricingParameterDerivativeBuilder toBuilder() {
            PricingParameterDerivativeBuilder builder = PricingParameterDerivative.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PricingParameterDerivativeBuilder builder) {
            Optional.ofNullable(this.getDescription()).ifPresent(builder::setDescription);
            Optional.ofNullable(this.getParameterReference()).ifPresent(builder::setParameterReference);
            Optional.ofNullable(this.getAssetReference()).ifPresent(builder::setAssetReference);
            Optional.ofNullable(this.getTermPointReference()).ifPresent(builder::setTermPointReference);
            Optional.ofNullable(this.getPricingStructureReference()).ifPresent(builder::setPricingStructureReference);
            Optional.ofNullable(this.getInputDateReference()).ifPresent(builder::setInputDateReference);
            Optional.ofNullable(this.getCalculationProcedure()).ifPresent(builder::setCalculationProcedure);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PricingParameterDerivative _that = this.getType().cast(o);
            if (!Objects.equals(this.description, _that.getDescription())) {
                return false;
            }
            if (!Objects.equals(this.parameterReference, _that.getParameterReference())) {
                return false;
            }
            if (!Objects.equals(this.assetReference, _that.getAssetReference())) {
                return false;
            }
            if (!Objects.equals(this.termPointReference, _that.getTermPointReference())) {
                return false;
            }
            if (!Objects.equals(this.pricingStructureReference, _that.getPricingStructureReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.inputDateReference, _that.getInputDateReference())) {
                return false;
            }
            if (!Objects.equals(this.calculationProcedure, _that.getCalculationProcedure())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.description != null ? this.description.hashCode() : 0);
            _result = 31 * _result + (this.parameterReference != null ? this.parameterReference.hashCode() : 0);
            _result = 31 * _result + (this.assetReference != null ? this.assetReference.hashCode() : 0);
            _result = 31 * _result + (this.termPointReference != null ? this.termPointReference.hashCode() : 0);
            _result = 31 * _result + (this.pricingStructureReference != null ? this.pricingStructureReference.hashCode() : 0);
            _result = 31 * _result + (this.inputDateReference != null ? this.inputDateReference.hashCode() : 0);
            _result = 31 * _result + (this.calculationProcedure != null ? this.calculationProcedure.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PricingParameterDerivative {description=" + this.description + ", parameterReference=" + String.valueOf(this.parameterReference) + ", assetReference=" + String.valueOf(this.assetReference) + ", termPointReference=" + String.valueOf(this.termPointReference) + ", pricingStructureReference=" + String.valueOf(this.pricingStructureReference) + ", inputDateReference=" + String.valueOf(this.inputDateReference) + ", calculationProcedure=" + String.valueOf(this.calculationProcedure) + ", id=" + this.id + "}";
        }
    }
}

