/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.riskdef;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.riskdef.PricingParameterDerivativeReference;
import fpml.consolidated.riskdef.meta.FormulaTermMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FormulaTerm", builder=FormulaTermBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FormulaTerm", model="fpml", builder=FormulaTermBuilderImpl.class, version="1.2.2")
public interface FormulaTerm
extends RosettaModelObject {
    public static final FormulaTermMeta metaData = new FormulaTermMeta();

    public BigDecimal getCoefficient();

    public List<? extends PricingParameterDerivativeReference> getPartialDerivativeReference();

    public FormulaTerm build();

    public FormulaTermBuilder toBuilder();

    public static FormulaTermBuilder builder() {
        return new FormulaTermBuilderImpl();
    }

    default public RosettaMetaData<? extends FormulaTerm> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FormulaTerm> getType() {
        return FormulaTerm.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("coefficient"), BigDecimal.class, (Object)this.getCoefficient(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partialDerivativeReference"), processor, PricingParameterDerivativeReference.class, this.getPartialDerivativeReference(), new AttributeMeta[0]);
    }

    public static class FormulaTermBuilderImpl
    implements FormulaTermBuilder {
        protected BigDecimal coefficient;
        protected List<PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder> partialDerivativeReference = new ArrayList<PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder>();

        @Override
        @RosettaAttribute(value="coefficient")
        @RuneAttribute(value="coefficient")
        public BigDecimal getCoefficient() {
            return this.coefficient;
        }

        @Override
        @RosettaAttribute(value="partialDerivativeReference")
        @RuneAttribute(value="partialDerivativeReference")
        public List<? extends PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder> getPartialDerivativeReference() {
            return this.partialDerivativeReference;
        }

        @Override
        public PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder getOrCreatePartialDerivativeReference(int index) {
            if (this.partialDerivativeReference == null) {
                this.partialDerivativeReference = new ArrayList<PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder>();
            }
            return (PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder)this.getIndex(this.partialDerivativeReference, index, () -> {
                PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder newPartialDerivativeReference = PricingParameterDerivativeReference.builder();
                return newPartialDerivativeReference;
            });
        }

        @Override
        @RosettaAttribute(value="coefficient")
        @RuneAttribute(value="coefficient")
        public FormulaTermBuilder setCoefficient(BigDecimal _coefficient) {
            this.coefficient = _coefficient == null ? null : _coefficient;
            return this;
        }

        @Override
        @RosettaAttribute(value="partialDerivativeReference")
        @RuneAttribute(value="partialDerivativeReference")
        public FormulaTermBuilder addPartialDerivativeReference(PricingParameterDerivativeReference _partialDerivativeReference) {
            if (_partialDerivativeReference != null) {
                this.partialDerivativeReference.add(_partialDerivativeReference.toBuilder());
            }
            return this;
        }

        @Override
        public FormulaTermBuilder addPartialDerivativeReference(PricingParameterDerivativeReference _partialDerivativeReference, int idx) {
            this.getIndex(this.partialDerivativeReference, idx, () -> _partialDerivativeReference.toBuilder());
            return this;
        }

        @Override
        public FormulaTermBuilder addPartialDerivativeReference(List<? extends PricingParameterDerivativeReference> partialDerivativeReferences) {
            if (partialDerivativeReferences != null) {
                for (PricingParameterDerivativeReference pricingParameterDerivativeReference : partialDerivativeReferences) {
                    this.partialDerivativeReference.add(pricingParameterDerivativeReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partialDerivativeReference")
        public FormulaTermBuilder setPartialDerivativeReference(List<? extends PricingParameterDerivativeReference> partialDerivativeReferences) {
            this.partialDerivativeReference = partialDerivativeReferences == null ? new ArrayList<PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder>() : (List)partialDerivativeReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FormulaTerm build() {
            return new FormulaTermImpl(this);
        }

        @Override
        public FormulaTermBuilder toBuilder() {
            return this;
        }

        @Override
        public FormulaTermBuilder prune() {
            this.partialDerivativeReference = this.partialDerivativeReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCoefficient() != null) {
                return true;
            }
            return this.getPartialDerivativeReference() != null && this.getPartialDerivativeReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FormulaTermBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FormulaTermBuilder o = (FormulaTermBuilder)other;
            merger.mergeRosetta(this.getPartialDerivativeReference(), o.getPartialDerivativeReference(), this::getOrCreatePartialDerivativeReference);
            merger.mergeBasic((Object)this.getCoefficient(), (Object)o.getCoefficient(), this::setCoefficient, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FormulaTerm _that = this.getType().cast(o);
            if (!Objects.equals(this.coefficient, _that.getCoefficient())) {
                return false;
            }
            return ListEquals.listEquals(this.partialDerivativeReference, _that.getPartialDerivativeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.coefficient != null ? this.coefficient.hashCode() : 0);
            _result = 31 * _result + (this.partialDerivativeReference != null ? this.partialDerivativeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FormulaTermBuilder {coefficient=" + String.valueOf(this.coefficient) + ", partialDerivativeReference=" + String.valueOf(this.partialDerivativeReference) + "}";
        }
    }

    public static interface FormulaTermBuilder
    extends FormulaTerm,
    RosettaModelObjectBuilder {
        public PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder getOrCreatePartialDerivativeReference(int var1);

        public List<? extends PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder> getPartialDerivativeReference();

        public FormulaTermBuilder setCoefficient(BigDecimal var1);

        public FormulaTermBuilder addPartialDerivativeReference(PricingParameterDerivativeReference var1);

        public FormulaTermBuilder addPartialDerivativeReference(PricingParameterDerivativeReference var1, int var2);

        public FormulaTermBuilder addPartialDerivativeReference(List<? extends PricingParameterDerivativeReference> var1);

        public FormulaTermBuilder setPartialDerivativeReference(List<? extends PricingParameterDerivativeReference> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("coefficient"), BigDecimal.class, (Object)this.getCoefficient(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partialDerivativeReference"), processor, PricingParameterDerivativeReference.PricingParameterDerivativeReferenceBuilder.class, this.getPartialDerivativeReference(), new AttributeMeta[0]);
        }

        public FormulaTermBuilder prune();
    }

    public static class FormulaTermImpl
    implements FormulaTerm {
        private final BigDecimal coefficient;
        private final List<? extends PricingParameterDerivativeReference> partialDerivativeReference;

        protected FormulaTermImpl(FormulaTermBuilder builder) {
            this.coefficient = builder.getCoefficient();
            this.partialDerivativeReference = Optional.ofNullable(builder.getPartialDerivativeReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="coefficient")
        @RuneAttribute(value="coefficient")
        public BigDecimal getCoefficient() {
            return this.coefficient;
        }

        @Override
        @RosettaAttribute(value="partialDerivativeReference")
        @RuneAttribute(value="partialDerivativeReference")
        public List<? extends PricingParameterDerivativeReference> getPartialDerivativeReference() {
            return this.partialDerivativeReference;
        }

        @Override
        public FormulaTerm build() {
            return this;
        }

        @Override
        public FormulaTermBuilder toBuilder() {
            FormulaTermBuilder builder = FormulaTerm.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FormulaTermBuilder builder) {
            Optional.ofNullable(this.getCoefficient()).ifPresent(builder::setCoefficient);
            Optional.ofNullable(this.getPartialDerivativeReference()).ifPresent(builder::setPartialDerivativeReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FormulaTerm _that = this.getType().cast(o);
            if (!Objects.equals(this.coefficient, _that.getCoefficient())) {
                return false;
            }
            return ListEquals.listEquals(this.partialDerivativeReference, _that.getPartialDerivativeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.coefficient != null ? this.coefficient.hashCode() : 0);
            _result = 31 * _result + (this.partialDerivativeReference != null ? this.partialDerivativeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FormulaTerm {coefficient=" + String.valueOf(this.coefficient) + ", partialDerivativeReference=" + String.valueOf(this.partialDerivativeReference) + "}";
        }
    }
}

