/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.repo;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.CallingPartyEnum;
import fpml.consolidated.repo.meta.RepoSequenceSequenceMeta;
import fpml.consolidated.shared.AdjustableDate;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RepoSequenceSequence", builder=RepoSequenceSequenceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RepoSequenceSequence", model="fpml", builder=RepoSequenceSequenceBuilderImpl.class, version="1.2.2")
public interface RepoSequenceSequence
extends RosettaModelObject {
    public static final RepoSequenceSequenceMeta metaData = new RepoSequenceSequenceMeta();

    public CallingPartyEnum getCallingParty();

    public AdjustableDate getEarliestCallDate();

    public AdjustableOrRelativeDate getCallDate();

    public RepoSequenceSequence build();

    public RepoSequenceSequenceBuilder toBuilder();

    public static RepoSequenceSequenceBuilder builder() {
        return new RepoSequenceSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends RepoSequenceSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RepoSequenceSequence> getType() {
        return RepoSequenceSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("callingParty"), CallingPartyEnum.class, (Object)this.getCallingParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earliestCallDate"), processor, AdjustableDate.class, this.getEarliestCallDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callDate"), processor, AdjustableOrRelativeDate.class, this.getCallDate(), new AttributeMeta[0]);
    }

    public static class RepoSequenceSequenceBuilderImpl
    implements RepoSequenceSequenceBuilder {
        protected CallingPartyEnum callingParty;
        protected AdjustableDate.AdjustableDateBuilder earliestCallDate;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder callDate;

        @Override
        @RosettaAttribute(value="callingParty", isRequired=true)
        @RuneAttribute(value="callingParty", isRequired=true)
        public CallingPartyEnum getCallingParty() {
            return this.callingParty;
        }

        @Override
        @RosettaAttribute(value="earliestCallDate")
        @RuneAttribute(value="earliestCallDate")
        public AdjustableDate.AdjustableDateBuilder getEarliestCallDate() {
            return this.earliestCallDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreateEarliestCallDate() {
            AdjustableDate.AdjustableDateBuilder result = this.earliestCallDate != null ? this.earliestCallDate : (this.earliestCallDate = AdjustableDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="callDate")
        @RuneAttribute(value="callDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getCallDate() {
            return this.callDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateCallDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.callDate != null ? this.callDate : (this.callDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="callingParty", isRequired=true)
        @RuneAttribute(value="callingParty", isRequired=true)
        public RepoSequenceSequenceBuilder setCallingParty(CallingPartyEnum _callingParty) {
            this.callingParty = _callingParty == null ? null : _callingParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="earliestCallDate")
        @RuneAttribute(value="earliestCallDate")
        public RepoSequenceSequenceBuilder setEarliestCallDate(AdjustableDate _earliestCallDate) {
            this.earliestCallDate = _earliestCallDate == null ? null : _earliestCallDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callDate")
        @RuneAttribute(value="callDate")
        public RepoSequenceSequenceBuilder setCallDate(AdjustableOrRelativeDate _callDate) {
            this.callDate = _callDate == null ? null : _callDate.toBuilder();
            return this;
        }

        @Override
        public RepoSequenceSequence build() {
            return new RepoSequenceSequenceImpl(this);
        }

        @Override
        public RepoSequenceSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public RepoSequenceSequenceBuilder prune() {
            if (this.earliestCallDate != null && !this.earliestCallDate.prune().hasData()) {
                this.earliestCallDate = null;
            }
            if (this.callDate != null && !this.callDate.prune().hasData()) {
                this.callDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCallingParty() != null) {
                return true;
            }
            if (this.getEarliestCallDate() != null && this.getEarliestCallDate().hasData()) {
                return true;
            }
            return this.getCallDate() != null && this.getCallDate().hasData();
        }

        public RepoSequenceSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RepoSequenceSequenceBuilder o = (RepoSequenceSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarliestCallDate(), (RosettaModelObjectBuilder)o.getEarliestCallDate(), this::setEarliestCallDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallDate(), (RosettaModelObjectBuilder)o.getCallDate(), this::setCallDate);
            merger.mergeBasic((Object)this.getCallingParty(), (Object)o.getCallingParty(), this::setCallingParty, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RepoSequenceSequence _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.callingParty, (Object)_that.getCallingParty())) {
                return false;
            }
            if (!Objects.equals(this.earliestCallDate, _that.getEarliestCallDate())) {
                return false;
            }
            return Objects.equals(this.callDate, _that.getCallDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.callingParty != null ? ((Object)((Object)this.callingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.earliestCallDate != null ? this.earliestCallDate.hashCode() : 0);
            _result = 31 * _result + (this.callDate != null ? this.callDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepoSequenceSequenceBuilder {callingParty=" + String.valueOf((Object)this.callingParty) + ", earliestCallDate=" + String.valueOf(this.earliestCallDate) + ", callDate=" + String.valueOf(this.callDate) + "}";
        }
    }

    public static interface RepoSequenceSequenceBuilder
    extends RepoSequenceSequence,
    RosettaModelObjectBuilder {
        public AdjustableDate.AdjustableDateBuilder getOrCreateEarliestCallDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getEarliestCallDate();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateCallDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getCallDate();

        public RepoSequenceSequenceBuilder setCallingParty(CallingPartyEnum var1);

        public RepoSequenceSequenceBuilder setEarliestCallDate(AdjustableDate var1);

        public RepoSequenceSequenceBuilder setCallDate(AdjustableOrRelativeDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("callingParty"), CallingPartyEnum.class, (Object)this.getCallingParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earliestCallDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getEarliestCallDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getCallDate(), new AttributeMeta[0]);
        }

        public RepoSequenceSequenceBuilder prune();
    }

    public static class RepoSequenceSequenceImpl
    implements RepoSequenceSequence {
        private final CallingPartyEnum callingParty;
        private final AdjustableDate earliestCallDate;
        private final AdjustableOrRelativeDate callDate;

        protected RepoSequenceSequenceImpl(RepoSequenceSequenceBuilder builder) {
            this.callingParty = builder.getCallingParty();
            this.earliestCallDate = Optional.ofNullable(builder.getEarliestCallDate()).map(f -> f.build()).orElse(null);
            this.callDate = Optional.ofNullable(builder.getCallDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="callingParty", isRequired=true)
        @RuneAttribute(value="callingParty", isRequired=true)
        public CallingPartyEnum getCallingParty() {
            return this.callingParty;
        }

        @Override
        @RosettaAttribute(value="earliestCallDate")
        @RuneAttribute(value="earliestCallDate")
        public AdjustableDate getEarliestCallDate() {
            return this.earliestCallDate;
        }

        @Override
        @RosettaAttribute(value="callDate")
        @RuneAttribute(value="callDate")
        public AdjustableOrRelativeDate getCallDate() {
            return this.callDate;
        }

        @Override
        public RepoSequenceSequence build() {
            return this;
        }

        @Override
        public RepoSequenceSequenceBuilder toBuilder() {
            RepoSequenceSequenceBuilder builder = RepoSequenceSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RepoSequenceSequenceBuilder builder) {
            Optional.ofNullable(this.getCallingParty()).ifPresent(builder::setCallingParty);
            Optional.ofNullable(this.getEarliestCallDate()).ifPresent(builder::setEarliestCallDate);
            Optional.ofNullable(this.getCallDate()).ifPresent(builder::setCallDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RepoSequenceSequence _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.callingParty, (Object)_that.getCallingParty())) {
                return false;
            }
            if (!Objects.equals(this.earliestCallDate, _that.getEarliestCallDate())) {
                return false;
            }
            return Objects.equals(this.callDate, _that.getCallDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.callingParty != null ? ((Object)((Object)this.callingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.earliestCallDate != null ? this.earliestCallDate.hashCode() : 0);
            _result = 31 * _result + (this.callDate != null ? this.callDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepoSequenceSequence {callingParty=" + String.valueOf((Object)this.callingParty) + ", earliestCallDate=" + String.valueOf(this.earliestCallDate) + ", callDate=" + String.valueOf(this.callDate) + "}";
        }
    }
}

