/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.repo;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.CallingPartyEnum;
import fpml.consolidated.repo.AdjustableOffset;
import fpml.consolidated.repo.PartyNoticePeriod;
import fpml.consolidated.repo.meta.RepoSequence1Meta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RepoSequence1", builder=RepoSequence1BuilderImpl.class, version="1.2.2")
@RuneDataType(value="RepoSequence1", model="fpml", builder=RepoSequence1BuilderImpl.class, version="1.2.2")
public interface RepoSequence1
extends RosettaModelObject {
    public static final RepoSequence1Meta metaData = new RepoSequence1Meta();

    public CallingPartyEnum getCallingParty();

    public AdjustableOrRelativeDate getCallDate();

    public AdjustableOffset getNoticePeriod();

    public List<? extends PartyNoticePeriod> getPartyNoticePeriod();

    public RepoSequence1 build();

    public RepoSequence1Builder toBuilder();

    public static RepoSequence1Builder builder() {
        return new RepoSequence1BuilderImpl();
    }

    default public RosettaMetaData<? extends RepoSequence1> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RepoSequence1> getType() {
        return RepoSequence1.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("callingParty"), CallingPartyEnum.class, (Object)this.getCallingParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callDate"), processor, AdjustableOrRelativeDate.class, this.getCallDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("noticePeriod"), processor, AdjustableOffset.class, this.getNoticePeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyNoticePeriod"), processor, PartyNoticePeriod.class, this.getPartyNoticePeriod(), new AttributeMeta[0]);
    }

    public static class RepoSequence1BuilderImpl
    implements RepoSequence1Builder {
        protected CallingPartyEnum callingParty;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder callDate;
        protected AdjustableOffset.AdjustableOffsetBuilder noticePeriod;
        protected List<PartyNoticePeriod.PartyNoticePeriodBuilder> partyNoticePeriod = new ArrayList<PartyNoticePeriod.PartyNoticePeriodBuilder>();

        @Override
        @RosettaAttribute(value="callingParty", isRequired=true)
        @RuneAttribute(value="callingParty", isRequired=true)
        public CallingPartyEnum getCallingParty() {
            return this.callingParty;
        }

        @Override
        @RosettaAttribute(value="callDate")
        @RuneAttribute(value="callDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getCallDate() {
            return this.callDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateCallDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.callDate != null ? this.callDate : (this.callDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="noticePeriod")
        @RuneAttribute(value="noticePeriod")
        public AdjustableOffset.AdjustableOffsetBuilder getNoticePeriod() {
            return this.noticePeriod;
        }

        @Override
        public AdjustableOffset.AdjustableOffsetBuilder getOrCreateNoticePeriod() {
            AdjustableOffset.AdjustableOffsetBuilder result = this.noticePeriod != null ? this.noticePeriod : (this.noticePeriod = AdjustableOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyNoticePeriod")
        @RuneAttribute(value="partyNoticePeriod")
        public List<? extends PartyNoticePeriod.PartyNoticePeriodBuilder> getPartyNoticePeriod() {
            return this.partyNoticePeriod;
        }

        @Override
        public PartyNoticePeriod.PartyNoticePeriodBuilder getOrCreatePartyNoticePeriod(int index) {
            if (this.partyNoticePeriod == null) {
                this.partyNoticePeriod = new ArrayList<PartyNoticePeriod.PartyNoticePeriodBuilder>();
            }
            return (PartyNoticePeriod.PartyNoticePeriodBuilder)this.getIndex(this.partyNoticePeriod, index, () -> {
                PartyNoticePeriod.PartyNoticePeriodBuilder newPartyNoticePeriod = PartyNoticePeriod.builder();
                return newPartyNoticePeriod;
            });
        }

        @Override
        @RosettaAttribute(value="callingParty", isRequired=true)
        @RuneAttribute(value="callingParty", isRequired=true)
        public RepoSequence1Builder setCallingParty(CallingPartyEnum _callingParty) {
            this.callingParty = _callingParty == null ? null : _callingParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="callDate")
        @RuneAttribute(value="callDate")
        public RepoSequence1Builder setCallDate(AdjustableOrRelativeDate _callDate) {
            this.callDate = _callDate == null ? null : _callDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticePeriod")
        @RuneAttribute(value="noticePeriod")
        public RepoSequence1Builder setNoticePeriod(AdjustableOffset _noticePeriod) {
            this.noticePeriod = _noticePeriod == null ? null : _noticePeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyNoticePeriod")
        @RuneAttribute(value="partyNoticePeriod")
        public RepoSequence1Builder addPartyNoticePeriod(PartyNoticePeriod _partyNoticePeriod) {
            if (_partyNoticePeriod != null) {
                this.partyNoticePeriod.add(_partyNoticePeriod.toBuilder());
            }
            return this;
        }

        @Override
        public RepoSequence1Builder addPartyNoticePeriod(PartyNoticePeriod _partyNoticePeriod, int idx) {
            this.getIndex(this.partyNoticePeriod, idx, () -> _partyNoticePeriod.toBuilder());
            return this;
        }

        @Override
        public RepoSequence1Builder addPartyNoticePeriod(List<? extends PartyNoticePeriod> partyNoticePeriods) {
            if (partyNoticePeriods != null) {
                for (PartyNoticePeriod partyNoticePeriod : partyNoticePeriods) {
                    this.partyNoticePeriod.add(partyNoticePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyNoticePeriod")
        public RepoSequence1Builder setPartyNoticePeriod(List<? extends PartyNoticePeriod> partyNoticePeriods) {
            this.partyNoticePeriod = partyNoticePeriods == null ? new ArrayList<PartyNoticePeriod.PartyNoticePeriodBuilder>() : (List)partyNoticePeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RepoSequence1 build() {
            return new RepoSequence1Impl(this);
        }

        @Override
        public RepoSequence1Builder toBuilder() {
            return this;
        }

        @Override
        public RepoSequence1Builder prune() {
            if (this.callDate != null && !this.callDate.prune().hasData()) {
                this.callDate = null;
            }
            if (this.noticePeriod != null && !this.noticePeriod.prune().hasData()) {
                this.noticePeriod = null;
            }
            this.partyNoticePeriod = this.partyNoticePeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCallingParty() != null) {
                return true;
            }
            if (this.getCallDate() != null && this.getCallDate().hasData()) {
                return true;
            }
            if (this.getNoticePeriod() != null && this.getNoticePeriod().hasData()) {
                return true;
            }
            return this.getPartyNoticePeriod() != null && this.getPartyNoticePeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public RepoSequence1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RepoSequence1Builder o = (RepoSequence1Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallDate(), (RosettaModelObjectBuilder)o.getCallDate(), this::setCallDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNoticePeriod(), (RosettaModelObjectBuilder)o.getNoticePeriod(), this::setNoticePeriod);
            merger.mergeRosetta(this.getPartyNoticePeriod(), o.getPartyNoticePeriod(), this::getOrCreatePartyNoticePeriod);
            merger.mergeBasic((Object)this.getCallingParty(), (Object)o.getCallingParty(), this::setCallingParty, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RepoSequence1 _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.callingParty, (Object)_that.getCallingParty())) {
                return false;
            }
            if (!Objects.equals(this.callDate, _that.getCallDate())) {
                return false;
            }
            if (!Objects.equals(this.noticePeriod, _that.getNoticePeriod())) {
                return false;
            }
            return ListEquals.listEquals(this.partyNoticePeriod, _that.getPartyNoticePeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.callingParty != null ? ((Object)((Object)this.callingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.callDate != null ? this.callDate.hashCode() : 0);
            _result = 31 * _result + (this.noticePeriod != null ? this.noticePeriod.hashCode() : 0);
            _result = 31 * _result + (this.partyNoticePeriod != null ? this.partyNoticePeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepoSequence1Builder {callingParty=" + String.valueOf((Object)this.callingParty) + ", callDate=" + String.valueOf(this.callDate) + ", noticePeriod=" + String.valueOf(this.noticePeriod) + ", partyNoticePeriod=" + String.valueOf(this.partyNoticePeriod) + "}";
        }
    }

    public static interface RepoSequence1Builder
    extends RepoSequence1,
    RosettaModelObjectBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateCallDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getCallDate();

        public AdjustableOffset.AdjustableOffsetBuilder getOrCreateNoticePeriod();

        @Override
        public AdjustableOffset.AdjustableOffsetBuilder getNoticePeriod();

        public PartyNoticePeriod.PartyNoticePeriodBuilder getOrCreatePartyNoticePeriod(int var1);

        public List<? extends PartyNoticePeriod.PartyNoticePeriodBuilder> getPartyNoticePeriod();

        public RepoSequence1Builder setCallingParty(CallingPartyEnum var1);

        public RepoSequence1Builder setCallDate(AdjustableOrRelativeDate var1);

        public RepoSequence1Builder setNoticePeriod(AdjustableOffset var1);

        public RepoSequence1Builder addPartyNoticePeriod(PartyNoticePeriod var1);

        public RepoSequence1Builder addPartyNoticePeriod(PartyNoticePeriod var1, int var2);

        public RepoSequence1Builder addPartyNoticePeriod(List<? extends PartyNoticePeriod> var1);

        public RepoSequence1Builder setPartyNoticePeriod(List<? extends PartyNoticePeriod> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("callingParty"), CallingPartyEnum.class, (Object)this.getCallingParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getCallDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("noticePeriod"), processor, AdjustableOffset.AdjustableOffsetBuilder.class, this.getNoticePeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyNoticePeriod"), processor, PartyNoticePeriod.PartyNoticePeriodBuilder.class, this.getPartyNoticePeriod(), new AttributeMeta[0]);
        }

        public RepoSequence1Builder prune();
    }

    public static class RepoSequence1Impl
    implements RepoSequence1 {
        private final CallingPartyEnum callingParty;
        private final AdjustableOrRelativeDate callDate;
        private final AdjustableOffset noticePeriod;
        private final List<? extends PartyNoticePeriod> partyNoticePeriod;

        protected RepoSequence1Impl(RepoSequence1Builder builder) {
            this.callingParty = builder.getCallingParty();
            this.callDate = Optional.ofNullable(builder.getCallDate()).map(f -> f.build()).orElse(null);
            this.noticePeriod = Optional.ofNullable(builder.getNoticePeriod()).map(f -> f.build()).orElse(null);
            this.partyNoticePeriod = Optional.ofNullable(builder.getPartyNoticePeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="callingParty", isRequired=true)
        @RuneAttribute(value="callingParty", isRequired=true)
        public CallingPartyEnum getCallingParty() {
            return this.callingParty;
        }

        @Override
        @RosettaAttribute(value="callDate")
        @RuneAttribute(value="callDate")
        public AdjustableOrRelativeDate getCallDate() {
            return this.callDate;
        }

        @Override
        @RosettaAttribute(value="noticePeriod")
        @RuneAttribute(value="noticePeriod")
        public AdjustableOffset getNoticePeriod() {
            return this.noticePeriod;
        }

        @Override
        @RosettaAttribute(value="partyNoticePeriod")
        @RuneAttribute(value="partyNoticePeriod")
        public List<? extends PartyNoticePeriod> getPartyNoticePeriod() {
            return this.partyNoticePeriod;
        }

        @Override
        public RepoSequence1 build() {
            return this;
        }

        @Override
        public RepoSequence1Builder toBuilder() {
            RepoSequence1Builder builder = RepoSequence1.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RepoSequence1Builder builder) {
            Optional.ofNullable(this.getCallingParty()).ifPresent(builder::setCallingParty);
            Optional.ofNullable(this.getCallDate()).ifPresent(builder::setCallDate);
            Optional.ofNullable(this.getNoticePeriod()).ifPresent(builder::setNoticePeriod);
            Optional.ofNullable(this.getPartyNoticePeriod()).ifPresent(builder::setPartyNoticePeriod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RepoSequence1 _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.callingParty, (Object)_that.getCallingParty())) {
                return false;
            }
            if (!Objects.equals(this.callDate, _that.getCallDate())) {
                return false;
            }
            if (!Objects.equals(this.noticePeriod, _that.getNoticePeriod())) {
                return false;
            }
            return ListEquals.listEquals(this.partyNoticePeriod, _that.getPartyNoticePeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.callingParty != null ? ((Object)((Object)this.callingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.callDate != null ? this.callDate.hashCode() : 0);
            _result = 31 * _result + (this.noticePeriod != null ? this.noticePeriod.hashCode() : 0);
            _result = 31 * _result + (this.partyNoticePeriod != null ? this.partyNoticePeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepoSequence1 {callingParty=" + String.valueOf((Object)this.callingParty) + ", callDate=" + String.valueOf(this.callDate) + ", noticePeriod=" + String.valueOf(this.noticePeriod) + ", partyNoticePeriod=" + String.valueOf(this.partyNoticePeriod) + "}";
        }
    }
}

