/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.product;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.ExchangeRate;
import fpml.consolidated.reg.fpmlreporting.product.meta.RegulatoryReportingProductPriceTermsMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.Schedule;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryReportingProductPriceTerms", builder=RegulatoryReportingProductPriceTermsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryReportingProductPriceTerms", model="fpml", builder=RegulatoryReportingProductPriceTermsBuilderImpl.class, version="1.2.2")
public interface RegulatoryReportingProductPriceTerms
extends RosettaModelObject {
    public static final RegulatoryReportingProductPriceTermsMeta metaData = new RegulatoryReportingProductPriceTermsMeta();

    public List<BigDecimal> getFixedRate();

    public List<String> getFixedRateNotation();

    public List<? extends Schedule> getFixedRateSchedule();

    public List<BigDecimal> getSpread();

    public List<? extends Currency> getSpreadCurrency();

    public List<String> getSpreadNotation();

    public List<BigDecimal> getStrikePrice();

    public List<String> getStrikePriceNotation();

    public List<? extends Schedule> getStrikePriceSchedule();

    public List<? extends ExchangeRate> getExchangeRate();

    public RegulatoryReportingProductPriceTerms build();

    public RegulatoryReportingProductPriceTermsBuilder toBuilder();

    public static RegulatoryReportingProductPriceTermsBuilder builder() {
        return new RegulatoryReportingProductPriceTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryReportingProductPriceTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryReportingProductPriceTerms> getType() {
        return RegulatoryReportingProductPriceTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRateNotation"), String.class, this.getFixedRateNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedRateSchedule"), processor, Schedule.class, this.getFixedRateSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadCurrency"), processor, Currency.class, this.getSpreadCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotation"), String.class, this.getSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, this.getStrikePrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), String.class, this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, Schedule.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeRate"), processor, ExchangeRate.class, this.getExchangeRate(), new AttributeMeta[0]);
    }

    public static class RegulatoryReportingProductPriceTermsBuilderImpl
    implements RegulatoryReportingProductPriceTermsBuilder {
        protected List<BigDecimal> fixedRate = new ArrayList<BigDecimal>();
        protected List<String> fixedRateNotation = new ArrayList<String>();
        protected List<Schedule.ScheduleBuilder> fixedRateSchedule = new ArrayList<Schedule.ScheduleBuilder>();
        protected List<BigDecimal> spread = new ArrayList<BigDecimal>();
        protected List<Currency.CurrencyBuilder> spreadCurrency = new ArrayList<Currency.CurrencyBuilder>();
        protected List<String> spreadNotation = new ArrayList<String>();
        protected List<BigDecimal> strikePrice = new ArrayList<BigDecimal>();
        protected List<String> strikePriceNotation = new ArrayList<String>();
        protected List<Schedule.ScheduleBuilder> strikePriceSchedule = new ArrayList<Schedule.ScheduleBuilder>();
        protected List<ExchangeRate.ExchangeRateBuilder> exchangeRate = new ArrayList<ExchangeRate.ExchangeRateBuilder>();

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public List<BigDecimal> getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="fixedRateNotation")
        @RuneAttribute(value="fixedRateNotation")
        public List<String> getFixedRateNotation() {
            return this.fixedRateNotation;
        }

        @Override
        @RosettaAttribute(value="fixedRateSchedule")
        @RuneAttribute(value="fixedRateSchedule")
        public List<? extends Schedule.ScheduleBuilder> getFixedRateSchedule() {
            return this.fixedRateSchedule;
        }

        @Override
        public Schedule.ScheduleBuilder getOrCreateFixedRateSchedule(int index) {
            if (this.fixedRateSchedule == null) {
                this.fixedRateSchedule = new ArrayList<Schedule.ScheduleBuilder>();
            }
            return (Schedule.ScheduleBuilder)this.getIndex(this.fixedRateSchedule, index, () -> {
                Schedule.ScheduleBuilder newFixedRateSchedule = Schedule.builder();
                return newFixedRateSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public List<BigDecimal> getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public List<? extends Currency.CurrencyBuilder> getSpreadCurrency() {
            return this.spreadCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateSpreadCurrency(int index) {
            if (this.spreadCurrency == null) {
                this.spreadCurrency = new ArrayList<Currency.CurrencyBuilder>();
            }
            return (Currency.CurrencyBuilder)this.getIndex(this.spreadCurrency, index, () -> {
                Currency.CurrencyBuilder newSpreadCurrency = Currency.builder();
                return newSpreadCurrency;
            });
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public List<String> getSpreadNotation() {
            return this.spreadNotation;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public List<BigDecimal> getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public List<String> getStrikePriceNotation() {
            return this.strikePriceNotation;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends Schedule.ScheduleBuilder> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        public Schedule.ScheduleBuilder getOrCreateStrikePriceSchedule(int index) {
            if (this.strikePriceSchedule == null) {
                this.strikePriceSchedule = new ArrayList<Schedule.ScheduleBuilder>();
            }
            return (Schedule.ScheduleBuilder)this.getIndex(this.strikePriceSchedule, index, () -> {
                Schedule.ScheduleBuilder newStrikePriceSchedule = Schedule.builder();
                return newStrikePriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public List<? extends ExchangeRate.ExchangeRateBuilder> getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        public ExchangeRate.ExchangeRateBuilder getOrCreateExchangeRate(int index) {
            if (this.exchangeRate == null) {
                this.exchangeRate = new ArrayList<ExchangeRate.ExchangeRateBuilder>();
            }
            return (ExchangeRate.ExchangeRateBuilder)this.getIndex(this.exchangeRate, index, () -> {
                ExchangeRate.ExchangeRateBuilder newExchangeRate = ExchangeRate.builder();
                return newExchangeRate;
            });
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public RegulatoryReportingProductPriceTermsBuilder addFixedRate(BigDecimal _fixedRate) {
            if (_fixedRate != null) {
                this.fixedRate.add(_fixedRate);
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addFixedRate(BigDecimal _fixedRate, int idx) {
            this.getIndex(this.fixedRate, idx, () -> _fixedRate);
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addFixedRate(List<BigDecimal> fixedRates) {
            if (fixedRates != null) {
                for (BigDecimal toAdd : fixedRates) {
                    this.fixedRate.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixedRate")
        public RegulatoryReportingProductPriceTermsBuilder setFixedRate(List<BigDecimal> fixedRates) {
            this.fixedRate = fixedRates == null ? new ArrayList<BigDecimal>() : (List)fixedRates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateNotation")
        @RuneAttribute(value="fixedRateNotation")
        public RegulatoryReportingProductPriceTermsBuilder addFixedRateNotation(String _fixedRateNotation) {
            if (_fixedRateNotation != null) {
                this.fixedRateNotation.add(_fixedRateNotation);
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addFixedRateNotation(String _fixedRateNotation, int idx) {
            this.getIndex(this.fixedRateNotation, idx, () -> _fixedRateNotation);
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addFixedRateNotation(List<String> fixedRateNotations) {
            if (fixedRateNotations != null) {
                for (String toAdd : fixedRateNotations) {
                    this.fixedRateNotation.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixedRateNotation")
        public RegulatoryReportingProductPriceTermsBuilder setFixedRateNotation(List<String> fixedRateNotations) {
            this.fixedRateNotation = fixedRateNotations == null ? new ArrayList<String>() : (List)fixedRateNotations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateSchedule")
        @RuneAttribute(value="fixedRateSchedule")
        public RegulatoryReportingProductPriceTermsBuilder addFixedRateSchedule(Schedule _fixedRateSchedule) {
            if (_fixedRateSchedule != null) {
                this.fixedRateSchedule.add(_fixedRateSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addFixedRateSchedule(Schedule _fixedRateSchedule, int idx) {
            this.getIndex(this.fixedRateSchedule, idx, () -> _fixedRateSchedule.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addFixedRateSchedule(List<? extends Schedule> fixedRateSchedules) {
            if (fixedRateSchedules != null) {
                for (Schedule schedule : fixedRateSchedules) {
                    this.fixedRateSchedule.add(schedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixedRateSchedule")
        public RegulatoryReportingProductPriceTermsBuilder setFixedRateSchedule(List<? extends Schedule> fixedRateSchedules) {
            this.fixedRateSchedule = fixedRateSchedules == null ? new ArrayList<Schedule.ScheduleBuilder>() : (List)fixedRateSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public RegulatoryReportingProductPriceTermsBuilder addSpread(BigDecimal _spread) {
            if (_spread != null) {
                this.spread.add(_spread);
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addSpread(BigDecimal _spread, int idx) {
            this.getIndex(this.spread, idx, () -> _spread);
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addSpread(List<BigDecimal> spreads) {
            if (spreads != null) {
                for (BigDecimal toAdd : spreads) {
                    this.spread.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="spread")
        public RegulatoryReportingProductPriceTermsBuilder setSpread(List<BigDecimal> spreads) {
            this.spread = spreads == null ? new ArrayList<BigDecimal>() : (List)spreads.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public RegulatoryReportingProductPriceTermsBuilder addSpreadCurrency(Currency _spreadCurrency) {
            if (_spreadCurrency != null) {
                this.spreadCurrency.add(_spreadCurrency.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addSpreadCurrency(Currency _spreadCurrency, int idx) {
            this.getIndex(this.spreadCurrency, idx, () -> _spreadCurrency.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addSpreadCurrency(List<? extends Currency> spreadCurrencys) {
            if (spreadCurrencys != null) {
                for (Currency currency : spreadCurrencys) {
                    this.spreadCurrency.add(currency.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="spreadCurrency")
        public RegulatoryReportingProductPriceTermsBuilder setSpreadCurrency(List<? extends Currency> spreadCurrencys) {
            this.spreadCurrency = spreadCurrencys == null ? new ArrayList<Currency.CurrencyBuilder>() : (List)spreadCurrencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public RegulatoryReportingProductPriceTermsBuilder addSpreadNotation(String _spreadNotation) {
            if (_spreadNotation != null) {
                this.spreadNotation.add(_spreadNotation);
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addSpreadNotation(String _spreadNotation, int idx) {
            this.getIndex(this.spreadNotation, idx, () -> _spreadNotation);
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addSpreadNotation(List<String> spreadNotations) {
            if (spreadNotations != null) {
                for (String toAdd : spreadNotations) {
                    this.spreadNotation.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="spreadNotation")
        public RegulatoryReportingProductPriceTermsBuilder setSpreadNotation(List<String> spreadNotations) {
            this.spreadNotation = spreadNotations == null ? new ArrayList<String>() : (List)spreadNotations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public RegulatoryReportingProductPriceTermsBuilder addStrikePrice(BigDecimal _strikePrice) {
            if (_strikePrice != null) {
                this.strikePrice.add(_strikePrice);
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addStrikePrice(BigDecimal _strikePrice, int idx) {
            this.getIndex(this.strikePrice, idx, () -> _strikePrice);
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addStrikePrice(List<BigDecimal> strikePrices) {
            if (strikePrices != null) {
                for (BigDecimal toAdd : strikePrices) {
                    this.strikePrice.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePrice")
        public RegulatoryReportingProductPriceTermsBuilder setStrikePrice(List<BigDecimal> strikePrices) {
            this.strikePrice = strikePrices == null ? new ArrayList<BigDecimal>() : (List)strikePrices.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceNotation(String _strikePriceNotation) {
            if (_strikePriceNotation != null) {
                this.strikePriceNotation.add(_strikePriceNotation);
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceNotation(String _strikePriceNotation, int idx) {
            this.getIndex(this.strikePriceNotation, idx, () -> _strikePriceNotation);
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceNotation(List<String> strikePriceNotations) {
            if (strikePriceNotations != null) {
                for (String toAdd : strikePriceNotations) {
                    this.strikePriceNotation.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceNotation")
        public RegulatoryReportingProductPriceTermsBuilder setStrikePriceNotation(List<String> strikePriceNotations) {
            this.strikePriceNotation = strikePriceNotations == null ? new ArrayList<String>() : (List)strikePriceNotations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceSchedule(Schedule _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceSchedule(Schedule _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceSchedule(List<? extends Schedule> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (Schedule schedule : strikePriceSchedules) {
                    this.strikePriceSchedule.add(schedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public RegulatoryReportingProductPriceTermsBuilder setStrikePriceSchedule(List<? extends Schedule> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList<Schedule.ScheduleBuilder>() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public RegulatoryReportingProductPriceTermsBuilder addExchangeRate(ExchangeRate _exchangeRate) {
            if (_exchangeRate != null) {
                this.exchangeRate.add(_exchangeRate.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addExchangeRate(ExchangeRate _exchangeRate, int idx) {
            this.getIndex(this.exchangeRate, idx, () -> _exchangeRate.toBuilder());
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder addExchangeRate(List<? extends ExchangeRate> exchangeRates) {
            if (exchangeRates != null) {
                for (ExchangeRate exchangeRate : exchangeRates) {
                    this.exchangeRate.add(exchangeRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="exchangeRate")
        public RegulatoryReportingProductPriceTermsBuilder setExchangeRate(List<? extends ExchangeRate> exchangeRates) {
            this.exchangeRate = exchangeRates == null ? new ArrayList<ExchangeRate.ExchangeRateBuilder>() : (List)exchangeRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTerms build() {
            return new RegulatoryReportingProductPriceTermsImpl(this);
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder prune() {
            this.fixedRateSchedule = this.fixedRateSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.spreadCurrency = this.spreadCurrency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.strikePriceSchedule = this.strikePriceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.exchangeRate = this.exchangeRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFixedRate() != null && !this.getFixedRate().isEmpty()) {
                return true;
            }
            if (this.getFixedRateNotation() != null && !this.getFixedRateNotation().isEmpty()) {
                return true;
            }
            if (this.getFixedRateSchedule() != null && this.getFixedRateSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSpread() != null && !this.getSpread().isEmpty()) {
                return true;
            }
            if (this.getSpreadCurrency() != null && this.getSpreadCurrency().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSpreadNotation() != null && !this.getSpreadNotation().isEmpty()) {
                return true;
            }
            if (this.getStrikePrice() != null && !this.getStrikePrice().isEmpty()) {
                return true;
            }
            if (this.getStrikePriceNotation() != null && !this.getStrikePriceNotation().isEmpty()) {
                return true;
            }
            if (this.getStrikePriceSchedule() != null && this.getStrikePriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getExchangeRate() != null && this.getExchangeRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public RegulatoryReportingProductPriceTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegulatoryReportingProductPriceTermsBuilder o = (RegulatoryReportingProductPriceTermsBuilder)other;
            merger.mergeRosetta(this.getFixedRateSchedule(), o.getFixedRateSchedule(), this::getOrCreateFixedRateSchedule);
            merger.mergeRosetta(this.getSpreadCurrency(), o.getSpreadCurrency(), this::getOrCreateSpreadCurrency);
            merger.mergeRosetta(this.getStrikePriceSchedule(), o.getStrikePriceSchedule(), this::getOrCreateStrikePriceSchedule);
            merger.mergeRosetta(this.getExchangeRate(), o.getExchangeRate(), this::getOrCreateExchangeRate);
            merger.mergeBasic(this.getFixedRate(), o.getFixedRate(), this::addFixedRate);
            merger.mergeBasic(this.getFixedRateNotation(), o.getFixedRateNotation(), this::addFixedRateNotation);
            merger.mergeBasic(this.getSpread(), o.getSpread(), this::addSpread);
            merger.mergeBasic(this.getSpreadNotation(), o.getSpreadNotation(), this::addSpreadNotation);
            merger.mergeBasic(this.getStrikePrice(), o.getStrikePrice(), this::addStrikePrice);
            merger.mergeBasic(this.getStrikePriceNotation(), o.getStrikePriceNotation(), this::addStrikePriceNotation);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryReportingProductPriceTerms _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixedRateNotation, _that.getFixedRateNotation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixedRateSchedule, _that.getFixedRateSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadCurrency, _that.getSpreadCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadNotation, _that.getSpreadNotation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceNotation, _that.getStrikePriceNotation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            return ListEquals.listEquals(this.exchangeRate, _that.getExchangeRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateNotation != null ? this.fixedRateNotation.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateSchedule != null ? this.fixedRateSchedule.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.spreadCurrency != null ? this.spreadCurrency.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotation != null ? this.spreadNotation.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceNotation != null ? this.strikePriceNotation.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryReportingProductPriceTermsBuilder {fixedRate=" + String.valueOf(this.fixedRate) + ", fixedRateNotation=" + String.valueOf(this.fixedRateNotation) + ", fixedRateSchedule=" + String.valueOf(this.fixedRateSchedule) + ", spread=" + String.valueOf(this.spread) + ", spreadCurrency=" + String.valueOf(this.spreadCurrency) + ", spreadNotation=" + String.valueOf(this.spreadNotation) + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceNotation=" + String.valueOf(this.strikePriceNotation) + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + "}";
        }
    }

    public static interface RegulatoryReportingProductPriceTermsBuilder
    extends RegulatoryReportingProductPriceTerms,
    RosettaModelObjectBuilder {
        public Schedule.ScheduleBuilder getOrCreateFixedRateSchedule(int var1);

        public List<? extends Schedule.ScheduleBuilder> getFixedRateSchedule();

        public Currency.CurrencyBuilder getOrCreateSpreadCurrency(int var1);

        public List<? extends Currency.CurrencyBuilder> getSpreadCurrency();

        public Schedule.ScheduleBuilder getOrCreateStrikePriceSchedule(int var1);

        public List<? extends Schedule.ScheduleBuilder> getStrikePriceSchedule();

        public ExchangeRate.ExchangeRateBuilder getOrCreateExchangeRate(int var1);

        public List<? extends ExchangeRate.ExchangeRateBuilder> getExchangeRate();

        public RegulatoryReportingProductPriceTermsBuilder addFixedRate(BigDecimal var1);

        public RegulatoryReportingProductPriceTermsBuilder addFixedRate(BigDecimal var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addFixedRate(List<BigDecimal> var1);

        public RegulatoryReportingProductPriceTermsBuilder setFixedRate(List<BigDecimal> var1);

        public RegulatoryReportingProductPriceTermsBuilder addFixedRateNotation(String var1);

        public RegulatoryReportingProductPriceTermsBuilder addFixedRateNotation(String var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addFixedRateNotation(List<String> var1);

        public RegulatoryReportingProductPriceTermsBuilder setFixedRateNotation(List<String> var1);

        public RegulatoryReportingProductPriceTermsBuilder addFixedRateSchedule(Schedule var1);

        public RegulatoryReportingProductPriceTermsBuilder addFixedRateSchedule(Schedule var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addFixedRateSchedule(List<? extends Schedule> var1);

        public RegulatoryReportingProductPriceTermsBuilder setFixedRateSchedule(List<? extends Schedule> var1);

        public RegulatoryReportingProductPriceTermsBuilder addSpread(BigDecimal var1);

        public RegulatoryReportingProductPriceTermsBuilder addSpread(BigDecimal var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addSpread(List<BigDecimal> var1);

        public RegulatoryReportingProductPriceTermsBuilder setSpread(List<BigDecimal> var1);

        public RegulatoryReportingProductPriceTermsBuilder addSpreadCurrency(Currency var1);

        public RegulatoryReportingProductPriceTermsBuilder addSpreadCurrency(Currency var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addSpreadCurrency(List<? extends Currency> var1);

        public RegulatoryReportingProductPriceTermsBuilder setSpreadCurrency(List<? extends Currency> var1);

        public RegulatoryReportingProductPriceTermsBuilder addSpreadNotation(String var1);

        public RegulatoryReportingProductPriceTermsBuilder addSpreadNotation(String var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addSpreadNotation(List<String> var1);

        public RegulatoryReportingProductPriceTermsBuilder setSpreadNotation(List<String> var1);

        public RegulatoryReportingProductPriceTermsBuilder addStrikePrice(BigDecimal var1);

        public RegulatoryReportingProductPriceTermsBuilder addStrikePrice(BigDecimal var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addStrikePrice(List<BigDecimal> var1);

        public RegulatoryReportingProductPriceTermsBuilder setStrikePrice(List<BigDecimal> var1);

        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceNotation(String var1);

        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceNotation(String var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceNotation(List<String> var1);

        public RegulatoryReportingProductPriceTermsBuilder setStrikePriceNotation(List<String> var1);

        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceSchedule(Schedule var1);

        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceSchedule(Schedule var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addStrikePriceSchedule(List<? extends Schedule> var1);

        public RegulatoryReportingProductPriceTermsBuilder setStrikePriceSchedule(List<? extends Schedule> var1);

        public RegulatoryReportingProductPriceTermsBuilder addExchangeRate(ExchangeRate var1);

        public RegulatoryReportingProductPriceTermsBuilder addExchangeRate(ExchangeRate var1, int var2);

        public RegulatoryReportingProductPriceTermsBuilder addExchangeRate(List<? extends ExchangeRate> var1);

        public RegulatoryReportingProductPriceTermsBuilder setExchangeRate(List<? extends ExchangeRate> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRateNotation"), String.class, this.getFixedRateNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedRateSchedule"), processor, Schedule.ScheduleBuilder.class, this.getFixedRateSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadCurrency"), processor, Currency.CurrencyBuilder.class, this.getSpreadCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotation"), String.class, this.getSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, this.getStrikePrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), String.class, this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, Schedule.ScheduleBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeRate"), processor, ExchangeRate.ExchangeRateBuilder.class, this.getExchangeRate(), new AttributeMeta[0]);
        }

        public RegulatoryReportingProductPriceTermsBuilder prune();
    }

    public static class RegulatoryReportingProductPriceTermsImpl
    implements RegulatoryReportingProductPriceTerms {
        private final List<BigDecimal> fixedRate;
        private final List<String> fixedRateNotation;
        private final List<? extends Schedule> fixedRateSchedule;
        private final List<BigDecimal> spread;
        private final List<? extends Currency> spreadCurrency;
        private final List<String> spreadNotation;
        private final List<BigDecimal> strikePrice;
        private final List<String> strikePriceNotation;
        private final List<? extends Schedule> strikePriceSchedule;
        private final List<? extends ExchangeRate> exchangeRate;

        protected RegulatoryReportingProductPriceTermsImpl(RegulatoryReportingProductPriceTermsBuilder builder) {
            this.fixedRate = Optional.ofNullable(builder.getFixedRate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.fixedRateNotation = Optional.ofNullable(builder.getFixedRateNotation()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.fixedRateSchedule = Optional.ofNullable(builder.getFixedRateSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.spread = Optional.ofNullable(builder.getSpread()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.spreadCurrency = Optional.ofNullable(builder.getSpreadCurrency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.spreadNotation = Optional.ofNullable(builder.getSpreadNotation()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.strikePrice = Optional.ofNullable(builder.getStrikePrice()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.strikePriceNotation = Optional.ofNullable(builder.getStrikePriceNotation()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.strikePriceSchedule = Optional.ofNullable(builder.getStrikePriceSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.exchangeRate = Optional.ofNullable(builder.getExchangeRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public List<BigDecimal> getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="fixedRateNotation")
        @RuneAttribute(value="fixedRateNotation")
        public List<String> getFixedRateNotation() {
            return this.fixedRateNotation;
        }

        @Override
        @RosettaAttribute(value="fixedRateSchedule")
        @RuneAttribute(value="fixedRateSchedule")
        public List<? extends Schedule> getFixedRateSchedule() {
            return this.fixedRateSchedule;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public List<BigDecimal> getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public List<? extends Currency> getSpreadCurrency() {
            return this.spreadCurrency;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public List<String> getSpreadNotation() {
            return this.spreadNotation;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public List<BigDecimal> getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public List<String> getStrikePriceNotation() {
            return this.strikePriceNotation;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends Schedule> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public List<? extends ExchangeRate> getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        public RegulatoryReportingProductPriceTerms build() {
            return this;
        }

        @Override
        public RegulatoryReportingProductPriceTermsBuilder toBuilder() {
            RegulatoryReportingProductPriceTermsBuilder builder = RegulatoryReportingProductPriceTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryReportingProductPriceTermsBuilder builder) {
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getFixedRateNotation()).ifPresent(builder::setFixedRateNotation);
            Optional.ofNullable(this.getFixedRateSchedule()).ifPresent(builder::setFixedRateSchedule);
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getSpreadCurrency()).ifPresent(builder::setSpreadCurrency);
            Optional.ofNullable(this.getSpreadNotation()).ifPresent(builder::setSpreadNotation);
            Optional.ofNullable(this.getStrikePrice()).ifPresent(builder::setStrikePrice);
            Optional.ofNullable(this.getStrikePriceNotation()).ifPresent(builder::setStrikePriceNotation);
            Optional.ofNullable(this.getStrikePriceSchedule()).ifPresent(builder::setStrikePriceSchedule);
            Optional.ofNullable(this.getExchangeRate()).ifPresent(builder::setExchangeRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryReportingProductPriceTerms _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixedRateNotation, _that.getFixedRateNotation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixedRateSchedule, _that.getFixedRateSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadCurrency, _that.getSpreadCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.spreadNotation, _that.getSpreadNotation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceNotation, _that.getStrikePriceNotation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            return ListEquals.listEquals(this.exchangeRate, _that.getExchangeRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateNotation != null ? this.fixedRateNotation.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateSchedule != null ? this.fixedRateSchedule.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.spreadCurrency != null ? this.spreadCurrency.hashCode() : 0);
            _result = 31 * _result + (this.spreadNotation != null ? this.spreadNotation.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceNotation != null ? this.strikePriceNotation.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryReportingProductPriceTerms {fixedRate=" + String.valueOf(this.fixedRate) + ", fixedRateNotation=" + String.valueOf(this.fixedRateNotation) + ", fixedRateSchedule=" + String.valueOf(this.fixedRateSchedule) + ", spread=" + String.valueOf(this.spread) + ", spreadCurrency=" + String.valueOf(this.spreadCurrency) + ", spreadNotation=" + String.valueOf(this.spreadNotation) + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceNotation=" + String.valueOf(this.strikePriceNotation) + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + "}";
        }
    }
}

