/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.recordkeeping.processes.InapplicableRegulation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="InapplicableRegulationChoice")
@ImplementedBy(value=Default.class)
public interface InapplicableRegulationChoice
extends Validator<InapplicableRegulation> {
    public static final String NAME = "InapplicableRegulationChoice";
    public static final String DEFINITION = "required choice inapplicableRegulationSequence, regulation";

    public static class NoOp
    implements InapplicableRegulationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InapplicableRegulation inapplicableRegulation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements InapplicableRegulationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, InapplicableRegulation inapplicableRegulation) {
            ComparisonResult result = this.executeDataRule(inapplicableRegulation);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)InapplicableRegulationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InapplicableRegulation", (RosettaPath)path, (String)InapplicableRegulationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)InapplicableRegulationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InapplicableRegulation", (RosettaPath)path, (String)InapplicableRegulationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(InapplicableRegulation inapplicableRegulation) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)inapplicableRegulation), Arrays.asList("inapplicableRegulationSequence", "regulation"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

