/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationASIC_2013;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationCSA_2016;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationEMIR_2015;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationMAS_2013;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationMifirRTS22_2015;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationMifirRTS23_2015;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationMifirRTS24_2015;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationMifirRTS6a_2015;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationMifirRTS6b_2015;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationOther;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationPart43_2012;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationPart43_2019;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationPart45_2012;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationPart45_2019;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationSFTR_2019;
import fpml.consolidated.recordkeeping.processes.meta.RegulationDetailsMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulationDetails", builder=RegulationDetailsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulationDetails", model="fpml", builder=RegulationDetailsBuilderImpl.class, version="1.2.2")
public interface RegulationDetails
extends RosettaModelObject {
    public static final RegulationDetailsMeta metaData = new RegulationDetailsMeta();

    public RegulatoryClassificationPart43_2012 getCftc_part43_2012();

    public RegulatoryClassificationPart43_2019 getCftc_part43_2019();

    public RegulatoryClassificationPart45_2012 getCftc_part45_2012();

    public RegulatoryClassificationPart45_2019 getCftc_part45_2019();

    public RegulatoryClassificationEMIR_2015 getEsma_emirRts_2015();

    public RegulatoryClassificationMifirRTS6a_2015 getEsma_mifirRts6a_2015();

    public RegulatoryClassificationMifirRTS6b_2015 getEsma_mifirRts6b_2015();

    public RegulatoryClassificationMifirRTS22_2015 getEsma_mifirRts22_2015();

    public RegulatoryClassificationMifirRTS23_2015 getEsma_mifirRts23_2015();

    public RegulatoryClassificationMifirRTS24_2015 getEsma_mifirRts24_2015();

    public RegulatoryClassificationCSA_2016 getCsa_derivativesReporting_2016();

    public RegulatoryClassificationMAS_2013 getMas_sfa_2013();

    public RegulatoryClassificationASIC_2013 getAsic_derivativesTransactionRules_2013();

    public RegulatoryClassificationSFTR_2019 getEsma_sftrRts_2019();

    public List<? extends RegulatoryClassificationOther> getOther();

    public RegulationDetails build();

    public RegulationDetailsBuilder toBuilder();

    public static RegulationDetailsBuilder builder() {
        return new RegulationDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulationDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulationDetails> getType() {
        return RegulationDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("cftc_part43_2012"), processor, RegulatoryClassificationPart43_2012.class, this.getCftc_part43_2012(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cftc_part43_2019"), processor, RegulatoryClassificationPart43_2019.class, this.getCftc_part43_2019(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cftc_part45_2012"), processor, RegulatoryClassificationPart45_2012.class, this.getCftc_part45_2012(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cftc_part45_2019"), processor, RegulatoryClassificationPart45_2019.class, this.getCftc_part45_2019(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("esma_emirRts_2015"), processor, RegulatoryClassificationEMIR_2015.class, this.getEsma_emirRts_2015(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("esma_mifirRts6a_2015"), processor, RegulatoryClassificationMifirRTS6a_2015.class, this.getEsma_mifirRts6a_2015(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("esma_mifirRts6b_2015"), processor, RegulatoryClassificationMifirRTS6b_2015.class, this.getEsma_mifirRts6b_2015(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("esma_mifirRts22_2015"), processor, RegulatoryClassificationMifirRTS22_2015.class, this.getEsma_mifirRts22_2015(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("esma_mifirRts23_2015"), processor, RegulatoryClassificationMifirRTS23_2015.class, this.getEsma_mifirRts23_2015(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("esma_mifirRts24_2015"), processor, RegulatoryClassificationMifirRTS24_2015.class, this.getEsma_mifirRts24_2015(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("csa_derivativesReporting_2016"), processor, RegulatoryClassificationCSA_2016.class, this.getCsa_derivativesReporting_2016(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("mas_sfa_2013"), processor, RegulatoryClassificationMAS_2013.class, this.getMas_sfa_2013(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asic_derivativesTransactionRules_2013"), processor, RegulatoryClassificationASIC_2013.class, this.getAsic_derivativesTransactionRules_2013(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("esma_sftrRts_2019"), processor, RegulatoryClassificationSFTR_2019.class, this.getEsma_sftrRts_2019(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("other"), processor, RegulatoryClassificationOther.class, this.getOther(), new AttributeMeta[0]);
    }

    public static class RegulationDetailsBuilderImpl
    implements RegulationDetailsBuilder {
        protected RegulatoryClassificationPart43_2012.RegulatoryClassificationPart43_2012Builder cftc_part43_2012;
        protected RegulatoryClassificationPart43_2019.RegulatoryClassificationPart43_2019Builder cftc_part43_2019;
        protected RegulatoryClassificationPart45_2012.RegulatoryClassificationPart45_2012Builder cftc_part45_2012;
        protected RegulatoryClassificationPart45_2019.RegulatoryClassificationPart45_2019Builder cftc_part45_2019;
        protected RegulatoryClassificationEMIR_2015.RegulatoryClassificationEMIR_2015Builder esma_emirRts_2015;
        protected RegulatoryClassificationMifirRTS6a_2015.RegulatoryClassificationMifirRTS6a_2015Builder esma_mifirRts6a_2015;
        protected RegulatoryClassificationMifirRTS6b_2015.RegulatoryClassificationMifirRTS6b_2015Builder esma_mifirRts6b_2015;
        protected RegulatoryClassificationMifirRTS22_2015.RegulatoryClassificationMifirRTS22_2015Builder esma_mifirRts22_2015;
        protected RegulatoryClassificationMifirRTS23_2015.RegulatoryClassificationMifirRTS23_2015Builder esma_mifirRts23_2015;
        protected RegulatoryClassificationMifirRTS24_2015.RegulatoryClassificationMifirRTS24_2015Builder esma_mifirRts24_2015;
        protected RegulatoryClassificationCSA_2016.RegulatoryClassificationCSA_2016Builder csa_derivativesReporting_2016;
        protected RegulatoryClassificationMAS_2013.RegulatoryClassificationMAS_2013Builder mas_sfa_2013;
        protected RegulatoryClassificationASIC_2013.RegulatoryClassificationASIC_2013Builder asic_derivativesTransactionRules_2013;
        protected RegulatoryClassificationSFTR_2019.RegulatoryClassificationSFTR_2019Builder esma_sftrRts_2019;
        protected List<RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder> other = new ArrayList<RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder>();

        @Override
        @RosettaAttribute(value="cftc_part43_2012")
        @RuneAttribute(value="cftc_part43_2012")
        public RegulatoryClassificationPart43_2012.RegulatoryClassificationPart43_2012Builder getCftc_part43_2012() {
            return this.cftc_part43_2012;
        }

        @Override
        public RegulatoryClassificationPart43_2012.RegulatoryClassificationPart43_2012Builder getOrCreateCftc_part43_2012() {
            RegulatoryClassificationPart43_2012.RegulatoryClassificationPart43_2012Builder result = this.cftc_part43_2012 != null ? this.cftc_part43_2012 : (this.cftc_part43_2012 = RegulatoryClassificationPart43_2012.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cftc_part43_2019")
        @RuneAttribute(value="cftc_part43_2019")
        public RegulatoryClassificationPart43_2019.RegulatoryClassificationPart43_2019Builder getCftc_part43_2019() {
            return this.cftc_part43_2019;
        }

        @Override
        public RegulatoryClassificationPart43_2019.RegulatoryClassificationPart43_2019Builder getOrCreateCftc_part43_2019() {
            RegulatoryClassificationPart43_2019.RegulatoryClassificationPart43_2019Builder result = this.cftc_part43_2019 != null ? this.cftc_part43_2019 : (this.cftc_part43_2019 = RegulatoryClassificationPart43_2019.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cftc_part45_2012")
        @RuneAttribute(value="cftc_part45_2012")
        public RegulatoryClassificationPart45_2012.RegulatoryClassificationPart45_2012Builder getCftc_part45_2012() {
            return this.cftc_part45_2012;
        }

        @Override
        public RegulatoryClassificationPart45_2012.RegulatoryClassificationPart45_2012Builder getOrCreateCftc_part45_2012() {
            RegulatoryClassificationPart45_2012.RegulatoryClassificationPart45_2012Builder result = this.cftc_part45_2012 != null ? this.cftc_part45_2012 : (this.cftc_part45_2012 = RegulatoryClassificationPart45_2012.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cftc_part45_2019")
        @RuneAttribute(value="cftc_part45_2019")
        public RegulatoryClassificationPart45_2019.RegulatoryClassificationPart45_2019Builder getCftc_part45_2019() {
            return this.cftc_part45_2019;
        }

        @Override
        public RegulatoryClassificationPart45_2019.RegulatoryClassificationPart45_2019Builder getOrCreateCftc_part45_2019() {
            RegulatoryClassificationPart45_2019.RegulatoryClassificationPart45_2019Builder result = this.cftc_part45_2019 != null ? this.cftc_part45_2019 : (this.cftc_part45_2019 = RegulatoryClassificationPart45_2019.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="esma_emirRts_2015")
        @RuneAttribute(value="esma_emirRts_2015")
        public RegulatoryClassificationEMIR_2015.RegulatoryClassificationEMIR_2015Builder getEsma_emirRts_2015() {
            return this.esma_emirRts_2015;
        }

        @Override
        public RegulatoryClassificationEMIR_2015.RegulatoryClassificationEMIR_2015Builder getOrCreateEsma_emirRts_2015() {
            RegulatoryClassificationEMIR_2015.RegulatoryClassificationEMIR_2015Builder result = this.esma_emirRts_2015 != null ? this.esma_emirRts_2015 : (this.esma_emirRts_2015 = RegulatoryClassificationEMIR_2015.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts6a_2015")
        @RuneAttribute(value="esma_mifirRts6a_2015")
        public RegulatoryClassificationMifirRTS6a_2015.RegulatoryClassificationMifirRTS6a_2015Builder getEsma_mifirRts6a_2015() {
            return this.esma_mifirRts6a_2015;
        }

        @Override
        public RegulatoryClassificationMifirRTS6a_2015.RegulatoryClassificationMifirRTS6a_2015Builder getOrCreateEsma_mifirRts6a_2015() {
            RegulatoryClassificationMifirRTS6a_2015.RegulatoryClassificationMifirRTS6a_2015Builder result = this.esma_mifirRts6a_2015 != null ? this.esma_mifirRts6a_2015 : (this.esma_mifirRts6a_2015 = RegulatoryClassificationMifirRTS6a_2015.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts6b_2015")
        @RuneAttribute(value="esma_mifirRts6b_2015")
        public RegulatoryClassificationMifirRTS6b_2015.RegulatoryClassificationMifirRTS6b_2015Builder getEsma_mifirRts6b_2015() {
            return this.esma_mifirRts6b_2015;
        }

        @Override
        public RegulatoryClassificationMifirRTS6b_2015.RegulatoryClassificationMifirRTS6b_2015Builder getOrCreateEsma_mifirRts6b_2015() {
            RegulatoryClassificationMifirRTS6b_2015.RegulatoryClassificationMifirRTS6b_2015Builder result = this.esma_mifirRts6b_2015 != null ? this.esma_mifirRts6b_2015 : (this.esma_mifirRts6b_2015 = RegulatoryClassificationMifirRTS6b_2015.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts22_2015")
        @RuneAttribute(value="esma_mifirRts22_2015")
        public RegulatoryClassificationMifirRTS22_2015.RegulatoryClassificationMifirRTS22_2015Builder getEsma_mifirRts22_2015() {
            return this.esma_mifirRts22_2015;
        }

        @Override
        public RegulatoryClassificationMifirRTS22_2015.RegulatoryClassificationMifirRTS22_2015Builder getOrCreateEsma_mifirRts22_2015() {
            RegulatoryClassificationMifirRTS22_2015.RegulatoryClassificationMifirRTS22_2015Builder result = this.esma_mifirRts22_2015 != null ? this.esma_mifirRts22_2015 : (this.esma_mifirRts22_2015 = RegulatoryClassificationMifirRTS22_2015.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts23_2015")
        @RuneAttribute(value="esma_mifirRts23_2015")
        public RegulatoryClassificationMifirRTS23_2015.RegulatoryClassificationMifirRTS23_2015Builder getEsma_mifirRts23_2015() {
            return this.esma_mifirRts23_2015;
        }

        @Override
        public RegulatoryClassificationMifirRTS23_2015.RegulatoryClassificationMifirRTS23_2015Builder getOrCreateEsma_mifirRts23_2015() {
            RegulatoryClassificationMifirRTS23_2015.RegulatoryClassificationMifirRTS23_2015Builder result = this.esma_mifirRts23_2015 != null ? this.esma_mifirRts23_2015 : (this.esma_mifirRts23_2015 = RegulatoryClassificationMifirRTS23_2015.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts24_2015")
        @RuneAttribute(value="esma_mifirRts24_2015")
        public RegulatoryClassificationMifirRTS24_2015.RegulatoryClassificationMifirRTS24_2015Builder getEsma_mifirRts24_2015() {
            return this.esma_mifirRts24_2015;
        }

        @Override
        public RegulatoryClassificationMifirRTS24_2015.RegulatoryClassificationMifirRTS24_2015Builder getOrCreateEsma_mifirRts24_2015() {
            RegulatoryClassificationMifirRTS24_2015.RegulatoryClassificationMifirRTS24_2015Builder result = this.esma_mifirRts24_2015 != null ? this.esma_mifirRts24_2015 : (this.esma_mifirRts24_2015 = RegulatoryClassificationMifirRTS24_2015.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="csa_derivativesReporting_2016")
        @RuneAttribute(value="csa_derivativesReporting_2016")
        public RegulatoryClassificationCSA_2016.RegulatoryClassificationCSA_2016Builder getCsa_derivativesReporting_2016() {
            return this.csa_derivativesReporting_2016;
        }

        @Override
        public RegulatoryClassificationCSA_2016.RegulatoryClassificationCSA_2016Builder getOrCreateCsa_derivativesReporting_2016() {
            RegulatoryClassificationCSA_2016.RegulatoryClassificationCSA_2016Builder result = this.csa_derivativesReporting_2016 != null ? this.csa_derivativesReporting_2016 : (this.csa_derivativesReporting_2016 = RegulatoryClassificationCSA_2016.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="mas_sfa_2013")
        @RuneAttribute(value="mas_sfa_2013")
        public RegulatoryClassificationMAS_2013.RegulatoryClassificationMAS_2013Builder getMas_sfa_2013() {
            return this.mas_sfa_2013;
        }

        @Override
        public RegulatoryClassificationMAS_2013.RegulatoryClassificationMAS_2013Builder getOrCreateMas_sfa_2013() {
            RegulatoryClassificationMAS_2013.RegulatoryClassificationMAS_2013Builder result = this.mas_sfa_2013 != null ? this.mas_sfa_2013 : (this.mas_sfa_2013 = RegulatoryClassificationMAS_2013.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="asic_derivativesTransactionRules_2013")
        @RuneAttribute(value="asic_derivativesTransactionRules_2013")
        public RegulatoryClassificationASIC_2013.RegulatoryClassificationASIC_2013Builder getAsic_derivativesTransactionRules_2013() {
            return this.asic_derivativesTransactionRules_2013;
        }

        @Override
        public RegulatoryClassificationASIC_2013.RegulatoryClassificationASIC_2013Builder getOrCreateAsic_derivativesTransactionRules_2013() {
            RegulatoryClassificationASIC_2013.RegulatoryClassificationASIC_2013Builder result = this.asic_derivativesTransactionRules_2013 != null ? this.asic_derivativesTransactionRules_2013 : (this.asic_derivativesTransactionRules_2013 = RegulatoryClassificationASIC_2013.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="esma_sftrRts_2019")
        @RuneAttribute(value="esma_sftrRts_2019")
        public RegulatoryClassificationSFTR_2019.RegulatoryClassificationSFTR_2019Builder getEsma_sftrRts_2019() {
            return this.esma_sftrRts_2019;
        }

        @Override
        public RegulatoryClassificationSFTR_2019.RegulatoryClassificationSFTR_2019Builder getOrCreateEsma_sftrRts_2019() {
            RegulatoryClassificationSFTR_2019.RegulatoryClassificationSFTR_2019Builder result = this.esma_sftrRts_2019 != null ? this.esma_sftrRts_2019 : (this.esma_sftrRts_2019 = RegulatoryClassificationSFTR_2019.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="other")
        @RuneAttribute(value="other")
        public List<? extends RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder> getOther() {
            return this.other;
        }

        @Override
        public RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder getOrCreateOther(int index) {
            if (this.other == null) {
                this.other = new ArrayList<RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder>();
            }
            return (RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder)this.getIndex(this.other, index, () -> {
                RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder newOther = RegulatoryClassificationOther.builder();
                return newOther;
            });
        }

        @Override
        @RosettaAttribute(value="cftc_part43_2012")
        @RuneAttribute(value="cftc_part43_2012")
        public RegulationDetailsBuilder setCftc_part43_2012(RegulatoryClassificationPart43_2012 _cftc_part43_2012) {
            this.cftc_part43_2012 = _cftc_part43_2012 == null ? null : _cftc_part43_2012.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cftc_part43_2019")
        @RuneAttribute(value="cftc_part43_2019")
        public RegulationDetailsBuilder setCftc_part43_2019(RegulatoryClassificationPart43_2019 _cftc_part43_2019) {
            this.cftc_part43_2019 = _cftc_part43_2019 == null ? null : _cftc_part43_2019.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cftc_part45_2012")
        @RuneAttribute(value="cftc_part45_2012")
        public RegulationDetailsBuilder setCftc_part45_2012(RegulatoryClassificationPart45_2012 _cftc_part45_2012) {
            this.cftc_part45_2012 = _cftc_part45_2012 == null ? null : _cftc_part45_2012.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cftc_part45_2019")
        @RuneAttribute(value="cftc_part45_2019")
        public RegulationDetailsBuilder setCftc_part45_2019(RegulatoryClassificationPart45_2019 _cftc_part45_2019) {
            this.cftc_part45_2019 = _cftc_part45_2019 == null ? null : _cftc_part45_2019.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="esma_emirRts_2015")
        @RuneAttribute(value="esma_emirRts_2015")
        public RegulationDetailsBuilder setEsma_emirRts_2015(RegulatoryClassificationEMIR_2015 _esma_emirRts_2015) {
            this.esma_emirRts_2015 = _esma_emirRts_2015 == null ? null : _esma_emirRts_2015.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts6a_2015")
        @RuneAttribute(value="esma_mifirRts6a_2015")
        public RegulationDetailsBuilder setEsma_mifirRts6a_2015(RegulatoryClassificationMifirRTS6a_2015 _esma_mifirRts6a_2015) {
            this.esma_mifirRts6a_2015 = _esma_mifirRts6a_2015 == null ? null : _esma_mifirRts6a_2015.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts6b_2015")
        @RuneAttribute(value="esma_mifirRts6b_2015")
        public RegulationDetailsBuilder setEsma_mifirRts6b_2015(RegulatoryClassificationMifirRTS6b_2015 _esma_mifirRts6b_2015) {
            this.esma_mifirRts6b_2015 = _esma_mifirRts6b_2015 == null ? null : _esma_mifirRts6b_2015.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts22_2015")
        @RuneAttribute(value="esma_mifirRts22_2015")
        public RegulationDetailsBuilder setEsma_mifirRts22_2015(RegulatoryClassificationMifirRTS22_2015 _esma_mifirRts22_2015) {
            this.esma_mifirRts22_2015 = _esma_mifirRts22_2015 == null ? null : _esma_mifirRts22_2015.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts23_2015")
        @RuneAttribute(value="esma_mifirRts23_2015")
        public RegulationDetailsBuilder setEsma_mifirRts23_2015(RegulatoryClassificationMifirRTS23_2015 _esma_mifirRts23_2015) {
            this.esma_mifirRts23_2015 = _esma_mifirRts23_2015 == null ? null : _esma_mifirRts23_2015.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts24_2015")
        @RuneAttribute(value="esma_mifirRts24_2015")
        public RegulationDetailsBuilder setEsma_mifirRts24_2015(RegulatoryClassificationMifirRTS24_2015 _esma_mifirRts24_2015) {
            this.esma_mifirRts24_2015 = _esma_mifirRts24_2015 == null ? null : _esma_mifirRts24_2015.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="csa_derivativesReporting_2016")
        @RuneAttribute(value="csa_derivativesReporting_2016")
        public RegulationDetailsBuilder setCsa_derivativesReporting_2016(RegulatoryClassificationCSA_2016 _csa_derivativesReporting_2016) {
            this.csa_derivativesReporting_2016 = _csa_derivativesReporting_2016 == null ? null : _csa_derivativesReporting_2016.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="mas_sfa_2013")
        @RuneAttribute(value="mas_sfa_2013")
        public RegulationDetailsBuilder setMas_sfa_2013(RegulatoryClassificationMAS_2013 _mas_sfa_2013) {
            this.mas_sfa_2013 = _mas_sfa_2013 == null ? null : _mas_sfa_2013.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asic_derivativesTransactionRules_2013")
        @RuneAttribute(value="asic_derivativesTransactionRules_2013")
        public RegulationDetailsBuilder setAsic_derivativesTransactionRules_2013(RegulatoryClassificationASIC_2013 _asic_derivativesTransactionRules_2013) {
            this.asic_derivativesTransactionRules_2013 = _asic_derivativesTransactionRules_2013 == null ? null : _asic_derivativesTransactionRules_2013.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="esma_sftrRts_2019")
        @RuneAttribute(value="esma_sftrRts_2019")
        public RegulationDetailsBuilder setEsma_sftrRts_2019(RegulatoryClassificationSFTR_2019 _esma_sftrRts_2019) {
            this.esma_sftrRts_2019 = _esma_sftrRts_2019 == null ? null : _esma_sftrRts_2019.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="other")
        @RuneAttribute(value="other")
        public RegulationDetailsBuilder addOther(RegulatoryClassificationOther _other) {
            if (_other != null) {
                this.other.add(_other.toBuilder());
            }
            return this;
        }

        @Override
        public RegulationDetailsBuilder addOther(RegulatoryClassificationOther _other, int idx) {
            this.getIndex(this.other, idx, () -> _other.toBuilder());
            return this;
        }

        @Override
        public RegulationDetailsBuilder addOther(List<? extends RegulatoryClassificationOther> others) {
            if (others != null) {
                for (RegulatoryClassificationOther regulatoryClassificationOther : others) {
                    this.other.add(regulatoryClassificationOther.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="other")
        public RegulationDetailsBuilder setOther(List<? extends RegulatoryClassificationOther> others) {
            this.other = others == null ? new ArrayList<RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder>() : (List)others.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegulationDetails build() {
            return new RegulationDetailsImpl(this);
        }

        @Override
        public RegulationDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulationDetailsBuilder prune() {
            if (this.cftc_part43_2012 != null && !this.cftc_part43_2012.prune().hasData()) {
                this.cftc_part43_2012 = null;
            }
            if (this.cftc_part43_2019 != null && !this.cftc_part43_2019.prune().hasData()) {
                this.cftc_part43_2019 = null;
            }
            if (this.cftc_part45_2012 != null && !this.cftc_part45_2012.prune().hasData()) {
                this.cftc_part45_2012 = null;
            }
            if (this.cftc_part45_2019 != null && !this.cftc_part45_2019.prune().hasData()) {
                this.cftc_part45_2019 = null;
            }
            if (this.esma_emirRts_2015 != null && !this.esma_emirRts_2015.prune().hasData()) {
                this.esma_emirRts_2015 = null;
            }
            if (this.esma_mifirRts6a_2015 != null && !this.esma_mifirRts6a_2015.prune().hasData()) {
                this.esma_mifirRts6a_2015 = null;
            }
            if (this.esma_mifirRts6b_2015 != null && !this.esma_mifirRts6b_2015.prune().hasData()) {
                this.esma_mifirRts6b_2015 = null;
            }
            if (this.esma_mifirRts22_2015 != null && !this.esma_mifirRts22_2015.prune().hasData()) {
                this.esma_mifirRts22_2015 = null;
            }
            if (this.esma_mifirRts23_2015 != null && !this.esma_mifirRts23_2015.prune().hasData()) {
                this.esma_mifirRts23_2015 = null;
            }
            if (this.esma_mifirRts24_2015 != null && !this.esma_mifirRts24_2015.prune().hasData()) {
                this.esma_mifirRts24_2015 = null;
            }
            if (this.csa_derivativesReporting_2016 != null && !this.csa_derivativesReporting_2016.prune().hasData()) {
                this.csa_derivativesReporting_2016 = null;
            }
            if (this.mas_sfa_2013 != null && !this.mas_sfa_2013.prune().hasData()) {
                this.mas_sfa_2013 = null;
            }
            if (this.asic_derivativesTransactionRules_2013 != null && !this.asic_derivativesTransactionRules_2013.prune().hasData()) {
                this.asic_derivativesTransactionRules_2013 = null;
            }
            if (this.esma_sftrRts_2019 != null && !this.esma_sftrRts_2019.prune().hasData()) {
                this.esma_sftrRts_2019 = null;
            }
            this.other = this.other.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCftc_part43_2012() != null && this.getCftc_part43_2012().hasData()) {
                return true;
            }
            if (this.getCftc_part43_2019() != null && this.getCftc_part43_2019().hasData()) {
                return true;
            }
            if (this.getCftc_part45_2012() != null && this.getCftc_part45_2012().hasData()) {
                return true;
            }
            if (this.getCftc_part45_2019() != null && this.getCftc_part45_2019().hasData()) {
                return true;
            }
            if (this.getEsma_emirRts_2015() != null && this.getEsma_emirRts_2015().hasData()) {
                return true;
            }
            if (this.getEsma_mifirRts6a_2015() != null && this.getEsma_mifirRts6a_2015().hasData()) {
                return true;
            }
            if (this.getEsma_mifirRts6b_2015() != null && this.getEsma_mifirRts6b_2015().hasData()) {
                return true;
            }
            if (this.getEsma_mifirRts22_2015() != null && this.getEsma_mifirRts22_2015().hasData()) {
                return true;
            }
            if (this.getEsma_mifirRts23_2015() != null && this.getEsma_mifirRts23_2015().hasData()) {
                return true;
            }
            if (this.getEsma_mifirRts24_2015() != null && this.getEsma_mifirRts24_2015().hasData()) {
                return true;
            }
            if (this.getCsa_derivativesReporting_2016() != null && this.getCsa_derivativesReporting_2016().hasData()) {
                return true;
            }
            if (this.getMas_sfa_2013() != null && this.getMas_sfa_2013().hasData()) {
                return true;
            }
            if (this.getAsic_derivativesTransactionRules_2013() != null && this.getAsic_derivativesTransactionRules_2013().hasData()) {
                return true;
            }
            if (this.getEsma_sftrRts_2019() != null && this.getEsma_sftrRts_2019().hasData()) {
                return true;
            }
            return this.getOther() != null && this.getOther().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public RegulationDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegulationDetailsBuilder o = (RegulationDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCftc_part43_2012(), (RosettaModelObjectBuilder)o.getCftc_part43_2012(), this::setCftc_part43_2012);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCftc_part43_2019(), (RosettaModelObjectBuilder)o.getCftc_part43_2019(), this::setCftc_part43_2019);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCftc_part45_2012(), (RosettaModelObjectBuilder)o.getCftc_part45_2012(), this::setCftc_part45_2012);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCftc_part45_2019(), (RosettaModelObjectBuilder)o.getCftc_part45_2019(), this::setCftc_part45_2019);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEsma_emirRts_2015(), (RosettaModelObjectBuilder)o.getEsma_emirRts_2015(), this::setEsma_emirRts_2015);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEsma_mifirRts6a_2015(), (RosettaModelObjectBuilder)o.getEsma_mifirRts6a_2015(), this::setEsma_mifirRts6a_2015);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEsma_mifirRts6b_2015(), (RosettaModelObjectBuilder)o.getEsma_mifirRts6b_2015(), this::setEsma_mifirRts6b_2015);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEsma_mifirRts22_2015(), (RosettaModelObjectBuilder)o.getEsma_mifirRts22_2015(), this::setEsma_mifirRts22_2015);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEsma_mifirRts23_2015(), (RosettaModelObjectBuilder)o.getEsma_mifirRts23_2015(), this::setEsma_mifirRts23_2015);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEsma_mifirRts24_2015(), (RosettaModelObjectBuilder)o.getEsma_mifirRts24_2015(), this::setEsma_mifirRts24_2015);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCsa_derivativesReporting_2016(), (RosettaModelObjectBuilder)o.getCsa_derivativesReporting_2016(), this::setCsa_derivativesReporting_2016);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMas_sfa_2013(), (RosettaModelObjectBuilder)o.getMas_sfa_2013(), this::setMas_sfa_2013);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsic_derivativesTransactionRules_2013(), (RosettaModelObjectBuilder)o.getAsic_derivativesTransactionRules_2013(), this::setAsic_derivativesTransactionRules_2013);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEsma_sftrRts_2019(), (RosettaModelObjectBuilder)o.getEsma_sftrRts_2019(), this::setEsma_sftrRts_2019);
            merger.mergeRosetta(this.getOther(), o.getOther(), this::getOrCreateOther);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulationDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.cftc_part43_2012, _that.getCftc_part43_2012())) {
                return false;
            }
            if (!Objects.equals(this.cftc_part43_2019, _that.getCftc_part43_2019())) {
                return false;
            }
            if (!Objects.equals(this.cftc_part45_2012, _that.getCftc_part45_2012())) {
                return false;
            }
            if (!Objects.equals(this.cftc_part45_2019, _that.getCftc_part45_2019())) {
                return false;
            }
            if (!Objects.equals(this.esma_emirRts_2015, _that.getEsma_emirRts_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts6a_2015, _that.getEsma_mifirRts6a_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts6b_2015, _that.getEsma_mifirRts6b_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts22_2015, _that.getEsma_mifirRts22_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts23_2015, _that.getEsma_mifirRts23_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts24_2015, _that.getEsma_mifirRts24_2015())) {
                return false;
            }
            if (!Objects.equals(this.csa_derivativesReporting_2016, _that.getCsa_derivativesReporting_2016())) {
                return false;
            }
            if (!Objects.equals(this.mas_sfa_2013, _that.getMas_sfa_2013())) {
                return false;
            }
            if (!Objects.equals(this.asic_derivativesTransactionRules_2013, _that.getAsic_derivativesTransactionRules_2013())) {
                return false;
            }
            if (!Objects.equals(this.esma_sftrRts_2019, _that.getEsma_sftrRts_2019())) {
                return false;
            }
            return ListEquals.listEquals(this.other, _that.getOther());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cftc_part43_2012 != null ? this.cftc_part43_2012.hashCode() : 0);
            _result = 31 * _result + (this.cftc_part43_2019 != null ? this.cftc_part43_2019.hashCode() : 0);
            _result = 31 * _result + (this.cftc_part45_2012 != null ? this.cftc_part45_2012.hashCode() : 0);
            _result = 31 * _result + (this.cftc_part45_2019 != null ? this.cftc_part45_2019.hashCode() : 0);
            _result = 31 * _result + (this.esma_emirRts_2015 != null ? this.esma_emirRts_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts6a_2015 != null ? this.esma_mifirRts6a_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts6b_2015 != null ? this.esma_mifirRts6b_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts22_2015 != null ? this.esma_mifirRts22_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts23_2015 != null ? this.esma_mifirRts23_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts24_2015 != null ? this.esma_mifirRts24_2015.hashCode() : 0);
            _result = 31 * _result + (this.csa_derivativesReporting_2016 != null ? this.csa_derivativesReporting_2016.hashCode() : 0);
            _result = 31 * _result + (this.mas_sfa_2013 != null ? this.mas_sfa_2013.hashCode() : 0);
            _result = 31 * _result + (this.asic_derivativesTransactionRules_2013 != null ? this.asic_derivativesTransactionRules_2013.hashCode() : 0);
            _result = 31 * _result + (this.esma_sftrRts_2019 != null ? this.esma_sftrRts_2019.hashCode() : 0);
            _result = 31 * _result + (this.other != null ? this.other.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulationDetailsBuilder {cftc_part43_2012=" + String.valueOf(this.cftc_part43_2012) + ", cftc_part43_2019=" + String.valueOf(this.cftc_part43_2019) + ", cftc_part45_2012=" + String.valueOf(this.cftc_part45_2012) + ", cftc_part45_2019=" + String.valueOf(this.cftc_part45_2019) + ", esma_emirRts_2015=" + String.valueOf(this.esma_emirRts_2015) + ", esma_mifirRts6a_2015=" + String.valueOf(this.esma_mifirRts6a_2015) + ", esma_mifirRts6b_2015=" + String.valueOf(this.esma_mifirRts6b_2015) + ", esma_mifirRts22_2015=" + String.valueOf(this.esma_mifirRts22_2015) + ", esma_mifirRts23_2015=" + String.valueOf(this.esma_mifirRts23_2015) + ", esma_mifirRts24_2015=" + String.valueOf(this.esma_mifirRts24_2015) + ", csa_derivativesReporting_2016=" + String.valueOf(this.csa_derivativesReporting_2016) + ", mas_sfa_2013=" + String.valueOf(this.mas_sfa_2013) + ", asic_derivativesTransactionRules_2013=" + String.valueOf(this.asic_derivativesTransactionRules_2013) + ", esma_sftrRts_2019=" + String.valueOf(this.esma_sftrRts_2019) + ", other=" + String.valueOf(this.other) + "}";
        }
    }

    public static interface RegulationDetailsBuilder
    extends RegulationDetails,
    RosettaModelObjectBuilder {
        public RegulatoryClassificationPart43_2012.RegulatoryClassificationPart43_2012Builder getOrCreateCftc_part43_2012();

        @Override
        public RegulatoryClassificationPart43_2012.RegulatoryClassificationPart43_2012Builder getCftc_part43_2012();

        public RegulatoryClassificationPart43_2019.RegulatoryClassificationPart43_2019Builder getOrCreateCftc_part43_2019();

        @Override
        public RegulatoryClassificationPart43_2019.RegulatoryClassificationPart43_2019Builder getCftc_part43_2019();

        public RegulatoryClassificationPart45_2012.RegulatoryClassificationPart45_2012Builder getOrCreateCftc_part45_2012();

        @Override
        public RegulatoryClassificationPart45_2012.RegulatoryClassificationPart45_2012Builder getCftc_part45_2012();

        public RegulatoryClassificationPart45_2019.RegulatoryClassificationPart45_2019Builder getOrCreateCftc_part45_2019();

        @Override
        public RegulatoryClassificationPart45_2019.RegulatoryClassificationPart45_2019Builder getCftc_part45_2019();

        public RegulatoryClassificationEMIR_2015.RegulatoryClassificationEMIR_2015Builder getOrCreateEsma_emirRts_2015();

        @Override
        public RegulatoryClassificationEMIR_2015.RegulatoryClassificationEMIR_2015Builder getEsma_emirRts_2015();

        public RegulatoryClassificationMifirRTS6a_2015.RegulatoryClassificationMifirRTS6a_2015Builder getOrCreateEsma_mifirRts6a_2015();

        @Override
        public RegulatoryClassificationMifirRTS6a_2015.RegulatoryClassificationMifirRTS6a_2015Builder getEsma_mifirRts6a_2015();

        public RegulatoryClassificationMifirRTS6b_2015.RegulatoryClassificationMifirRTS6b_2015Builder getOrCreateEsma_mifirRts6b_2015();

        @Override
        public RegulatoryClassificationMifirRTS6b_2015.RegulatoryClassificationMifirRTS6b_2015Builder getEsma_mifirRts6b_2015();

        public RegulatoryClassificationMifirRTS22_2015.RegulatoryClassificationMifirRTS22_2015Builder getOrCreateEsma_mifirRts22_2015();

        @Override
        public RegulatoryClassificationMifirRTS22_2015.RegulatoryClassificationMifirRTS22_2015Builder getEsma_mifirRts22_2015();

        public RegulatoryClassificationMifirRTS23_2015.RegulatoryClassificationMifirRTS23_2015Builder getOrCreateEsma_mifirRts23_2015();

        @Override
        public RegulatoryClassificationMifirRTS23_2015.RegulatoryClassificationMifirRTS23_2015Builder getEsma_mifirRts23_2015();

        public RegulatoryClassificationMifirRTS24_2015.RegulatoryClassificationMifirRTS24_2015Builder getOrCreateEsma_mifirRts24_2015();

        @Override
        public RegulatoryClassificationMifirRTS24_2015.RegulatoryClassificationMifirRTS24_2015Builder getEsma_mifirRts24_2015();

        public RegulatoryClassificationCSA_2016.RegulatoryClassificationCSA_2016Builder getOrCreateCsa_derivativesReporting_2016();

        @Override
        public RegulatoryClassificationCSA_2016.RegulatoryClassificationCSA_2016Builder getCsa_derivativesReporting_2016();

        public RegulatoryClassificationMAS_2013.RegulatoryClassificationMAS_2013Builder getOrCreateMas_sfa_2013();

        @Override
        public RegulatoryClassificationMAS_2013.RegulatoryClassificationMAS_2013Builder getMas_sfa_2013();

        public RegulatoryClassificationASIC_2013.RegulatoryClassificationASIC_2013Builder getOrCreateAsic_derivativesTransactionRules_2013();

        @Override
        public RegulatoryClassificationASIC_2013.RegulatoryClassificationASIC_2013Builder getAsic_derivativesTransactionRules_2013();

        public RegulatoryClassificationSFTR_2019.RegulatoryClassificationSFTR_2019Builder getOrCreateEsma_sftrRts_2019();

        @Override
        public RegulatoryClassificationSFTR_2019.RegulatoryClassificationSFTR_2019Builder getEsma_sftrRts_2019();

        public RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder getOrCreateOther(int var1);

        public List<? extends RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder> getOther();

        public RegulationDetailsBuilder setCftc_part43_2012(RegulatoryClassificationPart43_2012 var1);

        public RegulationDetailsBuilder setCftc_part43_2019(RegulatoryClassificationPart43_2019 var1);

        public RegulationDetailsBuilder setCftc_part45_2012(RegulatoryClassificationPart45_2012 var1);

        public RegulationDetailsBuilder setCftc_part45_2019(RegulatoryClassificationPart45_2019 var1);

        public RegulationDetailsBuilder setEsma_emirRts_2015(RegulatoryClassificationEMIR_2015 var1);

        public RegulationDetailsBuilder setEsma_mifirRts6a_2015(RegulatoryClassificationMifirRTS6a_2015 var1);

        public RegulationDetailsBuilder setEsma_mifirRts6b_2015(RegulatoryClassificationMifirRTS6b_2015 var1);

        public RegulationDetailsBuilder setEsma_mifirRts22_2015(RegulatoryClassificationMifirRTS22_2015 var1);

        public RegulationDetailsBuilder setEsma_mifirRts23_2015(RegulatoryClassificationMifirRTS23_2015 var1);

        public RegulationDetailsBuilder setEsma_mifirRts24_2015(RegulatoryClassificationMifirRTS24_2015 var1);

        public RegulationDetailsBuilder setCsa_derivativesReporting_2016(RegulatoryClassificationCSA_2016 var1);

        public RegulationDetailsBuilder setMas_sfa_2013(RegulatoryClassificationMAS_2013 var1);

        public RegulationDetailsBuilder setAsic_derivativesTransactionRules_2013(RegulatoryClassificationASIC_2013 var1);

        public RegulationDetailsBuilder setEsma_sftrRts_2019(RegulatoryClassificationSFTR_2019 var1);

        public RegulationDetailsBuilder addOther(RegulatoryClassificationOther var1);

        public RegulationDetailsBuilder addOther(RegulatoryClassificationOther var1, int var2);

        public RegulationDetailsBuilder addOther(List<? extends RegulatoryClassificationOther> var1);

        public RegulationDetailsBuilder setOther(List<? extends RegulatoryClassificationOther> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("cftc_part43_2012"), processor, RegulatoryClassificationPart43_2012.RegulatoryClassificationPart43_2012Builder.class, this.getCftc_part43_2012(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cftc_part43_2019"), processor, RegulatoryClassificationPart43_2019.RegulatoryClassificationPart43_2019Builder.class, this.getCftc_part43_2019(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cftc_part45_2012"), processor, RegulatoryClassificationPart45_2012.RegulatoryClassificationPart45_2012Builder.class, this.getCftc_part45_2012(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cftc_part45_2019"), processor, RegulatoryClassificationPart45_2019.RegulatoryClassificationPart45_2019Builder.class, this.getCftc_part45_2019(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("esma_emirRts_2015"), processor, RegulatoryClassificationEMIR_2015.RegulatoryClassificationEMIR_2015Builder.class, this.getEsma_emirRts_2015(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("esma_mifirRts6a_2015"), processor, RegulatoryClassificationMifirRTS6a_2015.RegulatoryClassificationMifirRTS6a_2015Builder.class, this.getEsma_mifirRts6a_2015(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("esma_mifirRts6b_2015"), processor, RegulatoryClassificationMifirRTS6b_2015.RegulatoryClassificationMifirRTS6b_2015Builder.class, this.getEsma_mifirRts6b_2015(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("esma_mifirRts22_2015"), processor, RegulatoryClassificationMifirRTS22_2015.RegulatoryClassificationMifirRTS22_2015Builder.class, this.getEsma_mifirRts22_2015(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("esma_mifirRts23_2015"), processor, RegulatoryClassificationMifirRTS23_2015.RegulatoryClassificationMifirRTS23_2015Builder.class, this.getEsma_mifirRts23_2015(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("esma_mifirRts24_2015"), processor, RegulatoryClassificationMifirRTS24_2015.RegulatoryClassificationMifirRTS24_2015Builder.class, this.getEsma_mifirRts24_2015(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("csa_derivativesReporting_2016"), processor, RegulatoryClassificationCSA_2016.RegulatoryClassificationCSA_2016Builder.class, this.getCsa_derivativesReporting_2016(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("mas_sfa_2013"), processor, RegulatoryClassificationMAS_2013.RegulatoryClassificationMAS_2013Builder.class, this.getMas_sfa_2013(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asic_derivativesTransactionRules_2013"), processor, RegulatoryClassificationASIC_2013.RegulatoryClassificationASIC_2013Builder.class, this.getAsic_derivativesTransactionRules_2013(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("esma_sftrRts_2019"), processor, RegulatoryClassificationSFTR_2019.RegulatoryClassificationSFTR_2019Builder.class, this.getEsma_sftrRts_2019(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("other"), processor, RegulatoryClassificationOther.RegulatoryClassificationOtherBuilder.class, this.getOther(), new AttributeMeta[0]);
        }

        public RegulationDetailsBuilder prune();
    }

    public static class RegulationDetailsImpl
    implements RegulationDetails {
        private final RegulatoryClassificationPart43_2012 cftc_part43_2012;
        private final RegulatoryClassificationPart43_2019 cftc_part43_2019;
        private final RegulatoryClassificationPart45_2012 cftc_part45_2012;
        private final RegulatoryClassificationPart45_2019 cftc_part45_2019;
        private final RegulatoryClassificationEMIR_2015 esma_emirRts_2015;
        private final RegulatoryClassificationMifirRTS6a_2015 esma_mifirRts6a_2015;
        private final RegulatoryClassificationMifirRTS6b_2015 esma_mifirRts6b_2015;
        private final RegulatoryClassificationMifirRTS22_2015 esma_mifirRts22_2015;
        private final RegulatoryClassificationMifirRTS23_2015 esma_mifirRts23_2015;
        private final RegulatoryClassificationMifirRTS24_2015 esma_mifirRts24_2015;
        private final RegulatoryClassificationCSA_2016 csa_derivativesReporting_2016;
        private final RegulatoryClassificationMAS_2013 mas_sfa_2013;
        private final RegulatoryClassificationASIC_2013 asic_derivativesTransactionRules_2013;
        private final RegulatoryClassificationSFTR_2019 esma_sftrRts_2019;
        private final List<? extends RegulatoryClassificationOther> other;

        protected RegulationDetailsImpl(RegulationDetailsBuilder builder) {
            this.cftc_part43_2012 = Optional.ofNullable(builder.getCftc_part43_2012()).map(f -> f.build()).orElse(null);
            this.cftc_part43_2019 = Optional.ofNullable(builder.getCftc_part43_2019()).map(f -> f.build()).orElse(null);
            this.cftc_part45_2012 = Optional.ofNullable(builder.getCftc_part45_2012()).map(f -> f.build()).orElse(null);
            this.cftc_part45_2019 = Optional.ofNullable(builder.getCftc_part45_2019()).map(f -> f.build()).orElse(null);
            this.esma_emirRts_2015 = Optional.ofNullable(builder.getEsma_emirRts_2015()).map(f -> f.build()).orElse(null);
            this.esma_mifirRts6a_2015 = Optional.ofNullable(builder.getEsma_mifirRts6a_2015()).map(f -> f.build()).orElse(null);
            this.esma_mifirRts6b_2015 = Optional.ofNullable(builder.getEsma_mifirRts6b_2015()).map(f -> f.build()).orElse(null);
            this.esma_mifirRts22_2015 = Optional.ofNullable(builder.getEsma_mifirRts22_2015()).map(f -> f.build()).orElse(null);
            this.esma_mifirRts23_2015 = Optional.ofNullable(builder.getEsma_mifirRts23_2015()).map(f -> f.build()).orElse(null);
            this.esma_mifirRts24_2015 = Optional.ofNullable(builder.getEsma_mifirRts24_2015()).map(f -> f.build()).orElse(null);
            this.csa_derivativesReporting_2016 = Optional.ofNullable(builder.getCsa_derivativesReporting_2016()).map(f -> f.build()).orElse(null);
            this.mas_sfa_2013 = Optional.ofNullable(builder.getMas_sfa_2013()).map(f -> f.build()).orElse(null);
            this.asic_derivativesTransactionRules_2013 = Optional.ofNullable(builder.getAsic_derivativesTransactionRules_2013()).map(f -> f.build()).orElse(null);
            this.esma_sftrRts_2019 = Optional.ofNullable(builder.getEsma_sftrRts_2019()).map(f -> f.build()).orElse(null);
            this.other = Optional.ofNullable(builder.getOther()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="cftc_part43_2012")
        @RuneAttribute(value="cftc_part43_2012")
        public RegulatoryClassificationPart43_2012 getCftc_part43_2012() {
            return this.cftc_part43_2012;
        }

        @Override
        @RosettaAttribute(value="cftc_part43_2019")
        @RuneAttribute(value="cftc_part43_2019")
        public RegulatoryClassificationPart43_2019 getCftc_part43_2019() {
            return this.cftc_part43_2019;
        }

        @Override
        @RosettaAttribute(value="cftc_part45_2012")
        @RuneAttribute(value="cftc_part45_2012")
        public RegulatoryClassificationPart45_2012 getCftc_part45_2012() {
            return this.cftc_part45_2012;
        }

        @Override
        @RosettaAttribute(value="cftc_part45_2019")
        @RuneAttribute(value="cftc_part45_2019")
        public RegulatoryClassificationPart45_2019 getCftc_part45_2019() {
            return this.cftc_part45_2019;
        }

        @Override
        @RosettaAttribute(value="esma_emirRts_2015")
        @RuneAttribute(value="esma_emirRts_2015")
        public RegulatoryClassificationEMIR_2015 getEsma_emirRts_2015() {
            return this.esma_emirRts_2015;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts6a_2015")
        @RuneAttribute(value="esma_mifirRts6a_2015")
        public RegulatoryClassificationMifirRTS6a_2015 getEsma_mifirRts6a_2015() {
            return this.esma_mifirRts6a_2015;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts6b_2015")
        @RuneAttribute(value="esma_mifirRts6b_2015")
        public RegulatoryClassificationMifirRTS6b_2015 getEsma_mifirRts6b_2015() {
            return this.esma_mifirRts6b_2015;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts22_2015")
        @RuneAttribute(value="esma_mifirRts22_2015")
        public RegulatoryClassificationMifirRTS22_2015 getEsma_mifirRts22_2015() {
            return this.esma_mifirRts22_2015;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts23_2015")
        @RuneAttribute(value="esma_mifirRts23_2015")
        public RegulatoryClassificationMifirRTS23_2015 getEsma_mifirRts23_2015() {
            return this.esma_mifirRts23_2015;
        }

        @Override
        @RosettaAttribute(value="esma_mifirRts24_2015")
        @RuneAttribute(value="esma_mifirRts24_2015")
        public RegulatoryClassificationMifirRTS24_2015 getEsma_mifirRts24_2015() {
            return this.esma_mifirRts24_2015;
        }

        @Override
        @RosettaAttribute(value="csa_derivativesReporting_2016")
        @RuneAttribute(value="csa_derivativesReporting_2016")
        public RegulatoryClassificationCSA_2016 getCsa_derivativesReporting_2016() {
            return this.csa_derivativesReporting_2016;
        }

        @Override
        @RosettaAttribute(value="mas_sfa_2013")
        @RuneAttribute(value="mas_sfa_2013")
        public RegulatoryClassificationMAS_2013 getMas_sfa_2013() {
            return this.mas_sfa_2013;
        }

        @Override
        @RosettaAttribute(value="asic_derivativesTransactionRules_2013")
        @RuneAttribute(value="asic_derivativesTransactionRules_2013")
        public RegulatoryClassificationASIC_2013 getAsic_derivativesTransactionRules_2013() {
            return this.asic_derivativesTransactionRules_2013;
        }

        @Override
        @RosettaAttribute(value="esma_sftrRts_2019")
        @RuneAttribute(value="esma_sftrRts_2019")
        public RegulatoryClassificationSFTR_2019 getEsma_sftrRts_2019() {
            return this.esma_sftrRts_2019;
        }

        @Override
        @RosettaAttribute(value="other")
        @RuneAttribute(value="other")
        public List<? extends RegulatoryClassificationOther> getOther() {
            return this.other;
        }

        @Override
        public RegulationDetails build() {
            return this;
        }

        @Override
        public RegulationDetailsBuilder toBuilder() {
            RegulationDetailsBuilder builder = RegulationDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulationDetailsBuilder builder) {
            Optional.ofNullable(this.getCftc_part43_2012()).ifPresent(builder::setCftc_part43_2012);
            Optional.ofNullable(this.getCftc_part43_2019()).ifPresent(builder::setCftc_part43_2019);
            Optional.ofNullable(this.getCftc_part45_2012()).ifPresent(builder::setCftc_part45_2012);
            Optional.ofNullable(this.getCftc_part45_2019()).ifPresent(builder::setCftc_part45_2019);
            Optional.ofNullable(this.getEsma_emirRts_2015()).ifPresent(builder::setEsma_emirRts_2015);
            Optional.ofNullable(this.getEsma_mifirRts6a_2015()).ifPresent(builder::setEsma_mifirRts6a_2015);
            Optional.ofNullable(this.getEsma_mifirRts6b_2015()).ifPresent(builder::setEsma_mifirRts6b_2015);
            Optional.ofNullable(this.getEsma_mifirRts22_2015()).ifPresent(builder::setEsma_mifirRts22_2015);
            Optional.ofNullable(this.getEsma_mifirRts23_2015()).ifPresent(builder::setEsma_mifirRts23_2015);
            Optional.ofNullable(this.getEsma_mifirRts24_2015()).ifPresent(builder::setEsma_mifirRts24_2015);
            Optional.ofNullable(this.getCsa_derivativesReporting_2016()).ifPresent(builder::setCsa_derivativesReporting_2016);
            Optional.ofNullable(this.getMas_sfa_2013()).ifPresent(builder::setMas_sfa_2013);
            Optional.ofNullable(this.getAsic_derivativesTransactionRules_2013()).ifPresent(builder::setAsic_derivativesTransactionRules_2013);
            Optional.ofNullable(this.getEsma_sftrRts_2019()).ifPresent(builder::setEsma_sftrRts_2019);
            Optional.ofNullable(this.getOther()).ifPresent(builder::setOther);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulationDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.cftc_part43_2012, _that.getCftc_part43_2012())) {
                return false;
            }
            if (!Objects.equals(this.cftc_part43_2019, _that.getCftc_part43_2019())) {
                return false;
            }
            if (!Objects.equals(this.cftc_part45_2012, _that.getCftc_part45_2012())) {
                return false;
            }
            if (!Objects.equals(this.cftc_part45_2019, _that.getCftc_part45_2019())) {
                return false;
            }
            if (!Objects.equals(this.esma_emirRts_2015, _that.getEsma_emirRts_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts6a_2015, _that.getEsma_mifirRts6a_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts6b_2015, _that.getEsma_mifirRts6b_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts22_2015, _that.getEsma_mifirRts22_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts23_2015, _that.getEsma_mifirRts23_2015())) {
                return false;
            }
            if (!Objects.equals(this.esma_mifirRts24_2015, _that.getEsma_mifirRts24_2015())) {
                return false;
            }
            if (!Objects.equals(this.csa_derivativesReporting_2016, _that.getCsa_derivativesReporting_2016())) {
                return false;
            }
            if (!Objects.equals(this.mas_sfa_2013, _that.getMas_sfa_2013())) {
                return false;
            }
            if (!Objects.equals(this.asic_derivativesTransactionRules_2013, _that.getAsic_derivativesTransactionRules_2013())) {
                return false;
            }
            if (!Objects.equals(this.esma_sftrRts_2019, _that.getEsma_sftrRts_2019())) {
                return false;
            }
            return ListEquals.listEquals(this.other, _that.getOther());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cftc_part43_2012 != null ? this.cftc_part43_2012.hashCode() : 0);
            _result = 31 * _result + (this.cftc_part43_2019 != null ? this.cftc_part43_2019.hashCode() : 0);
            _result = 31 * _result + (this.cftc_part45_2012 != null ? this.cftc_part45_2012.hashCode() : 0);
            _result = 31 * _result + (this.cftc_part45_2019 != null ? this.cftc_part45_2019.hashCode() : 0);
            _result = 31 * _result + (this.esma_emirRts_2015 != null ? this.esma_emirRts_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts6a_2015 != null ? this.esma_mifirRts6a_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts6b_2015 != null ? this.esma_mifirRts6b_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts22_2015 != null ? this.esma_mifirRts22_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts23_2015 != null ? this.esma_mifirRts23_2015.hashCode() : 0);
            _result = 31 * _result + (this.esma_mifirRts24_2015 != null ? this.esma_mifirRts24_2015.hashCode() : 0);
            _result = 31 * _result + (this.csa_derivativesReporting_2016 != null ? this.csa_derivativesReporting_2016.hashCode() : 0);
            _result = 31 * _result + (this.mas_sfa_2013 != null ? this.mas_sfa_2013.hashCode() : 0);
            _result = 31 * _result + (this.asic_derivativesTransactionRules_2013 != null ? this.asic_derivativesTransactionRules_2013.hashCode() : 0);
            _result = 31 * _result + (this.esma_sftrRts_2019 != null ? this.esma_sftrRts_2019.hashCode() : 0);
            _result = 31 * _result + (this.other != null ? this.other.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulationDetails {cftc_part43_2012=" + String.valueOf(this.cftc_part43_2012) + ", cftc_part43_2019=" + String.valueOf(this.cftc_part43_2019) + ", cftc_part45_2012=" + String.valueOf(this.cftc_part45_2012) + ", cftc_part45_2019=" + String.valueOf(this.cftc_part45_2019) + ", esma_emirRts_2015=" + String.valueOf(this.esma_emirRts_2015) + ", esma_mifirRts6a_2015=" + String.valueOf(this.esma_mifirRts6a_2015) + ", esma_mifirRts6b_2015=" + String.valueOf(this.esma_mifirRts6b_2015) + ", esma_mifirRts22_2015=" + String.valueOf(this.esma_mifirRts22_2015) + ", esma_mifirRts23_2015=" + String.valueOf(this.esma_mifirRts23_2015) + ", esma_mifirRts24_2015=" + String.valueOf(this.esma_mifirRts24_2015) + ", csa_derivativesReporting_2016=" + String.valueOf(this.csa_derivativesReporting_2016) + ", mas_sfa_2013=" + String.valueOf(this.mas_sfa_2013) + ", asic_derivativesTransactionRules_2013=" + String.valueOf(this.asic_derivativesTransactionRules_2013) + ", esma_sftrRts_2019=" + String.valueOf(this.esma_sftrRts_2019) + ", other=" + String.valueOf(this.other) + "}";
        }
    }
}

